/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.sslinspection;

import com.ubnt.data.Site;
import com.ubnt.model.api.sslinspection.application.SslInspectionCategoryDto;
import com.ubnt.model.api.sslinspection.application.SslInspectionSearchEngineDto;
import com.ubnt.model.api.sslinspection.certificate.SslInspectionCertificateDto;
import com.ubnt.model.api.sslinspection.certificate.SslInspectionGenerateCertificateRequestDto;
import com.ubnt.model.api.sslinspection.certificate.SslInspectionUploadCertificateRequestDto;
import com.ubnt.model.api.sslinspection.certificate.SslInspectionValidateCertificateRequestDto;
import com.ubnt.model.api.sslinspection.profile.SslInspectionProfileDto;
import com.ubnt.model.api.sslinspection.setting.SslInspectionSettingDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowApiToken;
import com.ubnt.net.v2.config.security.annotation.AllowUCoreLocal;
import com.ubnt.net.v2.sslinspection.SslInspectionCertificateNotFound;
import com.ubnt.service.sslinspection.application.void;
import com.ubnt.service.sslinspection.certificate.C;
import com.ubnt.service.sslinspection.certificate.I;
import com.ubnt.service.sslinspection.profile.SslInspectionProfileDocument;
import com.ubnt.service.sslinspection.setting.B;
import com.ubnt.service.sslinspection.setting.ooOO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.time.Clock;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="SSL Inspection")
public class SslInspectionController {
    private static final String o00000 = "Since 8.2.85";
    private final Clock \u00d500000;
    private final com.ubnt.service.sslinspection.C new;
    private final ooOO \u00d400000;
    private final C \u00d300000;

    public SslInspectionController(Clock clock, com.ubnt.service.sslinspection.C c2, ooOO ooOO2, C c3) {
        this.\u00d500000 = clock;
        this.new = c2;
        this.\u00d400000 = ooOO2;
        this.\u00d300000 = c3;
    }

    @PostMapping(value={"/api/site/{siteName}/ssl-inspection/applications"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @AllowApiToken
    @Operation(summary="Upload Applications for SSL Inspection from firmware", description="Since 8.2.85")
    public void uploadApplications(@PathVariable(value="siteName") Site site, @RequestParam(value="file") MultipartFile multipartFile) {
        void void_ = this.new.\u00d600000(site.getId(), multipartFile);
        this.new.int(void_.\u00d300000());
    }

    @GetMapping(value={"/api/site/{siteName}/ssl-inspection/search-engines"})
    @Operation(summary="List Search Engines for SSL Inspection", description="Since 8.2.85")
    public List<SslInspectionSearchEngineDto> listSearchEngineApplications(@PathVariable(value="siteName") Site site) {
        return this.new.\u00f400000().stream().map(SslInspectionSearchEngineDto::ofModel).toList();
    }

    @GetMapping(value={"/api/site/{siteName}/ssl-inspection/categories"})
    @Operation(summary="List Categories for SSL Inspection", description="Since 8.2.85")
    public List<SslInspectionCategoryDto> listCategories(@PathVariable(value="siteName") Site site) {
        return this.new.\u00d8O0000(site.getId()).stream().map(SslInspectionCategoryDto::ofModel).toList();
    }

    @GetMapping(value={"/api/site/{siteName}/ssl-inspection/file-extensions"})
    @Operation(summary="List Files for SSL Inspection", description="Since 8.2.85")
    public List<String> listFileExtensions(@PathVariable(value="siteName") Site site) {
        return this.new.class();
    }

    @GetMapping(value={"/api/site/{siteName}/ssl-inspection/profiles"})
    @Operation(summary="List Profiles for SSL Inspection", description="Since 8.2.85")
    public List<SslInspectionProfileDto> listProfiles(@PathVariable(value="siteName") Site site) {
        return this.new.\u00f600000(site.getId()).stream().map(SslInspectionProfileDto::ofDocument).toList();
    }

    @PostMapping(value={"/api/site/{siteName}/ssl-inspection/profiles"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create Profile for SSL Inspection", description="Since 8.2.85")
    public SslInspectionProfileDto createProfile(@PathVariable(value="siteName") Site site, @Valid @RequestBody SslInspectionProfileDto sslInspectionProfileDto) {
        SslInspectionProfileDocument sslInspectionProfileDocument = this.new.OO0000(sslInspectionProfileDto.toNewDocument(site.getId()));
        return SslInspectionProfileDto.ofDocument(sslInspectionProfileDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/ssl-inspection/profiles/{profileId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update Profile for SSL Inspection", description="Since 8.2.85")
    public SslInspectionProfileDto updateProfile(@PathVariable(value="siteName") Site site, @PathVariable(value="profileId") String string, @Valid @RequestBody SslInspectionProfileDto sslInspectionProfileDto) {
        SslInspectionProfileDocument sslInspectionProfileDocument = this.new.\u00d800000(sslInspectionProfileDto.toDocument(site.getId(), string));
        return SslInspectionProfileDto.ofDocument(sslInspectionProfileDocument);
    }

    @DeleteMapping(value={"/api/site/{siteName}/ssl-inspection/profiles/{profileId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete Profile for SSL Inspection", description="Since 8.2.85")
    public void deleteProfile(@PathVariable(value="siteName") Site site, @PathVariable(value="profileId") String string) {
        this.new.\u00d2O0000(site.getId(), string);
    }

    @GetMapping(value={"/api/site/{siteName}/ssl-inspection/profiles/defaults"})
    @Operation(summary="Read Defaults for Profile for SSL Inspection", description="Since 8.2.85")
    public SslInspectionProfileDto readProfileDefaults(@PathVariable(value="siteName") Site site) {
        return SslInspectionProfileDto.ofDocument(this.new.\u00f800000(site.getId()));
    }

    @Operation(summary="Get default SSL Inspection setting", description="Since 8.2.85")
    @GetMapping(value={"/api/site/{siteName}/ssl-inspection/setting/defaults"})
    public SslInspectionSettingDto getDefaults(@PathVariable(value="siteName") Site site) {
        return SslInspectionSettingDto.of(this.\u00d400000.\u00d600000(site.getId()));
    }

    @Operation(summary="Get SSL Inspection setting", description="Since 8.2.85")
    @GetMapping(value={"/api/site/{siteName}/ssl-inspection/setting"})
    public SslInspectionSettingDto getSetting(@PathVariable(value="siteName") Site site) {
        return SslInspectionSettingDto.of(this.\u00d400000.o00000(site.getId()));
    }

    @Operation(summary="Update SSL Inspection setting", description="Since 8.2.85")
    @ResponseStatus(value=HttpStatus.OK)
    @PutMapping(value={"/api/site/{siteName}/ssl-inspection/setting"})
    public SslInspectionSettingDto updateSetting(@PathVariable(value="siteName") Site site, @RequestBody @Valid SslInspectionSettingDto sslInspectionSettingDto) {
        B b2 = B.\u00d6\u00d40000(site.getId(), sslInspectionSettingDto);
        B b3 = this.\u00d400000.\u00d400000(b2);
        return SslInspectionSettingDto.of(b3);
    }

    @Operation(summary="Get SSL Inspection certificates", description="Since 8.2.85")
    @GetMapping(value={"/api/site/{siteName}/ssl-inspection/certificates"})
    public List<SslInspectionCertificateDto> getCertificates(@PathVariable(value="siteName") Site site) {
        return this.\u00d300000.\u00f500000(site.getId()).stream().map(sslCertificateDocument -> SslInspectionCertificateDto.ofDocument(sslCertificateDocument, this.\u00d500000.instant().toEpochMilli())).toList();
    }

    @Operation(summary="Get SSL Inspection active certificate", description="Since 8.2.85")
    @GetMapping(value={"/api/site/{siteName}/ssl-inspection/certificates/active"})
    @AllowUCoreLocal
    public SslInspectionCertificateDto getActiveCertificate(@PathVariable(value="siteName") Site site) {
        return this.\u00d300000.\u00d3O0000(site.getId()).map(sslCertificateDocument -> SslInspectionCertificateDto.ofDocument(sslCertificateDocument, this.\u00d500000.instant().toEpochMilli())).orElseThrow(SslInspectionCertificateNotFound::new);
    }

    @Operation(summary="Generate SSL Inspection certificate", description="Since 8.2.85")
    @PostMapping(value={"/api/site/{siteName}/ssl-inspection/certificates/generate"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public SslInspectionCertificateDto generateCertificate(@PathVariable(value="siteName") Site site, @RequestBody @Valid SslInspectionGenerateCertificateRequestDto sslInspectionGenerateCertificateRequestDto) {
        return SslInspectionCertificateDto.ofDocument(this.\u00d300000.for(site.getId(), I.\u00d400000().\u00d500000(sslInspectionGenerateCertificateRequestDto.name()).\u00d600000(sslInspectionGenerateCertificateRequestDto.commonName()).\u00d800000(sslInspectionGenerateCertificateRequestDto.alternativeName()).\u00d300000()), this.\u00d500000.instant().toEpochMilli());
    }

    @Operation(summary="Activate SSL Inspection certificate", description="Since 8.2.85")
    @PostMapping(value={"/api/site/{siteName}/ssl-inspection/certificates/{certificateId}/activate"})
    @ResponseStatus(value=HttpStatus.OK)
    public void activateCertificate(@PathVariable(value="siteName") Site site, @PathVariable(value="certificateId") String string) {
        this.\u00d300000.oO0000(site.getId(), string);
    }

    @Operation(summary="Delete SSL Inspectioncertificate", description="Since 8.2.85")
    @DeleteMapping(value={"/api/site/{siteName}/ssl-inspection/certificates/{certificateId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteCertificate(@PathVariable(value="siteName") Site site, @PathVariable(value="certificateId") String string) {
        this.\u00d300000.\u00f600000(string);
    }

    @Operation(summary="Upload SSL Inspection certificate", description="Since 8.2.85")
    @PostMapping(value={"/api/site/{siteName}/ssl-inspection/certificates"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public SslInspectionCertificateDto uploadCertificate(@PathVariable(value="siteName") Site site, @RequestBody @Valid SslInspectionUploadCertificateRequestDto sslInspectionUploadCertificateRequestDto) {
        return SslInspectionCertificateDto.ofDocument(this.\u00d300000.String(site.getId(), sslInspectionUploadCertificateRequestDto), this.\u00d500000.instant().toEpochMilli());
    }

    @Operation(summary="Validate SSL Inspection certificate", description="Since 8.2.85")
    @PostMapping(value={"/api/site/{siteName}/ssl-inspection/certificates/validate"})
    @ResponseStatus(value=HttpStatus.OK)
    public void validateCertificate(@PathVariable(value="siteName") Site site, @RequestBody @Valid SslInspectionValidateCertificateRequestDto sslInspectionValidateCertificateRequestDto) {
        this.\u00d300000.\u00d300000(sslInspectionValidateCertificateRequestDto);
    }
}

