/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.staticdns;

import com.ubnt.data.Site;
import com.ubnt.model.api.staticdns.DeviceLocalDnsDto;
import com.ubnt.model.api.staticdns.StaticDnsDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.localdns.A;
import com.ubnt.service.staticdns.C;
import com.ubnt.service.staticdns.StaticDnsDocument;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="Static DNS")
@Validated
public class StaticDnsController {
    private final C new;
    private final A o00000;

    public StaticDnsController(C c2, A a2) {
        this.new = c2;
        this.o00000 = a2;
    }

    @GetMapping(value={"/api/site/{siteName}/static-dns/devices"})
    public List<DeviceLocalDnsDto> getDeviceLocalDnsEntries(@PathVariable(value="siteName") Site site) {
        return this.o00000.o00000(site.getId()).stream().map(DeviceLocalDnsDto::ofLegacy).toList();
    }

    @GetMapping(value={"/api/site/{siteName}/static-dns"})
    public List<StaticDnsDto> getStaticDnsEntries(@PathVariable(value="siteName") Site site) {
        return this.new.class(site.getId()).stream().map(StaticDnsDto::ofDocument).toList();
    }

    @PostMapping(value={"/api/site/{siteName}/static-dns"})
    public StaticDnsDto createStaticDnsEntry(@PathVariable(value="siteName") Site site, @RequestBody @Valid StaticDnsDto staticDnsDto) {
        StaticDnsDocument staticDnsDocument = staticDnsDto.toDocument(site.getId());
        return StaticDnsDto.ofDocument(this.new.\u00d3O0000(staticDnsDocument));
    }

    @PutMapping(value={"/api/site/{siteName}/static-dns/{id}"})
    public StaticDnsDto updateStaticDnsEntry(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string, @RequestBody @Valid StaticDnsDto staticDnsDto) {
        StaticDnsDocument staticDnsDocument = staticDnsDto.toDocument(string, site.getId());
        return StaticDnsDto.ofDocument(this.new.\u00d600000(site.getId(), string, staticDnsDocument));
    }

    @DeleteMapping(value={"/api/site/{siteName}/static-dns/{id}"})
    public void deleteStaticDnsEntry(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        this.new.\u00d8O0000(site.getId(), string);
    }
}

