/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.systemlog;

import com.ubnt.data.Site;
import com.ubnt.model.api.PaginatedSortableRequestWithTimestamp;
import com.ubnt.model.api.alert.AlertCountDto;
import com.ubnt.model.api.alert.AlertDto;
import com.ubnt.model.api.alert.AlertListDto;
import com.ubnt.model.api.alert.AlertSettingDto;
import com.ubnt.model.api.alert.AlertSettingItemUpdateDto;
import com.ubnt.model.api.alert.AlertSettingUpdateDto;
import com.ubnt.model.api.alert.AllSystemLogListParameterDto;
import com.ubnt.model.api.alert.CefLogDto;
import com.ubnt.model.api.alert.CountSystemLogsParameterDto;
import com.ubnt.model.api.alert.CriticalSystemLogListParameterDto;
import com.ubnt.net.security.G;
import com.ubnt.net.security.role.B;
import com.ubnt.net.security.role.String;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.net.v2.exception.UserNotAuthenticatedException;
import com.ubnt.service.alert.AlertDocument;
import com.ubnt.service.alert.DA;
import com.ubnt.service.alert._;
import com.ubnt.service.alert.d;
import com.ubnt.service.alert.ifnew;
import com.ubnt.service.alert.int;
import com.ubnt.service.alert.ooOo;
import com.ubnt.service.alert.setting.AlertSettingDocument;
import com.ubnt.service.alert.setting.F;
import com.ubnt.service.alert.setting.SystemLogItemSettingDocumentPart;
import com.ubnt.service.remotelog.OooO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.function.TriFunction;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="System Log")
public class SystemLogController {
    private final DA new;
    private final ifnew o00000;
    private final F \u00d500000;
    private final OooO return;
    private final G \u00d400000;
    private final int \u00d300000;
    private final B \u00d800000;

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/system-log/all"})
    public AlertListDto listAllSystemLogs(@PathVariable(value="siteName") Site site, @RequestBody @Valid AllSystemLogListParameterDto allSystemLogListParameterDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00d200000(httpServletRequest, httpServletResponse, site, allSystemLogListParameterDto, this.o00000::\u00d4O0000);
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/system-log/count"})
    public AlertCountDto countSystemLogs(@PathVariable(value="siteName") Site site, @RequestBody @Valid CountSystemLogsParameterDto countSystemLogsParameterDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.for(httpServletRequest, httpServletResponse, site, countSystemLogsParameterDto);
    }

    @GetMapping(value={"/api/site/{siteName}/system-log/{id}/cef"})
    public ResponseEntity<CefLogDto> getCefLog(@PathVariable(value="siteName") Site site, @PathVariable(value="id") java.lang.String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string3 = this.null(site, httpServletRequest, httpServletResponse);
        return this.o00000.classsuper(site.getId(), string2, string3).map(this.return::o00000).map(string -> CefLogDto.builder().cefLog((java.lang.String)string).build()).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/system-log/critical"})
    public List<AlertDto> listCriticalSystemLogs(@PathVariable(value="siteName") Site site, @RequestBody @Valid CriticalSystemLogListParameterDto criticalSystemLogListParameterDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.null(site, httpServletRequest, httpServletResponse);
        List<AlertDocument> list = this.\u00d300000.o00000(site.getId(), string, criticalSystemLogListParameterDto);
        return this.new.\u00d600000(list, false);
    }

    @PutMapping(value={"/api/site/{siteName}/system-log/critical/mark-all-as-read"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Mark as read aggregated Critical logs. It means that marking one of them as read should mark also another from the same group")
    public void markAllCriticalLogsAsRead(@PathVariable(value="siteName") Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.null(site, httpServletRequest, httpServletResponse);
        this.\u00d300000.o\u00d20000(site.getId(), string);
    }

    @PutMapping(value={"/api/site/{siteName}/system-log/critical/{alertId}/mark-as-read"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Mark as read a single aggregated critical log. It means that marking as read should mark also another from the same group")
    public void markCriticalLogsAsRead(@PathVariable(value="siteName") Site site, @PathVariable(value="alertId") java.lang.String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string2 = this.null(site, httpServletRequest, httpServletResponse);
        this.\u00d300000.\u00f500000(site.getId(), string2, string);
    }

    @GetMapping(value={"/api/site/{siteName}/system-log/setting"})
    @Operation(summary="Get System log settings")
    public AlertSettingDto getSystemLogSettings(@PathVariable(value="siteName") Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.String(httpServletRequest, httpServletResponse, string -> AlertSettingDto.fromDocument(this.\u00d500000.\u00d200000((java.lang.String)string, site.getId())));
    }

    @GetMapping(value={"/api/site/{siteName}/system-log/setting/defaults"})
    @Operation(summary="Get System log setting defaults")
    public AlertSettingDto getSystemLogSettingDefaults(@PathVariable(value="siteName") Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.String(httpServletRequest, httpServletResponse, string -> AlertSettingDto.fromDocument(this.\u00d500000.Object((java.lang.String)string, site.getId())));
    }

    @PutMapping(value={"/api/site/{siteName}/system-log/setting"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update System log settings")
    public AlertSettingDto updateSystemLogSettings(@PathVariable(value="siteName") Site site, @RequestBody AlertSettingUpdateDto alertSettingUpdateDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.String(httpServletRequest, httpServletResponse, string -> {
            this.\u00d500000.\u00d400000((java.lang.String)string, alertSettingDocument -> this.\u00d600000(alertSettingUpdateDto, (AlertSettingDocument)alertSettingDocument));
            return AlertSettingDto.fromDocument(this.\u00d500000.\u00d200000((java.lang.String)string, site.getId()));
        });
    }

    private AlertCountDto for(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Site site, CountSystemLogsParameterDto countSystemLogsParameterDto) {
        String string = this.null(site, httpServletRequest, httpServletResponse);
        return this.o00000.intsuper(site, countSystemLogsParameterDto, string);
    }

    private <T extends PaginatedSortableRequestWithTimestamp> AlertListDto \u00d200000(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Site site, T t2, TriFunction<Site, T, String, ooOo> triFunction) {
        String string = this.null(site, httpServletRequest, httpServletResponse);
        ooOo ooOo2 = (ooOo)triFunction.apply((Object)site, t2, (Object)string);
        return AlertListDto.builder().totalElementCount(ooOo2.\u00d300000()).totalPageCount(ooOo2.\u00d400000()).pageNumber(ooOo2.o00000()).data(this.new.\u00d600000(ooOo2.new(), false)).build();
    }

    private AlertSettingDto String(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Function<java.lang.String, AlertSettingDto> function) {
        return this.\u00d400000.o00000(httpServletRequest, httpServletResponse).flatMap(x2 -> Optional.ofNullable(x2.getString("admin_id"))).map(function).orElseThrow(() -> new UserNotAuthenticatedException(httpServletRequest.getRequestURI()));
    }

    private String null(Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00d800000.\u00d300000(httpServletRequest, httpServletResponse, site.getId());
    }

    private AlertSettingDocument \u00d600000(AlertSettingUpdateDto alertSettingUpdateDto, AlertSettingDocument alertSettingDocument) {
        return alertSettingDocument.builderOfCurrent().o00000(alertSettingUpdateDto.settingPreference()).\u00f500000(this.\u00f800000(alertSettingUpdateDto)).\u00d200000();
    }

    private Map<_, SystemLogItemSettingDocumentPart> \u00f800000(AlertSettingUpdateDto alertSettingUpdateDto) {
        if (com.ubnt.service.alert.setting.B.o00000 == alertSettingUpdateDto.settingPreference()) {
            if (alertSettingUpdateDto.alertTypeSettings() == null || alertSettingUpdateDto.alertTypeSettings().isEmpty()) {
                return alertSettingUpdateDto.alertEventSettings().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AlertSettingItemUpdateDto)entry.getValue()).toDocument()));
            }
            Map<d, AlertSettingItemUpdateDto> map = alertSettingUpdateDto.alertTypeSettings();
            return _.Oo0000.stream().filter(_2 -> _2.\u00d800000() != null).collect(Collectors.toMap(Function.identity(), _2 -> Optional.ofNullable((AlertSettingItemUpdateDto)map.get((Object)_2.\u00d800000())).map(AlertSettingItemUpdateDto::toDocument).orElse(SystemLogItemSettingDocumentPart.ALL_OFF)));
        }
        return Collections.emptyMap();
    }

    @ConstructorProperties(value={"alertDocumentMapper", "alertSearchService", "alertSettingService", "cefLogService", "loginInfoService", "nextAiLogDashboardService", "roleManager"})
    @Generated
    public SystemLogController(DA dA2, ifnew ifnew2, F f2, OooO oooO2, G g2, int intVal, B b2) {
        this.new = dA2;
        this.o00000 = ifnew2;
        this.\u00d500000 = f2;
        this.return = oooO2;
        this.\u00d400000 = g2;
        this.\u00d300000 = intVal;
        this.\u00d800000 = b2;
    }
}

