/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration.mapper;

import com.ubnt.service.orchestration.dto.OrchestrationApplyDataDto;
import com.ubnt.service.orchestration.dto.OrchestrationRemoveDataDto;
import com.ubnt.service.orchestration.dto.OrchestrationSessionIdentifierDto;
import com.ubnt.service.orchestration.dto.fetch.OrchestrationTemplatesFetchResponseDto;
import com.ubnt.service.orchestration.dto.fetch.templates.AbstractTemplateDto;
import com.ubnt.service.orchestration.dto.fetch.templates.NetworkTemplateDto;
import com.ubnt.service.orchestration.dto.fetch.templates.SwitchDeviceTemplateDto;
import com.ubnt.service.orchestration.dto.fetch.templates.WifiTemplateDto;
import com.ubnt.service.orchestration.mapper.OrchestrationContext;
import com.ubnt.service.orchestration.model.AbstractTemplate;
import com.ubnt.service.orchestration.model.NetworkTemplate;
import com.ubnt.service.orchestration.model.Orchestration;
import com.ubnt.service.orchestration.model.OrchestrationMetaData;
import com.ubnt.service.orchestration.model.OrchestratorMetadata;
import com.ubnt.service.orchestration.model.SwitchDeviceTemplate;
import com.ubnt.service.orchestration.model.TemplateMetaData;
import com.ubnt.service.orchestration.model.WifiTemplate;
import java.util.List;
import org.mapstruct.Context;
import org.mapstruct.InjectionStrategy;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.SubclassMapping;
import org.mapstruct.SubclassMappings;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Mapper(componentModel="spring", injectionStrategy=InjectionStrategy.CONSTRUCTOR)
public interface OrchestrationDtoMapper {
    @Mappings(value={@Mapping(target="metaData", source="orchestrationApplyDataDto", qualifiedByName={"mapOrchestrationMetadata"}), @Mapping(target="templates", expression="java(mapTemplates(dto.templates(), new OrchestrationContext(orchestrationApplyDataDto.organizationId(), orchestrationApplyDataDto.orchestrationId())))")})
    public Orchestration toOrchestrationModel(OrchestrationTemplatesFetchResponseDto var1, OrchestrationApplyDataDto var2);

    @Named(value="mapOrchestrationMetadata")
    default public OrchestrationMetaData mapOrchestrationMetadata(OrchestrationApplyDataDto orchestrationApplyDataDto) {
        OrchestrationMetaData.OrchestrationMetaDataBuilder orchestrationMetaDataBuilder = OrchestrationMetaData.builder().organizationId(orchestrationApplyDataDto.organizationId()).orchestrationId(orchestrationApplyDataDto.orchestrationId()).siteIds(orchestrationApplyDataDto.siteIds());
        OrchestrationSessionIdentifierDto orchestrationSessionIdentifierDto = orchestrationApplyDataDto.orchestrationSessionIdentifierDto();
        if (orchestrationSessionIdentifierDto != null) {
            orchestrationMetaDataBuilder.orchestratorMetadata(this.super(orchestrationSessionIdentifierDto));
        }
        return orchestrationMetaDataBuilder.build();
    }

    default public List<AbstractTemplate> mapTemplates(List<AbstractTemplateDto> list, @Context OrchestrationContext orchestrationContext) {
        if (list == null) {
            return List.of();
        }
        return list.stream().map(abstractTemplateDto -> this.toTemplate((AbstractTemplateDto)abstractTemplateDto, orchestrationContext)).toList();
    }

    @Mapping(target="metaData", expression="java(mapTemplateMetaData(orchestrationContext, dto.getId(), dto.getRevisionId()))")
    @SubclassMappings(value={@SubclassMapping(source=WifiTemplateDto.class, target=WifiTemplate.class), @SubclassMapping(source=NetworkTemplateDto.class, target=NetworkTemplate.class), @SubclassMapping(source=SwitchDeviceTemplateDto.class, target=SwitchDeviceTemplate.class)})
    public AbstractTemplate toTemplate(AbstractTemplateDto var1, @Context OrchestrationContext var2);

    @Mapping(target="metaData", expression="java(mapTemplateMetaData(orchestrationContext, dto.getId(), dto.getRevisionId()))")
    public WifiTemplate toTemplate(WifiTemplateDto var1, @Context OrchestrationContext var2);

    @Mapping(target="metaData", expression="java(mapTemplateMetaData(orchestrationContext, dto.getId(), dto.getRevisionId()))")
    public NetworkTemplate toTemplate(NetworkTemplateDto var1, @Context OrchestrationContext var2);

    @Mapping(target="metaData", expression="java(mapTemplateMetaData(orchestrationContext, dto.getId(), dto.getRevisionId()))")
    public SwitchDeviceTemplate toTemplate(SwitchDeviceTemplateDto var1, @Context OrchestrationContext var2);

    default public TemplateMetaData mapTemplateMetaData(@Context OrchestrationContext orchestrationContext, String string, String string2) {
        return TemplateMetaData.builder().organizationId(orchestrationContext.organizationId()).orchestrationId(orchestrationContext.orchestrationId()).templateId(string).revisionId(string2).build();
    }

    default public OrchestrationMetaData toOrchestrationMetaData(OrchestrationRemoveDataDto orchestrationRemoveDataDto) {
        OrchestrationMetaData.OrchestrationMetaDataBuilder orchestrationMetaDataBuilder = OrchestrationMetaData.builder().organizationId(orchestrationRemoveDataDto.organizationId()).orchestrationId(orchestrationRemoveDataDto.orchestrationId()).siteIds(orchestrationRemoveDataDto.siteIds());
        OrchestrationSessionIdentifierDto orchestrationSessionIdentifierDto = orchestrationRemoveDataDto.orchestrationSessionIdentifierDto();
        if (orchestrationSessionIdentifierDto != null) {
            orchestrationMetaDataBuilder.orchestratorMetadata(this.super(orchestrationSessionIdentifierDto));
        }
        return orchestrationMetaDataBuilder.build();
    }

    private OrchestratorMetadata super(OrchestrationSessionIdentifierDto orchestrationSessionIdentifierDto) {
        return OrchestratorMetadata.builder().ssoId(orchestrationSessionIdentifierDto.ssoId()).ipAddress(orchestrationSessionIdentifierDto.ipAddress()).build();
    }
}

