/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration.template.wifi.validator;

import com.google.common.collect.ImmutableMap;
import com.ubnt.data.WlanConf;
import com.ubnt.service.orchestration.dto.report.IssueDetailReportDto;
import com.ubnt.service.orchestration.template.TemplateProvisioningValidationIssue;
import com.ubnt.service.orchestration.template.TemplateValidator;
import com.ubnt.service.orchestration.template.wifi.validator.WifiTemplateErrorValidator;
import com.ubnt.service.orchestration.template.wifi.validator.WifiTemplateWarningValidator;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class WifiTemplateValidator
implements TemplateValidator<WlanConf> {
    private final WifiTemplateWarningValidator wifiTemplateWarningValidator;
    private final WifiTemplateErrorValidator wifiTemplateErrorValidator;

    @Override
    public Map<TemplateProvisioningValidationIssue, List<IssueDetailReportDto>> validate(List<WlanConf> list) {
        List<IssueDetailReportDto> list2 = this.wifiTemplateWarningValidator.checkTemplateForWarnings(list);
        List<IssueDetailReportDto> list3 = this.wifiTemplateErrorValidator.checkTemplateForErrors(list);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!list2.isEmpty()) {
            builder.put((Object)TemplateProvisioningValidationIssue.WARNING, list2);
        }
        if (!list3.isEmpty()) {
            builder.put((Object)TemplateProvisioningValidationIssue.ERROR, list3);
        }
        return builder.build();
    }

    @ConstructorProperties(value={"wifiTemplateWarningValidator", "wifiTemplateErrorValidator"})
    @Generated
    public WifiTemplateValidator(WifiTemplateWarningValidator wifiTemplateWarningValidator, WifiTemplateErrorValidator wifiTemplateErrorValidator) {
        this.wifiTemplateWarningValidator = wifiTemplateWarningValidator;
        this.wifiTemplateErrorValidator = wifiTemplateErrorValidator;
    }
}

