/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.system;

import com.ubnt.service.system.jA;
import jakarta.annotation.PreDestroy;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;

public class HouseKeeperRepository
implements AutoCloseable {
    private static final Logger logger = jA.\u00f4\u00d20000;
    private final Map<String, ScheduledFuture<?>> map = new HashMap();

    public void addFutures(String string, ScheduledFuture<?> scheduledFuture) {
        if (null != scheduledFuture) {
            this.map.put(string, scheduledFuture);
        }
    }

    public void cancelAll() {
        for (Map.Entry<String, ScheduledFuture<?>> entry : this.map.entrySet()) {
            if (entry.getValue().cancel(true)) continue;
            logger.warn("cannot stop task {} (is running?)", (Object)entry.getKey());
        }
    }

    public void cancel(String string) {
        Optional.ofNullable(this.map.get(string)).ifPresent(scheduledFuture -> scheduledFuture.cancel(false));
    }

    @Override
    @PreDestroy
    public void close() throws Exception {
        logger.info("Cancelling all re-occurring background tasks");
        this.cancelAll();
    }
}

