/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.trafficstats;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.trafficstats.AppTrafficDto;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Generated(from="AppTrafficDto", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableAppTrafficDto
extends AppTrafficDto {
    private final int application;
    private final int category;
    private final long bytesReceived;
    private final long bytesTransmitted;
    @Nullable
    private final Integer clientCount;
    @Nullable
    private final Long activitySeconds;
    private volatile transient long lazyInitBitmap;
    private static final long TOTAL_BYTES_LAZY_INIT_BIT = 1L;
    private transient long totalBytes;

    private ImmutableAppTrafficDto(Builder builder) {
        this.application = builder.application;
        this.category = builder.category;
        this.bytesReceived = builder.bytesReceived;
        this.bytesTransmitted = builder.bytesTransmitted;
        this.clientCount = builder.clientCount;
        this.activitySeconds = builder.activitySeconds;
    }

    @Override
    public int application() {
        return this.application;
    }

    @Override
    public int category() {
        return this.category;
    }

    @Override
    public long bytesReceived() {
        return this.bytesReceived;
    }

    @Override
    public long bytesTransmitted() {
        return this.bytesTransmitted;
    }

    @Override
    public Optional<Integer> clientCount() {
        return Optional.ofNullable(this.clientCount);
    }

    @Override
    public Optional<Long> activitySeconds() {
        return Optional.ofNullable(this.activitySeconds);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableAppTrafficDto && this.super(0, (ImmutableAppTrafficDto)object);
    }

    private boolean super(int n2, ImmutableAppTrafficDto immutableAppTrafficDto) {
        return this.application == immutableAppTrafficDto.application && this.category == immutableAppTrafficDto.category && this.bytesReceived == immutableAppTrafficDto.bytesReceived && this.bytesTransmitted == immutableAppTrafficDto.bytesTransmitted && Objects.equals(this.clientCount, immutableAppTrafficDto.clientCount) && Objects.equals(this.activitySeconds, immutableAppTrafficDto.activitySeconds);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + this.application;
        n2 += (n2 << 5) + this.category;
        n2 += (n2 << 5) + Long.hashCode(this.bytesReceived);
        n2 += (n2 << 5) + Long.hashCode(this.bytesTransmitted);
        n2 += (n2 << 5) + Objects.hashCode(this.clientCount);
        n2 += (n2 << 5) + Objects.hashCode(this.activitySeconds);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AppTrafficDto{");
        stringBuilder.append("application=").append(this.application);
        stringBuilder.append(", ");
        stringBuilder.append("category=").append(this.category);
        stringBuilder.append(", ");
        stringBuilder.append("bytesReceived=").append(this.bytesReceived);
        stringBuilder.append(", ");
        stringBuilder.append("bytesTransmitted=").append(this.bytesTransmitted);
        if (this.clientCount != null) {
            stringBuilder.append(", ");
            stringBuilder.append("clientCount=").append(this.clientCount);
        }
        if (this.activitySeconds != null) {
            stringBuilder.append(", ");
            stringBuilder.append("activitySeconds=").append(this.activitySeconds);
        }
        return stringBuilder.append("}").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long totalBytes() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableAppTrafficDto immutableAppTrafficDto = this;
            synchronized (immutableAppTrafficDto) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.totalBytes = super.totalBytes();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.totalBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AppTrafficDto", generator="Immutables")
    public static final class Builder {
        private int application;
        private int category;
        private long bytesReceived;
        private long bytesTransmitted;
        @Nullable
        private Integer clientCount;
        @Nullable
        private Long activitySeconds;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AppTrafficDto appTrafficDto) {
            Optional<Long> optional;
            Objects.requireNonNull(appTrafficDto, "instance");
            this.application(appTrafficDto.application());
            this.category(appTrafficDto.category());
            this.bytesReceived(appTrafficDto.bytesReceived());
            this.bytesTransmitted(appTrafficDto.bytesTransmitted());
            Optional<Integer> optional2 = appTrafficDto.clientCount();
            if (optional2.isPresent()) {
                this.clientCount(optional2);
            }
            if ((optional = appTrafficDto.activitySeconds()).isPresent()) {
                this.activitySeconds(optional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder application(int n2) {
            this.application = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder category(int n2) {
            this.category = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bytesReceived(long l2) {
            this.bytesReceived = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bytesTransmitted(long l2) {
            this.bytesTransmitted = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientCount(@Nullable Integer n2) {
            this.clientCount = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientCount(Optional<Integer> optional) {
            this.clientCount = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder activitySeconds(@Nullable Long l2) {
            this.activitySeconds = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder activitySeconds(Optional<Long> optional) {
            this.activitySeconds = optional.orElse(null);
            return this;
        }

        public ImmutableAppTrafficDto build() {
            return new ImmutableAppTrafficDto(this);
        }
    }
}

