/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.EdgeTraversalEvent;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.traverse.AbstractGraphIterator;

public abstract class CrossComponentIterator<V, E, D>
extends AbstractGraphIterator<V, E> {
    private static final int CCS_BEFORE_COMPONENT = 1;
    private static final int CCS_WITHIN_COMPONENT = 2;
    private static final int CCS_AFTER_COMPONENT = 3;
    private final ConnectedComponentTraversalEvent ccFinishedEvent = new ConnectedComponentTraversalEvent(this, 32);
    private final ConnectedComponentTraversalEvent ccStartedEvent = new ConnectedComponentTraversalEvent(this, 31);
    private Iterator<V> vertexIterator = null;
    private Map<V, D> seen = new HashMap<V, D>();
    private V startVertex;
    private final Graph<V, E> graph;
    private int state = 1;

    public CrossComponentIterator(Graph<V, E> g, V startVertex) {
        if (g == null) {
            throw new IllegalArgumentException("graph must not be null");
        }
        this.graph = g;
        this.specifics = CrossComponentIterator.createGraphSpecifics(g);
        this.vertexIterator = g.vertexSet().iterator();
        this.setCrossComponentTraversal(startVertex == null);
        this.reusableEdgeEvent = new AbstractGraphIterator.FlyweightEdgeEvent((Object)this, null);
        this.reusableVertexEvent = new AbstractGraphIterator.FlyweightVertexEvent<Object>((Object)this, null);
        if (startVertex == null) {
            this.startVertex = this.vertexIterator.hasNext() ? this.vertexIterator.next() : null;
        } else if (g.containsVertex(startVertex)) {
            this.startVertex = startVertex;
        } else {
            throw new IllegalArgumentException("graph must contain the start vertex");
        }
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public boolean hasNext() {
        if (this.startVertex != null) {
            this.encounterStartVertex();
        }
        if (this.isConnectedComponentExhausted()) {
            if (this.state == 2) {
                this.state = 3;
                if (this.nListeners != 0) {
                    this.fireConnectedComponentFinished(this.ccFinishedEvent);
                }
            }
            if (this.isCrossComponentTraversal()) {
                while (this.vertexIterator.hasNext()) {
                    V v = this.vertexIterator.next();
                    if (this.isSeenVertex(v)) continue;
                    this.encounterVertex(v, null);
                    this.state = 1;
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public V next() {
        if (this.startVertex != null) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            if (this.state == 1) {
                this.state = 2;
                if (this.nListeners != 0) {
                    this.fireConnectedComponentStarted(this.ccStartedEvent);
                }
            }
            V nextVertex = this.provideNextVertex();
            if (this.nListeners != 0) {
                this.fireVertexTraversed(this.createVertexTraversalEvent(nextVertex));
            }
            this.addUnseenChildrenOf(nextVertex);
            return nextVertex;
        }
        throw new NoSuchElementException();
    }

    protected abstract boolean isConnectedComponentExhausted();

    protected abstract void encounterVertex(V var1, E var2);

    protected abstract V provideNextVertex();

    protected D getSeenData(V vertex) {
        return this.seen.get(vertex);
    }

    protected boolean isSeenVertex(V vertex) {
        return this.seen.containsKey(vertex);
    }

    protected abstract void encounterVertexAgain(V var1, E var2);

    protected D putSeenData(V vertex, D data) {
        return this.seen.put(vertex, data);
    }

    protected void finishVertex(V vertex) {
        if (this.nListeners != 0) {
            this.fireVertexFinished(this.createVertexTraversalEvent(vertex));
        }
    }

    private void addUnseenChildrenOf(V vertex) {
        for (Object edge : this.specifics.edgesOf(vertex)) {
            V oppositeV;
            if (this.nListeners != 0) {
                this.fireEdgeTraversed(this.createEdgeTraversalEvent(edge));
            }
            if (this.isSeenVertex(oppositeV = Graphs.getOppositeVertex(this.graph, edge, vertex))) {
                this.encounterVertexAgain(oppositeV, edge);
                continue;
            }
            this.encounterVertex(oppositeV, edge);
        }
    }

    private EdgeTraversalEvent<E> createEdgeTraversalEvent(E edge) {
        if (this.isReuseEvents()) {
            this.reusableEdgeEvent.setEdge(edge);
            return this.reusableEdgeEvent;
        }
        return new EdgeTraversalEvent<E>(this, edge);
    }

    private VertexTraversalEvent<V> createVertexTraversalEvent(V vertex) {
        if (this.isReuseEvents()) {
            this.reusableVertexEvent.setVertex(vertex);
            return this.reusableVertexEvent;
        }
        return new VertexTraversalEvent<V>(this, vertex);
    }

    private void encounterStartVertex() {
        this.encounterVertex(this.startVertex, null);
        this.startVertex = null;
    }

    static interface SimpleContainer<T> {
        public boolean isEmpty();

        public void add(T var1);

        public T remove();
    }

    protected static enum VisitColor {
        WHITE,
        GRAY,
        BLACK;

    }
}

