/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.DocSecurityFeaturesObjectAdapter;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class DocSecurityFeaturesObject
extends FeaturesObject {
    private static final String DOCUMENT_SECURITY = "documentSecurity";
    private static final String FILTER = "filter";
    private static final String SUB_FILTER = "subFilter";
    private static final String VERSION = "version";
    private static final String LENGTH = "length";
    private static final String OWNER_KEY = "ownerKey";
    private static final String USER_KEY = "userKey";
    private static final String ENCRYPT_METADATA = "encryptMetadata";
    private static final String PRINT_ALLOWED = "printAllowed";
    private static final String PRINT_DEGRADED_ALLOWED = "printDegradedAllowed";
    private static final String CHANGES_ALLOWED = "changesAllowed";
    private static final String MODIFY_ANNOTATIONS_ALLOWED = "modifyAnnotationsAllowed";
    private static final String FILLING_SIGNING_ALLOWED = "fillingSigningAllowed";
    private static final String DOCUMENT_ASSEMBLY_ALLOWED = "documentAssemblyAllowed";
    private static final String EXTRACT_CONTENT_ALLOWED = "extractContentAllowed";
    private static final String EXTRACT_ACCESSIBILITY_ALLOWED = "extractAccessibilityAllowed";

    public DocSecurityFeaturesObject(DocSecurityFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.DOCUMENT_SECURITY;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        DocSecurityFeaturesObjectAdapter docSecAdapter = (DocSecurityFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(DOCUMENT_SECURITY);
        CreateNodeHelper.addNotEmptyNode(FILTER, docSecAdapter.getFilter(), root);
        CreateNodeHelper.addNotEmptyNode(SUB_FILTER, docSecAdapter.getSubFilter(), root);
        CreateNodeHelper.addNotEmptyNode(VERSION, String.valueOf(docSecAdapter.getVersion()), root);
        CreateNodeHelper.addNotEmptyNode(LENGTH, String.valueOf(docSecAdapter.getLength()), root);
        CreateNodeHelper.addNotEmptyNode(OWNER_KEY, docSecAdapter.getHexEncodedOwnerKey(), root);
        CreateNodeHelper.addNotEmptyNode(USER_KEY, docSecAdapter.getHexEncodedUserKey(), root);
        CreateNodeHelper.addNotEmptyNode(ENCRYPT_METADATA, String.valueOf(docSecAdapter.isEncryptMetadata()), root);
        if (docSecAdapter.isUserPermissionsPresent()) {
            CreateNodeHelper.addNotEmptyNode(PRINT_ALLOWED, String.valueOf(docSecAdapter.isPrintAllowed()), root);
            CreateNodeHelper.addNotEmptyNode(PRINT_DEGRADED_ALLOWED, String.valueOf(docSecAdapter.isPrintDegradedAllowed()), root);
            CreateNodeHelper.addNotEmptyNode(CHANGES_ALLOWED, String.valueOf(docSecAdapter.isModifyAnnotationsAllowed()), root);
            CreateNodeHelper.addNotEmptyNode(MODIFY_ANNOTATIONS_ALLOWED, String.valueOf(docSecAdapter.isChangesAllowed()), root);
            CreateNodeHelper.addNotEmptyNode(FILLING_SIGNING_ALLOWED, String.valueOf(docSecAdapter.isFillingSigningAllowed()), root);
            CreateNodeHelper.addNotEmptyNode(DOCUMENT_ASSEMBLY_ALLOWED, String.valueOf(docSecAdapter.isDocumentAssemblyAllowed()), root);
            CreateNodeHelper.addNotEmptyNode(EXTRACT_CONTENT_ALLOWED, String.valueOf(docSecAdapter.isExtractContentAllowed()), root);
            CreateNodeHelper.addNotEmptyNode(EXTRACT_ACCESSIBILITY_ALLOWED, String.valueOf(docSecAdapter.isExtractAccessibilityAllowed()), root);
        }
        return root;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Filter", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, FILTER), Feature.FeatureType.STRING));
        featuresList.add(new Feature("SubFilter", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, SUB_FILTER), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Version", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, VERSION), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Length", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, LENGTH), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Owner Key", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, OWNER_KEY), Feature.FeatureType.STRING));
        featuresList.add(new Feature("User Key", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, USER_KEY), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Encrypt Metadata", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, ENCRYPT_METADATA), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Print Allowed", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, PRINT_ALLOWED), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Print Degraded Allowed", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, PRINT_DEGRADED_ALLOWED), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Changes Allowed", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, CHANGES_ALLOWED), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Modify Annotations Allowed", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, MODIFY_ANNOTATIONS_ALLOWED), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Filling Signing Allowed", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, FILLING_SIGNING_ALLOWED), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Document Assembly Allowed", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, DOCUMENT_ASSEMBLY_ALLOWED), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Extract Content Allowed", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, EXTRACT_CONTENT_ALLOWED), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Extract Accessibility Allowed", DocSecurityFeaturesObject.generateVariableXPath(DOCUMENT_SECURITY, EXTRACT_ACCESSIBILITY_ALLOWED), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Error IDs", DocSecurityFeaturesObject.generateAttributeXPath(DOCUMENT_SECURITY, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

