/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHKeyPairGenerator;
import com.sun.crypto.provider.SunJCE;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import sun.security.util.SecurityProviderConstants;

public final class DHParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int primeSize = SecurityProviderConstants.DEF_DH_KEY_SIZE;
    private int exponentSize = 0;
    private SecureRandom random = null;

    private static void checkSupport(int n, int n2) throws InvalidParameterException {
        boolean bl;
        boolean bl2 = bl = n == 2048 || n == 3072 || n >= 512 && n <= 1024 && (n & 0x3F) == 0;
        if (!bl) {
            throw new InvalidParameterException("Supported DH key size must be multiple of 64 and range from 512 to 1024 (inclusive), or 2048, 3072. The specified key size " + n + " is not supported");
        }
        if (n2 != 0) {
            DHKeyPairGenerator.checkKeySize(n, n2);
        }
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        DHParameterGenerator.checkSupport(n, 0);
        this.primeSize = n;
        this.random = secureRandom;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        DHGenParameterSpec dHGenParameterSpec = (DHGenParameterSpec)algorithmParameterSpec;
        int n = dHGenParameterSpec.getPrimeSize();
        int n2 = dHGenParameterSpec.getExponentSize();
        try {
            DHParameterGenerator.checkSupport(n, n2);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new InvalidAlgorithmParameterException(invalidParameterException.getMessage());
        }
        this.primeSize = n;
        this.exponentSize = n2;
        this.random = secureRandom;
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        if (this.exponentSize == 0) {
            this.exponentSize = this.primeSize - 1;
        }
        if (this.random == null) {
            this.random = SunJCE.getRandom();
        }
        Object var1_1 = null;
        Object var2_2 = null;
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DSA");
            algorithmParameterGenerator.init(this.primeSize, this.random);
            AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
            DSAParameterSpec dSAParameterSpec = algorithmParameters.getParameterSpec(DSAParameterSpec.class);
            DHParameterSpec dHParameterSpec = this.exponentSize > 0 ? new DHParameterSpec(dSAParameterSpec.getP(), dSAParameterSpec.getG(), this.exponentSize) : new DHParameterSpec(dSAParameterSpec.getP(), dSAParameterSpec.getG());
            AlgorithmParameters algorithmParameters2 = AlgorithmParameters.getInstance("DH", SunJCE.getInstance());
            algorithmParameters2.init(dHParameterSpec);
            return algorithmParameters2;
        }
        catch (Exception exception) {
            throw new ProviderException("Unexpected exception", exception);
        }
    }
}

