/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Model;
import io.swagger.models.Xml;
import io.swagger.models.properties.Property;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractModel
implements Model {
    private ExternalDocs externalDocs;
    private String reference;
    private String title;
    private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();
    private Xml xml;
    private BigDecimal minimum;
    private BigDecimal maximum;
    private BigDecimal multipleOf;
    private Boolean exclusiveMinimum;
    private Boolean exclusiveMaximum;
    private Integer minLength;
    private Integer maxLength;
    private String pattern;
    protected Map<String, Property> properties;
    protected List<String> required;
    protected Boolean booleanValue;

    @Override
    @JsonIgnore
    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    @Override
    public void setBooleanValue(Boolean booleanValue) {
        this.booleanValue = booleanValue;
    }

    @Override
    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocs value) {
        this.externalDocs = value;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String name, Object value) {
        if (name.startsWith("x-")) {
            this.vendorExtensions.put(name, value);
        }
    }

    public BigDecimal getMinimum() {
        return this.minimum;
    }

    public void setMinimum(BigDecimal minimum) {
        this.minimum = minimum;
    }

    public BigDecimal getMaximum() {
        return this.maximum;
    }

    public void setMaximum(BigDecimal maximum) {
        this.maximum = maximum;
    }

    public BigDecimal getMultipleOf() {
        return this.multipleOf;
    }

    public void setMultipleOf(BigDecimal multipleOf) {
        this.multipleOf = multipleOf;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public void setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public void setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setVendorExtensions(Map<String, Object> vendorExtensions) {
        this.vendorExtensions = vendorExtensions;
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Property> properties) {
        if (properties != null) {
            for (String key : properties.keySet()) {
                this.addProperty(key, properties.get(key));
            }
        }
    }

    public void addProperty(String key, Property property) {
        if (property == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Property>();
        }
        if (this.required != null) {
            for (String ek : this.required) {
                if (!key.equals(ek)) continue;
                property.setRequired(true);
            }
        }
        this.properties.put(key, property);
    }

    public List<String> getRequired() {
        ArrayList<String> output = new ArrayList<String>();
        if (this.properties != null) {
            for (String key : this.properties.keySet()) {
                Property prop = this.properties.get(key);
                if (prop == null || !prop.getRequired()) continue;
                output.add(key);
            }
        }
        Collections.sort(output);
        if (output.size() > 0) {
            return output;
        }
        return null;
    }

    public void setRequired(List<String> required) {
        this.required = required;
        if (required != null && this.properties != null) {
            for (String s2 : required) {
                Property p = this.properties.get(s2);
                if (p == null) continue;
                p.setRequired(true);
            }
        }
    }

    public void cloneTo(Object clone) {
        AbstractModel cloned = (AbstractModel)clone;
        cloned.externalDocs = this.externalDocs;
        cloned.reference = this.reference;
        cloned.title = this.title;
        cloned.minimum = this.minimum;
        cloned.maximum = this.maximum;
        cloned.minLength = this.minLength;
        cloned.maxLength = this.maxLength;
        cloned.exclusiveMinimum = this.exclusiveMinimum;
        cloned.exclusiveMaximum = this.exclusiveMaximum;
        cloned.pattern = this.pattern;
        cloned.multipleOf = this.multipleOf;
        cloned.pattern = this.pattern;
        if (this.properties != null) {
            cloned.properties = new LinkedHashMap<String, Property>(this.properties);
        }
        cloned.required = this.required;
        if (this.vendorExtensions == null) {
            cloned.vendorExtensions = this.vendorExtensions;
        } else {
            for (String key : this.vendorExtensions.keySet()) {
                cloned.setVendorExtension(key, this.vendorExtensions.get(key));
            }
        }
        cloned.xml = this.xml == null ? this.xml : (Xml)this.xml.clone();
        cloned.booleanValue = this.booleanValue;
    }

    @Override
    public Object clone() {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.externalDocs == null ? 0 : this.externalDocs.hashCode());
        result = 31 * result + (this.vendorExtensions == null ? 0 : this.vendorExtensions.hashCode());
        result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.xml == null ? 0 : this.xml.hashCode());
        result = 31 * result + (this.minimum != null ? this.minimum.hashCode() : 0);
        result = 31 * result + (this.maximum != null ? this.maximum.hashCode() : 0);
        result = 31 * result + (this.minLength != null ? this.minLength.hashCode() : 0);
        result = 31 * result + (this.maxLength != null ? this.maxLength.hashCode() : 0);
        result = 31 * result + (this.exclusiveMinimum != null ? this.exclusiveMinimum.hashCode() : 0);
        result = 31 * result + (this.exclusiveMaximum != null ? this.exclusiveMaximum.hashCode() : 0);
        result = 31 * result + (this.pattern != null ? this.pattern.hashCode() : 0);
        result = 31 * result + (this.multipleOf != null ? this.multipleOf.hashCode() : 0);
        result = 31 * result + (this.pattern != null ? this.pattern.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (this.required != null ? this.required.hashCode() : 0);
        result = 31 * result + (this.booleanValue != null ? this.booleanValue.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractModel other = (AbstractModel)obj;
        if (this.externalDocs == null ? other.externalDocs != null : !this.externalDocs.equals(other.externalDocs)) {
            return false;
        }
        if (this.vendorExtensions == null ? other.vendorExtensions != null : !this.vendorExtensions.equals(other.vendorExtensions)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.reference == null ? other.reference != null : !this.reference.equals(other.reference)) {
            return false;
        }
        if (this.xml == null ? other.xml != null : !this.xml.equals(other.xml)) {
            return false;
        }
        if (this.exclusiveMaximum != null ? !this.exclusiveMaximum.equals(other.exclusiveMaximum) : other.exclusiveMaximum != null) {
            return false;
        }
        if (this.exclusiveMinimum != null ? !this.exclusiveMinimum.equals(other.exclusiveMinimum) : other.exclusiveMinimum != null) {
            return false;
        }
        if (this.minimum != null ? !this.minimum.equals(other.minimum) : other.minimum != null) {
            return false;
        }
        if (this.minLength != null ? !this.minLength.equals(other.minLength) : other.minLength != null) {
            return false;
        }
        if (this.maxLength != null ? !this.maxLength.equals(other.maxLength) : other.maxLength != null) {
            return false;
        }
        if (this.pattern != null ? !this.pattern.equals(other.pattern) : other.pattern != null) {
            return false;
        }
        if (this.multipleOf != null ? !this.multipleOf.equals(other.multipleOf) : other.multipleOf != null) {
            return false;
        }
        if (this.pattern != null ? !this.pattern.equals(other.pattern) : other.pattern != null) {
            return false;
        }
        if (this.required != null ? !this.required.equals(other.required) : other.required != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(other.properties) : other.properties != null) {
            return false;
        }
        if (this.booleanValue != null ? !this.booleanValue.equals(other.booleanValue) : other.booleanValue != null) {
            return false;
        }
        return this.maximum != null ? this.maximum.equals(other.maximum) : other.maximum == null;
    }

    @Override
    @JsonIgnore
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    public Xml getXml() {
        return this.xml;
    }

    public void setXml(Xml xml) {
        this.xml = xml;
    }
}

