/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filterrewrite;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSetIterator;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.search.aggregations.bucket.filterrewrite.FilterRewriteOptimizationContext;
import org.opensearch.search.aggregations.bucket.filterrewrite.Helper;
import org.opensearch.search.aggregations.bucket.filterrewrite.Ranges;
import org.opensearch.search.aggregations.bucket.filterrewrite.rangecollector.RangeCollector;
import org.opensearch.search.aggregations.bucket.filterrewrite.rangecollector.SimpleRangeCollector;
import org.opensearch.search.aggregations.bucket.filterrewrite.rangecollector.SubAggRangeCollector;

final class PointTreeTraversal {
    private static final Logger logger = LogManager.getLogger((String)Helper.loggerName);

    private PointTreeTraversal() {
    }

    static RangeCollector createCollector(Ranges ranges, BiConsumer<Integer, Integer> incrementRangeDocCount, int maxNumNonZeroRange, int activeIndex, Function<Integer, Long> getBucketOrd, FilterRewriteOptimizationContext.OptimizeResult result, FilterRewriteOptimizationContext.SubAggCollectorParam subAggCollectorParam) {
        if (subAggCollectorParam == null) {
            return new SimpleRangeCollector(ranges, incrementRangeDocCount, maxNumNonZeroRange, activeIndex, result);
        }
        return new SubAggRangeCollector(ranges, incrementRangeDocCount, maxNumNonZeroRange, activeIndex, result, getBucketOrd, subAggCollectorParam);
    }

    static FilterRewriteOptimizationContext.OptimizeResult multiRangesTraverse(PointValues.PointTree tree, RangeCollector collector) throws IOException {
        PointValues.IntersectVisitor visitor = PointTreeTraversal.getIntersectVisitor(collector);
        try {
            PointTreeTraversal.intersectWithRanges(visitor, tree, collector);
        }
        catch (CollectionTerminatedException e) {
            logger.debug("Early terminate since no more range to collect");
        }
        collector.finalizePreviousRange();
        return collector.getResult();
    }

    private static void intersectWithRanges(PointValues.IntersectVisitor visitor, PointValues.PointTree pointTree, RangeCollector collector) throws IOException {
        PointValues.Relation r = visitor.compare(pointTree.getMinPackedValue(), pointTree.getMaxPackedValue());
        switch (r) {
            case CELL_INSIDE_QUERY: {
                collector.countNode((int)pointTree.size());
                if (collector.hasSubAgg()) {
                    pointTree.visitDocIDs(visitor);
                    break;
                }
                collector.visitInner();
                break;
            }
            case CELL_CROSSES_QUERY: {
                if (pointTree.moveToChild()) {
                    do {
                        PointTreeTraversal.intersectWithRanges(visitor, pointTree, collector);
                    } while (pointTree.moveToSibling());
                    pointTree.moveToParent();
                    break;
                }
                pointTree.visitDocValues(visitor);
                collector.visitLeaf();
                break;
            }
        }
    }

    private static PointValues.IntersectVisitor getIntersectVisitor(final RangeCollector collector) {
        return new PointValues.IntersectVisitor(){

            public void visit(int docID) {
                collector.collectDocId(docID);
            }

            public void visit(DocIdSetIterator iterator) throws IOException {
                collector.collectDocIdSet(iterator);
            }

            public void visit(int docID, byte[] packedValue) throws IOException {
                this.visitPoints(packedValue, (CheckedRunnable<IOException>)((CheckedRunnable)() -> {
                    collector.count();
                    if (collector.hasSubAgg()) {
                        collector.collectDocId(docID);
                    }
                }));
            }

            public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                this.visitPoints(packedValue, (CheckedRunnable<IOException>)((CheckedRunnable)() -> {
                    int doc = iterator.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        collector.count();
                        if (collector.hasSubAgg()) {
                            collector.collectDocId(doc);
                        }
                        doc = iterator.nextDoc();
                    }
                }));
            }

            private void visitPoints(byte[] packedValue, CheckedRunnable<IOException> collect) throws IOException {
                if (!collector.withinUpperBound(packedValue)) {
                    collector.finalizePreviousRange();
                    if (collector.iterateRangeEnd(packedValue, true)) {
                        throw new CollectionTerminatedException();
                    }
                }
                if (collector.withinRange(packedValue)) {
                    collect.run();
                }
            }

            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                if (!collector.withinUpperBound(minPackedValue)) {
                    collector.finalizePreviousRange();
                    if (collector.iterateRangeEnd(minPackedValue, false)) {
                        throw new CollectionTerminatedException();
                    }
                }
                if (!collector.withinLowerBound(maxPackedValue)) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (collector.withinRange(minPackedValue) && collector.withinRange(maxPackedValue)) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
        };
    }
}

