/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.string;

import java.util.Formatter;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.Utility;

public final class StringFormat
implements Supplier<String> {
    private static final Logger LOGGER = Logger.getLogger(StringFormat.class.getName());
    private final Object[] args;
    private final String format;

    public StringFormat(String format, Object ... args) {
        this.format = format;
        this.args = args;
    }

    @Override
    public String get() {
        if (Utility.isBlank(this.format) || this.args == null || this.args.length == 0) {
            return this.format;
        }
        Formatter formatter = new Formatter();
        try {
            String string = formatter.format(this.format, this.args).toString();
            formatter.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    formatter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                LOGGER.log(Level.FINEST, "Error logging message <%s>".formatted(this.format));
                return "";
            }
        }
    }

    public String toString() {
        return this.get();
    }
}

