/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.data.MinCollector;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class MinFunction {
    public static final String name = "min";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The min function requires 1 paramater, " + params.length + " found.");
        }
        AnalyticsValueStream param = params[0];
        if (param instanceof DateValueStream) {
            return new DateMinFunction((DateValueStream)param);
        }
        if (param instanceof IntValueStream) {
            return new IntMinFunction((IntValueStream)param);
        }
        if (param instanceof LongValueStream) {
            return new LongMinFunction((LongValueStream)param);
        }
        if (param instanceof FloatValueStream) {
            return new FloatMinFunction((FloatValueStream)param);
        }
        if (param instanceof DoubleValueStream) {
            return new DoubleMinFunction((DoubleValueStream)param);
        }
        if (param instanceof StringValueStream) {
            return new StringMinFunction((StringValueStream)param);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The min function requires a comparable parameter. Incorrect parameter: " + params[0].getExpressionStr());
    };

    static class StringMinFunction
    extends StringValue.AbstractStringValue
    implements ReductionFunction {
        private MinCollector.StringMinCollector collector;
        public static final String name = "min";
        private final String exprStr;

        public StringMinFunction(StringValueStream param) {
            this.collector = new MinCollector.StringMinCollector(param);
            this.exprStr = AnalyticsValueStream.createExpressionString("min", param);
        }

        @Override
        public String getString() {
            return this.collector.exists() ? this.collector.min() : null;
        }

        @Override
        public boolean exists() {
            return this.collector.exists();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (MinCollector.StringMinCollector)sync.apply(this.collector);
        }

        @Override
        public String getName() {
            return "min";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class DateMinFunction
    extends DateValue.AbstractDateValue
    implements ReductionFunction {
        private MinCollector.LongMinCollector collector;
        public static final String name = "min";
        private final String exprStr;

        public DateMinFunction(LongValueStream param) {
            this.collector = new MinCollector.LongMinCollector(param);
            this.exprStr = AnalyticsValueStream.createExpressionString("min", param);
        }

        @Override
        public long getLong() {
            return this.collector.exists() ? this.collector.min() : 0L;
        }

        @Override
        public boolean exists() {
            return this.collector.exists();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (MinCollector.LongMinCollector)sync.apply(this.collector);
        }

        @Override
        public String getName() {
            return "min";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class DoubleMinFunction
    extends DoubleValue.AbstractDoubleValue
    implements ReductionFunction {
        private MinCollector.DoubleMinCollector collector;
        public static final String name = "min";
        private final String exprStr;

        public DoubleMinFunction(DoubleValueStream param) {
            this.collector = new MinCollector.DoubleMinCollector(param);
            this.exprStr = AnalyticsValueStream.createExpressionString("min", param);
        }

        @Override
        public double getDouble() {
            return this.collector.exists() ? this.collector.min() : 0.0;
        }

        @Override
        public boolean exists() {
            return this.collector.exists();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (MinCollector.DoubleMinCollector)sync.apply(this.collector);
        }

        @Override
        public String getName() {
            return "min";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class FloatMinFunction
    extends FloatValue.AbstractFloatValue
    implements ReductionFunction {
        private MinCollector.FloatMinCollector collector;
        public static final String name = "min";
        private final String exprStr;

        public FloatMinFunction(FloatValueStream param) {
            this.collector = new MinCollector.FloatMinCollector(param);
            this.exprStr = AnalyticsValueStream.createExpressionString("min", param);
        }

        @Override
        public float getFloat() {
            return this.collector.exists() ? this.collector.min() : 0.0f;
        }

        @Override
        public boolean exists() {
            return this.collector.exists();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (MinCollector.FloatMinCollector)sync.apply(this.collector);
        }

        @Override
        public String getName() {
            return "min";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class LongMinFunction
    extends LongValue.AbstractLongValue
    implements ReductionFunction {
        private MinCollector.LongMinCollector collector;
        public static final String name = "min";
        private final String exprStr;

        public LongMinFunction(LongValueStream param) {
            this.collector = new MinCollector.LongMinCollector(param);
            this.exprStr = AnalyticsValueStream.createExpressionString("min", param);
        }

        @Override
        public long getLong() {
            return this.collector.exists() ? this.collector.min() : 0L;
        }

        @Override
        public boolean exists() {
            return this.collector.exists();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (MinCollector.LongMinCollector)sync.apply(this.collector);
        }

        @Override
        public String getName() {
            return "min";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class IntMinFunction
    extends IntValue.AbstractIntValue
    implements ReductionFunction {
        private MinCollector.IntMinCollector collector;
        public static final String name = "min";
        private final String exprStr;

        public IntMinFunction(IntValueStream param) {
            this.collector = new MinCollector.IntMinCollector(param);
            this.exprStr = AnalyticsValueStream.createExpressionString("min", param);
        }

        @Override
        public int getInt() {
            return this.collector.exists() ? this.collector.min() : 0;
        }

        @Override
        public boolean exists() {
            return this.collector.exists();
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (MinCollector.IntMinCollector)sync.apply(this.collector);
        }

        @Override
        public String getName() {
            return "min";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }
}

