/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.util.ProjectionMath;

public class PolyconicProjection
extends Projection {
    private double ml0;
    private double[] en;
    private static final double TOL = 1.0E-10;
    private static final double CONV = 1.0E-10;
    private static final int N_ITER = 10;
    private static final int I_ITER = 20;
    private static final double ITOL = 1.0E-12;

    public PolyconicProjection() {
        this.minLatitude = ProjectionMath.degToRad(0.0);
        this.maxLatitude = ProjectionMath.degToRad(80.0);
        this.minLongitude = ProjectionMath.degToRad(-60.0);
        this.maxLongitude = ProjectionMath.degToRad(60.0);
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        if (this.spherical) {
            if (Math.abs(lpphi) <= 1.0E-10) {
                out.x = lplam;
                out.y = this.ml0;
            } else {
                double cot = 1.0 / Math.tan(lpphi);
                double E = lplam * Math.sin(lpphi);
                out.x = Math.sin(E) * cot;
                out.y = lpphi - this.projectionLatitude + cot * (1.0 - Math.cos(E));
            }
        } else if (Math.abs(lpphi) <= 1.0E-10) {
            out.x = lplam;
            out.y = -this.ml0;
        } else {
            double d;
            double sp = Math.sin(lpphi);
            double cp = Math.cos(lpphi);
            double ms = Math.abs(d) > 1.0E-10 ? ProjectionMath.msfn(sp, cp, this.es) / sp : 0.0;
            out.x = ms * Math.sin(out.x *= sp);
            out.y = ProjectionMath.mlfn(lpphi, sp, cp, this.en) - this.ml0 + ms * (1.0 - Math.cos(lplam));
        }
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        if (this.spherical) {
            double d;
            double lpphi = this.projectionLatitude + xyy;
            if (Math.abs(d) <= 1.0E-10) {
                out.x = xyx;
                out.y = 0.0;
            } else {
                double dphi;
                lpphi = xyy;
                double B = xyx * xyx + xyy * xyy;
                int i = 10;
                do {
                    double tp = Math.tan(lpphi);
                    dphi = (xyy * (lpphi * tp + 1.0) - lpphi - 0.5 * (lpphi * lpphi + B) * tp) / ((lpphi - xyy) / tp - 1.0);
                    lpphi -= dphi;
                } while (Math.abs(dphi) > 1.0E-10 && --i > 0);
                if (i == 0) {
                    throw new ProjectionException("I");
                }
                out.x = Math.asin(xyx * Math.tan(lpphi)) / Math.sin(lpphi);
                out.y = lpphi;
            }
        } else if (Math.abs(xyy += this.ml0) <= 1.0E-10) {
            out.x = xyx;
            out.y = 0.0;
        } else {
            double c;
            int i;
            double r = xyy * xyy + xyx * xyx;
            double lpphi = xyy;
            for (i = 20; i > 0; --i) {
                double sp = Math.sin(lpphi);
                double cp = Math.cos(lpphi);
                double s2ph = sp * cp;
                if (Math.abs(cp) < 1.0E-12) {
                    throw new ProjectionException("I");
                }
                double mlp = Math.sqrt(1.0 - this.es * sp * sp);
                c = sp * mlp / cp;
                double ml = ProjectionMath.mlfn(lpphi, sp, cp, this.en);
                double mlb = ml * ml + r;
                mlp = 1.0 / this.es / (mlp * mlp * mlp);
                double dPhi = (ml + ml + c * mlb - 2.0 * xyy * (c * ml + 1.0)) / (this.es * s2ph * (mlb - 2.0 * xyy * ml) / c + 2.0 * (xyy - ml) * (c * mlp - 1.0 / s2ph) - mlp - mlp);
                lpphi += dPhi;
                if (Math.abs(dPhi) <= 1.0E-12) break;
            }
            if (i == 0) {
                throw new ProjectionException("I");
            }
            c = Math.sin(lpphi);
            out.x = Math.asin(xyx * Math.tan(lpphi) * Math.sqrt(1.0 - this.es * c * c)) / Math.sin(lpphi);
            out.y = lpphi;
        }
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.spherical = true;
        if (!this.spherical) {
            this.en = ProjectionMath.enfn(this.es);
            if (this.en == null) {
                throw new ProjectionException("E");
            }
            this.ml0 = ProjectionMath.mlfn(this.projectionLatitude, Math.sin(this.projectionLatitude), Math.cos(this.projectionLatitude), this.en);
        } else {
            this.ml0 = -this.projectionLatitude;
        }
    }

    @Override
    public String toString() {
        return "Polyconic (American)";
    }
}

