/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.MeridianArcBased;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class Polyconic
extends MeridianArcBased {
    private static final long serialVersionUID = -808283103170618880L;
    private final double ci2;
    private final double ci4;
    private final double ci6;

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.internal.referencing.provider.Polyconic.LONGITUDE_OF_ORIGIN);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.internal.referencing.provider.Polyconic.FALSE_EASTING);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.internal.referencing.provider.Polyconic.FALSE_NORTHING);
        return new Initializer(operationMethod, parameters, enumMap, null);
    }

    public Polyconic(OperationMethod operationMethod, Parameters parameters) {
        this(Polyconic.initializer(operationMethod, parameters));
    }

    private Polyconic(Initializer initializer) {
        super(initializer);
        double d = Math.toRadians(initializer.getAndStore(org.apache.sis.internal.referencing.provider.Polyconic.LATITUDE_OF_ORIGIN));
        double d2 = this.eccentricitySquared;
        double d3 = d2 * d2;
        double d4 = d2 * d3;
        this.ci2 = -1.5 * d3 + 1.5 * d2;
        this.ci4 = -1.875 * d4 + 1.875 * d3;
        this.ci6 = 2.1875 * d4;
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        matrixSIS.convertBefore(1, null, -this.distance(d, Math.sin(d), Math.cos(d)));
    }

    Polyconic(Polyconic polyconic) {
        super(polyconic);
        this.ci2 = polyconic.ci2;
        this.ci4 = polyconic.ci4;
        this.ci6 = polyconic.ci6;
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        Polyconic polyconic = this;
        if (this.eccentricity == 0.0 && this.getClass() == Polyconic.class) {
            polyconic = new Spherical(this);
        }
        return this.context.completeTransform(mathTransformFactory, polyconic);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = d4 / Math.sqrt(1.0 - this.eccentricitySquared * (d3 * d3));
        double d6 = d5 / d3;
        if (Double.isInfinite(d6)) {
            if (dArray2 != null) {
                dArray2[n2] = d;
                dArray2[n2 + 1] = d2;
            }
            return bl ? new Matrix2() : null;
        }
        double d7 = d * d3;
        double d8 = Math.sin(d7);
        double d9 = Math.cos(d7);
        if (dArray2 != null) {
            dArray2[n2] = d6 * d8;
            dArray2[n2 + 1] = d6 * (1.0 - d9) + this.distance(d2, d3, d4);
        }
        if (!bl) {
            return null;
        }
        double d10 = d4 / d3;
        double d11 = d5 * this.eccentricity;
        d11 = (d11 - 1.0) * (d11 + 1.0) / d10 - d10;
        double d12 = d * d4;
        return new Matrix2(d5 * d9, d6 * (d12 * d9 + d11 * d8), d5 * d8, d6 * (d12 * d8 + d11 * (1.0 - d9)) + this.dM_d\u03c6(d3 * d3));
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = dArray[n];
        double d6 = d4 = dArray[n + 1];
        double d7 = d4 * d4 + d5 * d5;
        double d8 = 1.0 - this.eccentricitySquared;
        int n3 = 18;
        do {
            if (--n3 < 0) {
                throw new ProjectionException(Resources.format((short)46));
            }
            d2 = Math.cos(d6);
            d = Math.sin(d6);
            double d9 = d * d;
            double d10 = Math.sqrt(1.0 - this.eccentricitySquared * d9);
            double d11 = d10 * d / d2;
            double d12 = this.distance(d6, d, d2);
            double d13 = d8 + d9 * (this.ci2 + d9 * (this.ci4 + d9 * this.ci6));
            double d14 = d12 * d12 + d7;
            double d15 = Math.sin(2.0 * d6);
            d3 = (d4 * (d12 * d11 + 1.0) - d12 - 0.5 * d14 * d11) / (this.eccentricitySquared * d15 * (d14 - 2.0 * d4 * d12) / (4.0 * d11) + (d4 - d12) * (d11 * d13 - 2.0 / d15) - d13);
            d6 -= d3;
        } while (Math.abs(d3) > 3.926676682852614E-10);
        d2 = Math.sin(d6);
        d = Math.asin(d5 * Math.tan(d6) * Math.sqrt(1.0 - this.eccentricitySquared * (d2 * d2))) / d2;
        if (!Double.isFinite(d) && Math.abs(d4) <= 1.5706706731410455E-9 && Double.isFinite(d5)) {
            d = d5;
            d6 = d4;
        }
        dArray2[n2] = d;
        dArray2[n2 + 1] = d6;
    }

    private static final class Spherical
    extends Polyconic {
        private static final long serialVersionUID = 8500881467002808593L;

        Spherical(Polyconic polyconic) {
            super(polyconic);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            double d5 = d4 / d3;
            if (Double.isInfinite(d5)) {
                if (dArray2 != null) {
                    dArray2[n2] = d;
                    dArray2[n2 + 1] = d2;
                }
                return bl ? new Matrix2() : null;
            }
            double d6 = d * d3;
            double d7 = Math.sin(d6);
            double d8 = Math.cos(d6);
            if (dArray2 != null) {
                dArray2[n2] = d7 * d5;
                dArray2[n2 + 1] = d2 + d5 * (1.0 - d8);
            }
            if (!bl) {
                return null;
            }
            double d9 = d4 * d4 * d;
            return new Matrix2(d4 * d8, (d9 * d8 - d7 / d3) / d3, d4 * d7, (d9 * d7 - (1.0 - d8) / d3) / d3 + 1.0);
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d;
            double d2;
            double d3;
            double d4 = dArray[n];
            double d5 = d3 = dArray[n + 1];
            double d6 = d4 * d4 + d3 * d3;
            int n3 = 18;
            do {
                if (--n3 < 0) {
                    throw new ProjectionException(Resources.format((short)46));
                }
                d = Math.tan(d5);
                d2 = (d3 * (d5 * d + 1.0) - d5 - 0.5 * (d5 * d5 + d6) * d) / ((d5 - d3) / d - 1.0);
                d5 -= d2;
            } while (Math.abs(d2) > 3.926676682852614E-10);
            d = Math.asin(d4 * Math.tan(d5)) / Math.sin(d5);
            if (!Double.isFinite(d) && Math.abs(d3) <= 1.5706706731410455E-9 && Double.isFinite(d4)) {
                d = d4;
                d5 = d3;
            }
            dArray2[n2] = d;
            dArray2[n2 + 1] = d5;
        }
    }
}

