﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationAssociationMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace PinpointSMSVoiceV2 {
namespace Model {
class ListRegistrationAssociationsResult {
 public:
  AWS_PINPOINTSMSVOICEV2_API ListRegistrationAssociationsResult() = default;
  AWS_PINPOINTSMSVOICEV2_API ListRegistrationAssociationsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PINPOINTSMSVOICEV2_API ListRegistrationAssociationsResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) for the registration.</p>
   */
  inline const Aws::String& GetRegistrationArn() const { return m_registrationArn; }
  template <typename RegistrationArnT = Aws::String>
  void SetRegistrationArn(RegistrationArnT&& value) {
    m_registrationArnHasBeenSet = true;
    m_registrationArn = std::forward<RegistrationArnT>(value);
  }
  template <typename RegistrationArnT = Aws::String>
  ListRegistrationAssociationsResult& WithRegistrationArn(RegistrationArnT&& value) {
    SetRegistrationArn(std::forward<RegistrationArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier for the registration.</p>
   */
  inline const Aws::String& GetRegistrationId() const { return m_registrationId; }
  template <typename RegistrationIdT = Aws::String>
  void SetRegistrationId(RegistrationIdT&& value) {
    m_registrationIdHasBeenSet = true;
    m_registrationId = std::forward<RegistrationIdT>(value);
  }
  template <typename RegistrationIdT = Aws::String>
  ListRegistrationAssociationsResult& WithRegistrationId(RegistrationIdT&& value) {
    SetRegistrationId(std::forward<RegistrationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of registration form. The list of <b>RegistrationTypes</b> can be
   * found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>
   */
  inline const Aws::String& GetRegistrationType() const { return m_registrationType; }
  template <typename RegistrationTypeT = Aws::String>
  void SetRegistrationType(RegistrationTypeT&& value) {
    m_registrationTypeHasBeenSet = true;
    m_registrationType = std::forward<RegistrationTypeT>(value);
  }
  template <typename RegistrationTypeT = Aws::String>
  ListRegistrationAssociationsResult& WithRegistrationType(RegistrationTypeT&& value) {
    SetRegistrationType(std::forward<RegistrationTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of RegistrationAssociationMetadata objects.</p>
   */
  inline const Aws::Vector<RegistrationAssociationMetadata>& GetRegistrationAssociations() const { return m_registrationAssociations; }
  template <typename RegistrationAssociationsT = Aws::Vector<RegistrationAssociationMetadata>>
  void SetRegistrationAssociations(RegistrationAssociationsT&& value) {
    m_registrationAssociationsHasBeenSet = true;
    m_registrationAssociations = std::forward<RegistrationAssociationsT>(value);
  }
  template <typename RegistrationAssociationsT = Aws::Vector<RegistrationAssociationMetadata>>
  ListRegistrationAssociationsResult& WithRegistrationAssociations(RegistrationAssociationsT&& value) {
    SetRegistrationAssociations(std::forward<RegistrationAssociationsT>(value));
    return *this;
  }
  template <typename RegistrationAssociationsT = RegistrationAssociationMetadata>
  ListRegistrationAssociationsResult& AddRegistrationAssociations(RegistrationAssociationsT&& value) {
    m_registrationAssociationsHasBeenSet = true;
    m_registrationAssociations.emplace_back(std::forward<RegistrationAssociationsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to be used for the next set of paginated results. You don't need to
   * supply a value for this field in the initial request.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListRegistrationAssociationsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListRegistrationAssociationsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_registrationArn;

  Aws::String m_registrationId;

  Aws::String m_registrationType;

  Aws::Vector<RegistrationAssociationMetadata> m_registrationAssociations;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_registrationArnHasBeenSet = false;
  bool m_registrationIdHasBeenSet = false;
  bool m_registrationTypeHasBeenSet = false;
  bool m_registrationAssociationsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace PinpointSMSVoiceV2
}  // namespace Aws
