/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.impl;

import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Coordinates;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;

public class PackedCoordinateSequenceFactory
implements CoordinateSequenceFactory,
Serializable {
    private static final long serialVersionUID = -3558264771905224525L;
    public static final int DOUBLE = 0;
    public static final int FLOAT = 1;
    public static final PackedCoordinateSequenceFactory DOUBLE_FACTORY = new PackedCoordinateSequenceFactory(0);
    public static final PackedCoordinateSequenceFactory FLOAT_FACTORY = new PackedCoordinateSequenceFactory(1);
    private static final int DEFAULT_MEASURES = 0;
    private static final int DEFAULT_DIMENSION = 3;
    private int type = 0;

    public PackedCoordinateSequenceFactory() {
        this(0);
    }

    public PackedCoordinateSequenceFactory(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public CoordinateSequence create(Coordinate[] coordinates) {
        int dimension = 3;
        int measures = 0;
        if (coordinates != null && coordinates.length > 0 && coordinates[0] != null) {
            Coordinate first = coordinates[0];
            dimension = Coordinates.dimension(first);
            measures = Coordinates.measures(first);
        }
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(coordinates, dimension, measures);
        }
        return new PackedCoordinateSequence.Float(coordinates, dimension, measures);
    }

    @Override
    public CoordinateSequence create(CoordinateSequence coordSeq) {
        int dimension = coordSeq.getDimension();
        int measures = coordSeq.getMeasures();
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(coordSeq.toCoordinateArray(), dimension, measures);
        }
        return new PackedCoordinateSequence.Float(coordSeq.toCoordinateArray(), dimension, measures);
    }

    public CoordinateSequence create(double[] packedCoordinates, int dimension) {
        return this.create(packedCoordinates, dimension, 0);
    }

    public CoordinateSequence create(double[] packedCoordinates, int dimension, int measures) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(packedCoordinates, dimension, measures);
        }
        return new PackedCoordinateSequence.Float(packedCoordinates, dimension, measures);
    }

    public CoordinateSequence create(float[] packedCoordinates, int dimension) {
        return this.create(packedCoordinates, dimension, Math.max(0, dimension - 3));
    }

    public CoordinateSequence create(float[] packedCoordinates, int dimension, int measures) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(packedCoordinates, dimension, measures);
        }
        return new PackedCoordinateSequence.Float(packedCoordinates, dimension, measures);
    }

    @Override
    public CoordinateSequence create(int size, int dimension) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(size, dimension, Math.max(0, dimension - 3));
        }
        return new PackedCoordinateSequence.Float(size, dimension, Math.max(0, dimension - 3));
    }

    @Override
    public CoordinateSequence create(int size, int dimension, int measures) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(size, dimension, measures);
        }
        return new PackedCoordinateSequence.Float(size, dimension, measures);
    }
}

