/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.Objects;
import java.util.logging.Level;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.proxy.ConnectionProxyFactory;
import oracle.ucp.jdbc.proxy.oracle.OracleConnectionProxyFactory;

public class OraclePooledConnectionConnectionPool
extends OracleJDBCConnectionPool
implements ConnectionEventListener {
    static final String CLASS_NAME = OraclePooledConnectionConnectionPool.class.getName();
    private final ConnectionProxyFactory cpf = new OracleConnectionProxyFactory();

    public OraclePooledConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter, diagnosticsCollector);
    }

    public OraclePooledConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        this(connectionFactoryAdapter, (Diagnosable)DiagnosticsCollectorImpl.getCommon());
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public PooledConnection getPooledConnection(JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void connectionRetrievalInfo;
            PooledConnection pc;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OraclePooledConnectionConnectionPool", "getPooledConnection", "entering args ({0})", null, null, jDBCConnectionRetrievalInfo);
            PooledConnection pooledConnection = pc = (PooledConnection)this.borrowConnection((ConnectionRetrievalInfo)connectionRetrievalInfo).getPhysicalConnection();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OraclePooledConnectionConnectionPool", "getPooledConnection", "returning {0}", null, null, pooledConnection);
            return pooledConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OraclePooledConnectionConnectionPool", "getPooledConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public boolean returnPooledConnection(PooledConnection pooledConnection) throws UniversalConnectionPoolException {
        try {
            void pooledConnection2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OraclePooledConnectionConnectionPool", "returnPooledConnection", "entering args ({0})", null, null, pooledConnection);
            boolean bl = this.returnUsedPhysicalConnection(pooledConnection2);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OraclePooledConnectionConnectionPool", "returnPooledConnection", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OraclePooledConnectionConnectionPool", "returnPooledConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void connectionClosed(ConnectionEvent connectionEvent) {
        try {
            void event;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OraclePooledConnectionConnectionPool", "connectionClosed", "entering args ({0})", null, null, connectionEvent);
            this.trace(Level.FINEST, CLASS_NAME, "connectionClosed", "Connection-closed event raised: {0}", null, null, event);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OraclePooledConnectionConnectionPool", "connectionClosed", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OraclePooledConnectionConnectionPool", "connectionClosed", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (Objects.nonNull(pc)) {
            pc.removeConnectionEventListener(this);
            this.trace(Level.FINEST, CLASS_NAME, "connectionErrorOccurred", "connection error event occurred: {0}", null, null, event);
        }
    }

    @Override
    public ConnectionProxyFactory getProxyFactory() {
        return this.cpf;
    }
}

