/*
 * Decompiled with CFR 0.152.
 */
package reactor.util.repeat;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;
import reactor.util.context.ContextView;
import reactor.util.repeat.ImmutableRepeatSignal;

public final class RepeatSpec
implements Function<Flux<Long>, Publisher<?>> {
    private static final Predicate<RepeatSignal> ALWAYS_TRUE = __ -> true;
    private static final Consumer<RepeatSignal> NO_OP_CONSUMER = rs -> {};
    private static final RepeatSignal TERMINATE = new ImmutableRepeatSignal(-1L, -1L, Duration.ZERO, Context.empty());
    final ContextView repeatContext;
    final long maxRepeats;
    final Predicate<RepeatSignal> repeatPredicate;
    final Consumer<RepeatSignal> beforeRepeatHook;
    final Consumer<RepeatSignal> afterRepeatHook;
    final Duration fixedDelay;
    final Scheduler scheduler;
    final double jitterFactor;

    private RepeatSpec(ContextView repeatContext, long maxRepeats, Predicate<RepeatSignal> repeatPredicate, Consumer<RepeatSignal> beforeRepeatHook, Consumer<RepeatSignal> afterRepeatHook, Duration fixedDelay, Scheduler scheduler, double jitterFactor) {
        this.repeatContext = repeatContext;
        this.maxRepeats = maxRepeats;
        this.repeatPredicate = repeatPredicate;
        this.beforeRepeatHook = beforeRepeatHook;
        this.afterRepeatHook = afterRepeatHook;
        this.fixedDelay = fixedDelay;
        this.scheduler = scheduler;
        this.jitterFactor = jitterFactor;
    }

    public static RepeatSpec once() {
        return RepeatSpec.times(1L);
    }

    public static RepeatSpec times(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n should be >= 0");
        }
        return new RepeatSpec(Context.empty(), n, ALWAYS_TRUE, NO_OP_CONSUMER, NO_OP_CONSUMER, Duration.ZERO, Schedulers.parallel(), 0.0);
    }

    public static RepeatSpec create(Predicate<RepeatSignal> predicate, long n) {
        return new RepeatSpec(Context.empty(), n, predicate, NO_OP_CONSUMER, NO_OP_CONSUMER, Duration.ZERO, Schedulers.parallel(), 0.0);
    }

    public RepeatSpec withRepeatContext(ContextView repeatContext) {
        return new RepeatSpec(repeatContext, this.maxRepeats, this.repeatPredicate, this.beforeRepeatHook, this.afterRepeatHook, this.fixedDelay, this.scheduler, this.jitterFactor);
    }

    public RepeatSpec onlyIf(Predicate<RepeatSignal> predicate) {
        return new RepeatSpec(this.repeatContext, this.maxRepeats, predicate, this.beforeRepeatHook, this.afterRepeatHook, this.fixedDelay, this.scheduler, this.jitterFactor);
    }

    public RepeatSpec doBeforeRepeat(Consumer<RepeatSignal> doBeforeRepeat) {
        return new RepeatSpec(this.repeatContext, this.maxRepeats, this.repeatPredicate, this.beforeRepeatHook.andThen(doBeforeRepeat), this.afterRepeatHook, this.fixedDelay, this.scheduler, this.jitterFactor);
    }

    public RepeatSpec doAfterRepeat(Consumer<RepeatSignal> doAfterRepeat) {
        return new RepeatSpec(this.repeatContext, this.maxRepeats, this.repeatPredicate, this.beforeRepeatHook, this.afterRepeatHook.andThen(doAfterRepeat), this.fixedDelay, this.scheduler, this.jitterFactor);
    }

    public RepeatSpec withFixedDelay(Duration delay) {
        return new RepeatSpec(this.repeatContext, this.maxRepeats, this.repeatPredicate, this.beforeRepeatHook, this.afterRepeatHook, delay, this.scheduler, this.jitterFactor);
    }

    public RepeatSpec jitter(double jitter) {
        return new RepeatSpec(this.repeatContext, this.maxRepeats, this.repeatPredicate, this.beforeRepeatHook, this.afterRepeatHook, this.fixedDelay, this.scheduler, jitter);
    }

    public RepeatSpec withScheduler(Scheduler scheduler) {
        return new RepeatSpec(this.repeatContext, this.maxRepeats, this.repeatPredicate, this.beforeRepeatHook, this.afterRepeatHook, this.fixedDelay, scheduler, this.jitterFactor);
    }

    @Override
    public Publisher<?> apply(Flux<Long> signals) {
        return this.generateCompanion(signals);
    }

    public Publisher<Long> generateCompanion(Flux<Long> signals) {
        return signals.index().map(tuple -> {
            long iter = (Long)tuple.getT1();
            long companionValue = (Long)tuple.getT2();
            ImmutableRepeatSignal signal = new ImmutableRepeatSignal(iter, companionValue, this.calculateDelay(), this.repeatContext);
            if (iter >= this.maxRepeats || !this.repeatPredicate.test(signal)) {
                return TERMINATE;
            }
            return signal;
        }).takeWhile(signal -> signal != TERMINATE).concatMap(signal -> {
            try {
                this.beforeRepeatHook.accept((RepeatSignal)signal);
            }
            catch (Throwable e) {
                return Mono.error(e);
            }
            Duration delay = signal.backoff();
            Mono<Long> trigger = delay.isZero() ? Mono.just(signal.companionValue()) : Mono.delay(delay, this.scheduler).thenReturn(signal.companionValue());
            return trigger.doOnSuccess(v -> this.afterRepeatHook.accept((RepeatSignal)signal));
        });
    }

    Duration calculateDelay() {
        Duration actual = this.fixedDelay;
        if (!this.fixedDelay.isZero() && this.jitterFactor > 0.0) {
            long base = this.fixedDelay.toMillis();
            long spread = (long)((double)base * this.jitterFactor);
            long offset = ThreadLocalRandom.current().nextLong(-spread, spread + 1L);
            actual = Duration.ofMillis(Math.max(0L, base + offset));
        }
        return actual;
    }

    public static interface RepeatSignal {
        public long iteration();

        public Long companionValue();

        public Duration backoff();

        public ContextView repeatContextView();

        public RepeatSignal copy();
    }
}

