/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.utils.OpenForTesting;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.replication.ReplicationPlugin;

@OpenForTesting
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002R\"\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\r\u001a\n \b*\u0004\u0018\u00010\u000e0\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\n \b*\u0004\u0018\u00010\u000e0\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R$\u0010\u0017\u001a\n \b*\u0004\u0018\u00010\u000e0\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u0018\u0010\u0010\"\u0004\b\u0019\u0010\u0012R$\u0010\u001a\u001a\n \b*\u0004\u0018\u00010\u000e0\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u001b\u0010\u0010\"\u0004\b\u001c\u0010\u0012R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010#\u001a\n \b*\u0004\u0018\u00010\u001e0\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R\"\u0010&\u001a\n \b*\u0004\u0018\u00010\u001e0\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R\"\u0010)\u001a\n \b*\u0004\u0018\u00010\u001e0\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010 \"\u0004\b+\u0010\"R\u001a\u0010,\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010 \"\u0004\b.\u0010\"R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001a\u0010:\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00102\"\u0004\b<\u00104\u00a8\u0006A"}, d2={"Lorg/opensearch/replication/ReplicationSettings;", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "<init>", "(Lorg/opensearch/cluster/service/ClusterService;)V", "chunkSize", "Lorg/opensearch/core/common/unit/ByteSizeValue;", "kotlin.jvm.PlatformType", "getChunkSize", "()Lorg/opensearch/core/common/unit/ByteSizeValue;", "setChunkSize", "(Lorg/opensearch/core/common/unit/ByteSizeValue;)V", "concurrentFileChunks", "", "getConcurrentFileChunks", "()Ljava/lang/Integer;", "setConcurrentFileChunks", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "readersPerShard", "getReadersPerShard", "setReadersPerShard", "writersPerShard", "getWritersPerShard", "setWritersPerShard", "batchSize", "getBatchSize", "setBatchSize", "pollDuration", "Lorg/opensearch/common/unit/TimeValue;", "getPollDuration", "()Lorg/opensearch/common/unit/TimeValue;", "setPollDuration", "(Lorg/opensearch/common/unit/TimeValue;)V", "autofollowFetchPollDuration", "getAutofollowFetchPollDuration", "setAutofollowFetchPollDuration", "autofollowRetryPollDuration", "getAutofollowRetryPollDuration", "setAutofollowRetryPollDuration", "metadataSyncInterval", "getMetadataSyncInterval", "setMetadataSyncInterval", "leaseRenewalMaxFailureDuration", "getLeaseRenewalMaxFailureDuration", "setLeaseRenewalMaxFailureDuration", "followerBlockStart", "", "getFollowerBlockStart", "()Z", "setFollowerBlockStart", "(Z)V", "autofollowConcurrentJobsTriggerSize", "getAutofollowConcurrentJobsTriggerSize", "()I", "setAutofollowConcurrentJobsTriggerSize", "(I)V", "replicateIndexDeletion", "getReplicateIndexDeletion", "setReplicateIndexDeletion", "listenForUpdates", "", "clusterSettings", "Lorg/opensearch/common/settings/ClusterSettings;", "opensearch-cross-cluster-replication"})
public class ReplicationSettings {
    private volatile ByteSizeValue chunkSize;
    private volatile Integer concurrentFileChunks;
    private volatile Integer readersPerShard;
    private volatile Integer writersPerShard;
    private volatile Integer batchSize;
    @NotNull
    private volatile TimeValue pollDuration;
    private volatile TimeValue autofollowFetchPollDuration;
    private volatile TimeValue autofollowRetryPollDuration;
    private volatile TimeValue metadataSyncInterval;
    @NotNull
    private volatile TimeValue leaseRenewalMaxFailureDuration;
    private volatile boolean followerBlockStart;
    private volatile int autofollowConcurrentJobsTriggerSize;
    private volatile boolean replicateIndexDeletion;

    public ReplicationSettings(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.chunkSize = (ByteSizeValue)ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_RECOVERY_CHUNK_SIZE().get(clusterService.getSettings());
        this.concurrentFileChunks = (Integer)ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_RECOVERY_PARALLEL_CHUNKS().get(clusterService.getSettings());
        this.readersPerShard = (Integer)clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_CONCURRENT_READERS_PER_SHARD());
        this.writersPerShard = (Integer)clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_CONCURRENT_WRITERS_PER_SHARD());
        this.batchSize = (Integer)clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_OPS_BATCH_SIZE());
        Object object = clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_PARALLEL_READ_POLL_INTERVAL());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.pollDuration = (TimeValue)object;
        this.autofollowFetchPollDuration = (TimeValue)clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_AUTOFOLLOW_REMOTE_INDICES_POLL_INTERVAL());
        this.autofollowRetryPollDuration = (TimeValue)clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_AUTOFOLLOW_REMOTE_INDICES_RETRY_POLL_INTERVAL());
        this.metadataSyncInterval = (TimeValue)clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_METADATA_SYNC_INTERVAL());
        Object object2 = clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_RETENTION_LEASE_MAX_FAILURE_DURATION());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        this.leaseRenewalMaxFailureDuration = (TimeValue)object2;
        Object object3 = clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_BLOCK_START());
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        this.followerBlockStart = (Boolean)object3;
        Object object4 = clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_AUTOFOLLOW_CONCURRENT_REPLICATION_JOBS_TRIGGER_SIZE());
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        this.autofollowConcurrentJobsTriggerSize = ((Number)object4).intValue();
        Object object5 = clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_REPLICATE_INDEX_DELETION());
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
        this.replicateIndexDeletion = (Boolean)object5;
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        Intrinsics.checkNotNullExpressionValue((Object)clusterSettings, (String)"getClusterSettings(...)");
        this.listenForUpdates(clusterSettings);
    }

    public final ByteSizeValue getChunkSize() {
        return this.chunkSize;
    }

    public final void setChunkSize(ByteSizeValue byteSizeValue) {
        this.chunkSize = byteSizeValue;
    }

    public final Integer getConcurrentFileChunks() {
        return this.concurrentFileChunks;
    }

    public final void setConcurrentFileChunks(Integer n) {
        this.concurrentFileChunks = n;
    }

    public final Integer getReadersPerShard() {
        return this.readersPerShard;
    }

    public final void setReadersPerShard(Integer n) {
        this.readersPerShard = n;
    }

    public final Integer getWritersPerShard() {
        return this.writersPerShard;
    }

    public final void setWritersPerShard(Integer n) {
        this.writersPerShard = n;
    }

    public final Integer getBatchSize() {
        return this.batchSize;
    }

    public final void setBatchSize(Integer n) {
        this.batchSize = n;
    }

    @NotNull
    public final TimeValue getPollDuration() {
        return this.pollDuration;
    }

    public final void setPollDuration(@NotNull TimeValue timeValue) {
        Intrinsics.checkNotNullParameter((Object)timeValue, (String)"<set-?>");
        this.pollDuration = timeValue;
    }

    public final TimeValue getAutofollowFetchPollDuration() {
        return this.autofollowFetchPollDuration;
    }

    public final void setAutofollowFetchPollDuration(TimeValue timeValue) {
        this.autofollowFetchPollDuration = timeValue;
    }

    public final TimeValue getAutofollowRetryPollDuration() {
        return this.autofollowRetryPollDuration;
    }

    public final void setAutofollowRetryPollDuration(TimeValue timeValue) {
        this.autofollowRetryPollDuration = timeValue;
    }

    public final TimeValue getMetadataSyncInterval() {
        return this.metadataSyncInterval;
    }

    public final void setMetadataSyncInterval(TimeValue timeValue) {
        this.metadataSyncInterval = timeValue;
    }

    @NotNull
    public final TimeValue getLeaseRenewalMaxFailureDuration() {
        return this.leaseRenewalMaxFailureDuration;
    }

    public final void setLeaseRenewalMaxFailureDuration(@NotNull TimeValue timeValue) {
        Intrinsics.checkNotNullParameter((Object)timeValue, (String)"<set-?>");
        this.leaseRenewalMaxFailureDuration = timeValue;
    }

    public final boolean getFollowerBlockStart() {
        return this.followerBlockStart;
    }

    public final void setFollowerBlockStart(boolean bl) {
        this.followerBlockStart = bl;
    }

    public final int getAutofollowConcurrentJobsTriggerSize() {
        return this.autofollowConcurrentJobsTriggerSize;
    }

    public final void setAutofollowConcurrentJobsTriggerSize(int n) {
        this.autofollowConcurrentJobsTriggerSize = n;
    }

    public final boolean getReplicateIndexDeletion() {
        return this.replicateIndexDeletion;
    }

    public final void setReplicateIndexDeletion(boolean bl) {
        this.replicateIndexDeletion = bl;
    }

    private final void listenForUpdates(ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_RECOVERY_CHUNK_SIZE(), arg_0 -> ReplicationSettings.listenForUpdates$lambda$0(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_RECOVERY_PARALLEL_CHUNKS(), arg_0 -> ReplicationSettings.listenForUpdates$lambda$1(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_CONCURRENT_READERS_PER_SHARD(), arg_0 -> ReplicationSettings.listenForUpdates$lambda$2(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_CONCURRENT_WRITERS_PER_SHARD(), arg_0 -> ReplicationSettings.listenForUpdates$lambda$3(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_OPS_BATCH_SIZE(), arg_0 -> ReplicationSettings.listenForUpdates$lambda$4(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_PARALLEL_READ_POLL_INTERVAL(), arg_0 -> ReplicationSettings.listenForUpdates$lambda$5(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_RETENTION_LEASE_MAX_FAILURE_DURATION(), arg_0 -> ReplicationSettings.listenForUpdates$lambda$6(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_AUTOFOLLOW_REMOTE_INDICES_POLL_INTERVAL(), arg_0 -> ReplicationSettings.listenForUpdates$lambda$7(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_AUTOFOLLOW_REMOTE_INDICES_RETRY_POLL_INTERVAL(), arg_0 -> ReplicationSettings.listenForUpdates$lambda$8(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_METADATA_SYNC_INTERVAL(), arg_0 -> ReplicationSettings.listenForUpdates$lambda$9(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_BLOCK_START(), arg_0 -> ReplicationSettings.listenForUpdates$lambda$10(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_AUTOFOLLOW_CONCURRENT_REPLICATION_JOBS_TRIGGER_SIZE(), arg_0 -> ReplicationSettings.listenForUpdates$lambda$11(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_REPLICATE_INDEX_DELETION(), arg_0 -> ReplicationSettings.listenForUpdates$lambda$12(this, arg_0));
    }

    private static final void listenForUpdates$lambda$0(ReplicationSettings this$0, ByteSizeValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this$0.chunkSize = value;
    }

    private static final void listenForUpdates$lambda$1(ReplicationSettings this$0, int value) {
        this$0.concurrentFileChunks = value;
    }

    private static final void listenForUpdates$lambda$2(ReplicationSettings this$0, int value) {
        this$0.readersPerShard = value;
    }

    private static final void listenForUpdates$lambda$3(ReplicationSettings this$0, int value) {
        this$0.writersPerShard = value;
    }

    private static final void listenForUpdates$lambda$4(ReplicationSettings this$0, Integer it) {
        this$0.batchSize = it;
    }

    private static final void listenForUpdates$lambda$5(ReplicationSettings this$0, TimeValue it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.pollDuration = it;
    }

    private static final void listenForUpdates$lambda$6(ReplicationSettings this$0, TimeValue it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.leaseRenewalMaxFailureDuration = it;
    }

    private static final void listenForUpdates$lambda$7(ReplicationSettings this$0, TimeValue it) {
        this$0.autofollowFetchPollDuration = it;
    }

    private static final void listenForUpdates$lambda$8(ReplicationSettings this$0, TimeValue it) {
        this$0.autofollowRetryPollDuration = it;
    }

    private static final void listenForUpdates$lambda$9(ReplicationSettings this$0, TimeValue it) {
        this$0.metadataSyncInterval = it;
    }

    private static final void listenForUpdates$lambda$10(ReplicationSettings this$0, Boolean it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.followerBlockStart = it;
    }

    private static final void listenForUpdates$lambda$11(ReplicationSettings this$0, Integer it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.autofollowConcurrentJobsTriggerSize = it;
    }

    private static final void listenForUpdates$lambda$12(ReplicationSettings this$0, Boolean it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.replicateIndexDeletion = it;
    }
}

