/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum VerticalAlign {
    BASELINE(1),
    SUPERSCRIPT(2),
    SUBSCRIPT(3);

    private static final Map<Integer, VerticalAlign> imap;
    private final int value;

    private VerticalAlign(int val) {
        this.value = val;
    }

    public static VerticalAlign valueOf(int type) {
        VerticalAlign align = imap.get(type);
        if (align == null) {
            throw new IllegalArgumentException("Unknown vertical alignment: " + type);
        }
        return align;
    }

    public int getValue() {
        return this.value;
    }

    static {
        HashMap<Integer, VerticalAlign> tempMap = new HashMap<Integer, VerticalAlign>();
        for (VerticalAlign p : VerticalAlign.values()) {
            tempMap.put(p.getValue(), p);
        }
        imap = Collections.unmodifiableMap(tempMap);
    }
}

