/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ArrayPercentilesItem
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ArrayPercentilesItem> {
    @Nonnull
    private final String key;
    @Nullable
    private final Double value;
    @Nullable
    private final String valueAsString;
    public static final JsonpDeserializer<ArrayPercentilesItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ArrayPercentilesItem::setupArrayPercentilesItemDeserializer);

    private ArrayPercentilesItem(Builder builder) {
        this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");
        this.value = builder.value;
        this.valueAsString = builder.valueAsString;
    }

    public static ArrayPercentilesItem of(Function<Builder, ObjectBuilder<ArrayPercentilesItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String key() {
        return this.key;
    }

    @Nullable
    public final Double value() {
        return this.value;
    }

    @Nullable
    public final String valueAsString() {
        return this.valueAsString;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("key");
        generator.write(this.key);
        if (this.value != null) {
            generator.writeKey("value");
            generator.write(this.value.doubleValue());
        }
        if (this.valueAsString != null) {
            generator.writeKey("value_as_string");
            generator.write(this.valueAsString);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupArrayPercentilesItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::key, JsonpDeserializer.stringDeserializer(), "key");
        op.add(Builder::value, JsonpDeserializer.doubleDeserializer(), "value");
        op.add(Builder::valueAsString, JsonpDeserializer.stringDeserializer(), "value_as_string");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + Objects.hashCode(this.value);
        result = 31 * result + Objects.hashCode(this.valueAsString);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayPercentilesItem other = (ArrayPercentilesItem)o;
        return this.key.equals(other.key) && Objects.equals(this.value, other.value) && Objects.equals(this.valueAsString, other.valueAsString);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ArrayPercentilesItem> {
        private String key;
        @Nullable
        private Double value;
        @Nullable
        private String valueAsString;

        public Builder() {
        }

        private Builder(ArrayPercentilesItem o) {
            this.key = o.key;
            this.value = o.value;
            this.valueAsString = o.valueAsString;
        }

        private Builder(Builder o) {
            this.key = o.key;
            this.value = o.value;
            this.valueAsString = o.valueAsString;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder key(String value) {
            this.key = value;
            return this;
        }

        @Nonnull
        public final Builder value(@Nullable Double value) {
            this.value = value;
            return this;
        }

        @Nonnull
        public final Builder valueAsString(@Nullable String value) {
            this.valueAsString = value;
            return this;
        }

        @Override
        @Nonnull
        public ArrayPercentilesItem build() {
            this._checkSingleUse();
            return new ArrayPercentilesItem(this);
        }
    }
}

