/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.protege.editor.owl.model.OWLEditorKitOntologyShortFormProvider;
import org.protege.editor.owl.model.OWLEditorKitShortFormProvider;
import org.protege.editor.owl.ui.action.FocusedComponentAction;
import org.protege.editor.owl.ui.renderer.context.OWLObjectRenderingContext;
import org.protege.editor.owl.ui.renderer.styledstring.OWLObjectStyledStringRenderer;
import org.protege.editor.owl.ui.renderer.styledstring.StyledString;
import org.protege.editor.owl.ui.renderer.styledstring.StyledStringSelection;
import org.protege.editor.owl.ui.transfer.TransferableOWLObject;
import org.protege.editor.owl.ui.view.Copyable;
import org.protege.editor.owl.ui.view.ViewClipboard;
import org.semanticweb.owlapi.model.OWLObject;

public class CopyToHMTLAction
extends FocusedComponentAction<Copyable> {
    @Override
    protected boolean canPerform() {
        return ((Copyable)this.getCurrentTarget()).canCopy();
    }

    @Override
    protected Class<Copyable> initialiseAction() {
        return Copyable.class;
    }

    public void actionPerformed(ActionEvent e) {
        List<OWLObject> objects = ((Copyable)this.getCurrentTarget()).getObjectsToCopy();
        if (objects.isEmpty()) {
            return;
        }
        ViewClipboard clipboard = ViewClipboard.getInstance();
        clipboard.getClipboard().setContents(new TransferableOWLObject(this.getOWLModelManager(), objects), null);
        new TransferableOWLObject(this.getOWLModelManager(), objects);
        OWLEditorKitShortFormProvider sfp = new OWLEditorKitShortFormProvider(this.getOWLEditorKit());
        OWLEditorKitOntologyShortFormProvider ontSfp = new OWLEditorKitOntologyShortFormProvider(this.getOWLEditorKit());
        OWLObjectRenderingContext renderingContext = new OWLObjectRenderingContext(sfp, ontSfp);
        OWLObjectStyledStringRenderer renderer = new OWLObjectStyledStringRenderer(renderingContext);
        StyledString.Builder complete = new StyledString.Builder();
        for (OWLObject owlObject : objects) {
            StyledString styledString = renderer.getRendering(owlObject);
            complete.appendStyledString(styledString);
            complete.appendNewLine();
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StyledStringSelection(complete.build()), null);
    }

    private static class HtmlSelection
    implements Transferable {
        private static ArrayList<DataFlavor> htmlFlavors = new ArrayList();
        private String html;
        private String rtf;

        public HtmlSelection(String html, String rtf) {
            this.html = html;
            this.rtf = rtf;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return htmlFlavors.toArray(new DataFlavor[htmlFlavors.size()]);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return htmlFlavors.contains(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            String toRet = this.html;
            if (flavor.isMimeTypeEqual("application/rtf")) {
                toRet = this.rtf;
            }
            if (String.class.equals(flavor.getRepresentationClass())) {
                return toRet;
            }
            if (Reader.class.equals(flavor.getRepresentationClass())) {
                return new StringReader(toRet);
            }
            if (InputStream.class.equals(flavor.getRepresentationClass())) {
                return new StringBufferInputStream(toRet);
            }
            throw new UnsupportedFlavorException(flavor);
        }

        static {
            try {
                htmlFlavors.add(new DataFlavor("application/rtf;class=java.lang.String"));
                htmlFlavors.add(new DataFlavor("text/html;class=java.lang.String"));
                htmlFlavors.add(new DataFlavor("text/html;class=java.io.Reader"));
                htmlFlavors.add(new DataFlavor("text/html;charset=unicode;class=java.io.InputStream"));
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }
}

