/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelAccessor;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.BaseByteToByteConverter;
import com.sun.javafx.image.impl.ByteBgra;
import java.nio.ByteBuffer;

public class ByteRgba {
    public static final BytePixelGetter getter = Accessor.instance;
    public static final BytePixelSetter setter = Accessor.instance;
    public static final BytePixelAccessor accessor = Accessor.instance;
    private static ByteToBytePixelConverter ToByteRgbaObj;
    private static ByteToBytePixelConverter ToByteBgraObj;

    public static ByteToBytePixelConverter ToByteRgbaConverter() {
        if (ToByteRgbaObj == null) {
            ToByteRgbaObj = BaseByteToByteConverter.create(accessor);
        }
        return ToByteRgbaObj;
    }

    public static ByteToBytePixelConverter ToByteBgraConverter() {
        if (ToByteBgraObj == null) {
            ToByteBgraObj = BaseByteToByteConverter.createReorderer(getter, ByteBgra.setter, 2, 1, 0, 3);
        }
        return ToByteBgraObj;
    }

    static class Accessor
    implements BytePixelAccessor {
        static final BytePixelAccessor instance = new Accessor();

        private Accessor() {
        }

        @Override
        public AlphaType getAlphaType() {
            return AlphaType.NONPREMULTIPLIED;
        }

        @Override
        public int getNumElements() {
            return 4;
        }

        @Override
        public int getArgb(byte[] byArray, int n) {
            return byArray[n + 2] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n] & 0xFF) << 16 | byArray[n + 3] << 24;
        }

        @Override
        public int getArgbPre(byte[] byArray, int n) {
            return PixelUtils.NonPretoPre(this.getArgb(byArray, n));
        }

        @Override
        public int getArgb(ByteBuffer byteBuffer, int n) {
            return byteBuffer.get(n + 2) & 0xFF | (byteBuffer.get(n + 1) & 0xFF) << 8 | (byteBuffer.get(n) & 0xFF) << 16 | byteBuffer.get(n + 3) << 24;
        }

        @Override
        public int getArgbPre(ByteBuffer byteBuffer, int n) {
            return PixelUtils.NonPretoPre(this.getArgb(byteBuffer, n));
        }

        @Override
        public void setArgb(byte[] byArray, int n, int n2) {
            byArray[n] = (byte)(n2 >> 16);
            byArray[n + 1] = (byte)(n2 >> 8);
            byArray[n + 2] = (byte)n2;
            byArray[n + 3] = (byte)(n2 >> 24);
        }

        @Override
        public void setArgbPre(byte[] byArray, int n, int n2) {
            this.setArgb(byArray, n, PixelUtils.PretoNonPre(n2));
        }

        @Override
        public void setArgb(ByteBuffer byteBuffer, int n, int n2) {
            byteBuffer.put(n, (byte)(n2 >> 16));
            byteBuffer.put(n + 1, (byte)(n2 >> 8));
            byteBuffer.put(n + 2, (byte)n2);
            byteBuffer.put(n + 3, (byte)(n2 >> 24));
        }

        @Override
        public void setArgbPre(ByteBuffer byteBuffer, int n, int n2) {
            this.setArgb(byteBuffer, n, PixelUtils.PretoNonPre(n2));
        }
    }
}

