/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.CloseableIterator;
import de.siegmar.fastcsv.reader.CommentStrategy;
import de.siegmar.fastcsv.reader.CsvRow;
import de.siegmar.fastcsv.reader.CsvRowSpliterator;
import de.siegmar.fastcsv.reader.MalformedCsvException;
import de.siegmar.fastcsv.reader.RowReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.StringJoiner;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class CsvReader
implements Iterable<CsvRow>,
Closeable {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private final RowReader rowReader;
    private final CommentStrategy commentStrategy;
    private final boolean skipEmptyRows;
    private final boolean errorOnDifferentFieldCount;
    private final CloseableIterator<CsvRow> csvRowIterator = new CsvRowIterator();
    private final Reader reader;
    private int firstLineFieldCount = -1;

    CsvReader(Reader reader, char fieldSeparator, char quoteCharacter, CommentStrategy commentStrategy, char commentCharacter, boolean skipEmptyRows, boolean errorOnDifferentFieldCount) {
        this.assertFields(fieldSeparator, quoteCharacter, commentCharacter);
        this.commentStrategy = commentStrategy;
        this.skipEmptyRows = skipEmptyRows;
        this.errorOnDifferentFieldCount = errorOnDifferentFieldCount;
        this.reader = reader;
        this.rowReader = new RowReader(reader, fieldSeparator, quoteCharacter, commentStrategy, commentCharacter);
    }

    CsvReader(String data, char fieldSeparator, char quoteCharacter, CommentStrategy commentStrategy, char commentCharacter, boolean skipEmptyRows, boolean errorOnDifferentFieldCount) {
        this.assertFields(fieldSeparator, quoteCharacter, commentCharacter);
        this.commentStrategy = commentStrategy;
        this.skipEmptyRows = skipEmptyRows;
        this.errorOnDifferentFieldCount = errorOnDifferentFieldCount;
        this.reader = null;
        this.rowReader = new RowReader(data, fieldSeparator, quoteCharacter, commentStrategy, commentCharacter);
    }

    private void assertFields(char fieldSeparator, char quoteCharacter, char commentCharacter) {
        if (fieldSeparator == '\r' || fieldSeparator == '\n') {
            throw new IllegalArgumentException("fieldSeparator must not be a newline char");
        }
        if (quoteCharacter == '\r' || quoteCharacter == '\n') {
            throw new IllegalArgumentException("quoteCharacter must not be a newline char");
        }
        if (commentCharacter == '\r' || commentCharacter == '\n') {
            throw new IllegalArgumentException("commentCharacter must not be a newline char");
        }
        if (fieldSeparator == quoteCharacter || fieldSeparator == commentCharacter || quoteCharacter == commentCharacter) {
            throw new IllegalArgumentException(String.format("Control characters must differ (fieldSeparator=%s, quoteCharacter=%s, commentCharacter=%s)", Character.valueOf(fieldSeparator), Character.valueOf(quoteCharacter), Character.valueOf(commentCharacter)));
        }
    }

    public static CsvReaderBuilder builder() {
        return new CsvReaderBuilder();
    }

    @Override
    public CloseableIterator<CsvRow> iterator() {
        return this.csvRowIterator;
    }

    @Override
    public Spliterator<CsvRow> spliterator() {
        return new CsvRowSpliterator<CsvRow>(this.csvRowIterator);
    }

    public Stream<CsvRow> stream() {
        return (Stream)StreamSupport.stream(this.spliterator(), false).onClose(() -> {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private CsvRow fetchRow() throws IOException {
        CsvRow csvRow;
        while ((csvRow = this.rowReader.fetchAndRead()) != null) {
            if (this.commentStrategy == CommentStrategy.SKIP && csvRow.isComment()) continue;
            if (csvRow.isEmpty()) {
                if (!this.skipEmptyRows) break;
                continue;
            }
            if (!this.errorOnDifferentFieldCount) break;
            int fieldCount = csvRow.getFieldCount();
            if (this.firstLineFieldCount == -1) {
                this.firstLineFieldCount = fieldCount;
                break;
            }
            if (fieldCount == this.firstLineFieldCount) break;
            throw new MalformedCsvException(String.format("Row %d has %d fields, but first row had %d fields", csvRow.getOriginalLineNumber(), fieldCount, this.firstLineFieldCount));
        }
        return csvRow;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public String toString() {
        return new StringJoiner(", ", CsvReader.class.getSimpleName() + "[", "]").add("commentStrategy=" + (Object)((Object)this.commentStrategy)).add("skipEmptyRows=" + this.skipEmptyRows).add("errorOnDifferentFieldCount=" + this.errorOnDifferentFieldCount).toString();
    }

    public static final class CsvReaderBuilder {
        private char fieldSeparator = (char)44;
        private char quoteCharacter = (char)34;
        private CommentStrategy commentStrategy = CommentStrategy.NONE;
        private char commentCharacter = (char)35;
        private boolean skipEmptyRows = true;
        private boolean errorOnDifferentFieldCount;

        private CsvReaderBuilder() {
        }

        public CsvReaderBuilder fieldSeparator(char fieldSeparator) {
            this.fieldSeparator = fieldSeparator;
            return this;
        }

        public CsvReaderBuilder quoteCharacter(char quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
            return this;
        }

        public CsvReaderBuilder commentStrategy(CommentStrategy commentStrategy) {
            this.commentStrategy = commentStrategy;
            return this;
        }

        public CsvReaderBuilder commentCharacter(char commentCharacter) {
            this.commentCharacter = commentCharacter;
            return this;
        }

        public CsvReaderBuilder skipEmptyRows(boolean skipEmptyRows) {
            this.skipEmptyRows = skipEmptyRows;
            return this;
        }

        public CsvReaderBuilder errorOnDifferentFieldCount(boolean errorOnDifferentFieldCount) {
            this.errorOnDifferentFieldCount = errorOnDifferentFieldCount;
            return this;
        }

        public CsvReader build(Reader reader) {
            return this.newReader(Objects.requireNonNull(reader, "reader must not be null"));
        }

        public CsvReader build(String data) {
            return this.newReader(Objects.requireNonNull(data, "data must not be null"));
        }

        public CsvReader build(Path path) throws IOException {
            return this.build(path, StandardCharsets.UTF_8);
        }

        public CsvReader build(Path path, Charset charset) throws IOException {
            Objects.requireNonNull(path, "path must not be null");
            Objects.requireNonNull(charset, "charset must not be null");
            return this.newReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), charset));
        }

        private CsvReader newReader(Reader reader) {
            return new CsvReader(reader, this.fieldSeparator, this.quoteCharacter, this.commentStrategy, this.commentCharacter, this.skipEmptyRows, this.errorOnDifferentFieldCount);
        }

        private CsvReader newReader(String data) {
            return new CsvReader(data, this.fieldSeparator, this.quoteCharacter, this.commentStrategy, this.commentCharacter, this.skipEmptyRows, this.errorOnDifferentFieldCount);
        }

        public String toString() {
            return new StringJoiner(", ", CsvReaderBuilder.class.getSimpleName() + "[", "]").add("fieldSeparator=" + this.fieldSeparator).add("quoteCharacter=" + this.quoteCharacter).add("commentStrategy=" + (Object)((Object)this.commentStrategy)).add("commentCharacter=" + this.commentCharacter).add("skipEmptyRows=" + this.skipEmptyRows).add("errorOnDifferentFieldCount=" + this.errorOnDifferentFieldCount).toString();
        }
    }

    private class CsvRowIterator
    implements CloseableIterator<CsvRow> {
        private CsvRow fetchedRow;
        private boolean fetched;

        private CsvRowIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!this.fetched) {
                this.fetch();
            }
            return this.fetchedRow != null;
        }

        @Override
        public CsvRow next() {
            if (!this.fetched) {
                this.fetch();
            }
            if (this.fetchedRow == null) {
                throw new NoSuchElementException();
            }
            this.fetched = false;
            return this.fetchedRow;
        }

        private void fetch() {
            try {
                this.fetchedRow = CsvReader.this.fetchRow();
            }
            catch (IOException e) {
                if (this.fetchedRow != null) {
                    throw new UncheckedIOException("IOException when reading record that started in line " + (this.fetchedRow.getOriginalLineNumber() + 1L), e);
                }
                throw new UncheckedIOException("IOException when reading first record", e);
            }
            this.fetched = true;
        }

        @Override
        public void close() throws IOException {
            CsvReader.this.close();
        }
    }
}

