/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@Deprecated(since="1.21.3", forRemoval=true)
@ApiStatus.Internal
public class UniqueModListBuilder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<ModFile> modFiles;

    public UniqueModListBuilder(List<ModFile> modFiles) {
        this.modFiles = modFiles;
    }

    public UniqueModListData buildUniqueList() {
        Map<String, List<ModFile>> modFilesByFirstId = this.modFiles.stream().filter(mf -> mf.getModFileInfo() != null).collect(Collectors.groupingBy(UniqueModListBuilder::getModId));
        Map<String, List<ModFile>> libFilesWithVersionByModuleName = this.modFiles.stream().filter(mf -> mf.getModFileInfo() == null).collect(Collectors.groupingBy(UniqueModListBuilder::getModId));
        List<ModFile> uniqueModList = modFilesByFirstId.entrySet().stream().map(UniqueModListBuilder::selectNewestModInfo).toList();
        List<ModFile> uniqueLibListWithVersion = libFilesWithVersionByModuleName.entrySet().stream().map(UniqueModListBuilder::selectNewestModInfo).toList();
        Map<String, List<IModInfo>> modIds = uniqueModList.stream().filter(mf -> mf.getModFileInfo() != null).map(ModFile::getModInfos).flatMap(Collection::stream).collect(Collectors.groupingBy(IModInfo::getModId));
        Map versionedLibIds = uniqueLibListWithVersion.stream().map(UniqueModListBuilder::getModId).collect(Collectors.toMap(Function.identity(), libFilesWithVersionByModuleName::get));
        List<String> dupedModErrors = modIds.values().stream().filter(modInfos -> modInfos.size() > 1).map(mods -> String.format("\tMod ID: '%s' from mod files: %s", ((IModInfo)mods.getFirst()).getModId(), mods.stream().map(modInfo -> modInfo.getOwningFile().getFile().getFileName()).collect(Collectors.joining(", ")))).toList();
        if (!dupedModErrors.isEmpty()) {
            LOGGER.error(LogMarkers.LOADING, "Found duplicate mods:\n{}", (Object)dupedModErrors.stream().collect(Collectors.joining("\n")));
            throw new EarlyLoadingException("Duplicate mods found", null, dupedModErrors.stream().map(s -> new EarlyLoadingException.ExceptionData((String)s, new Object[0])).toList());
        }
        List<String> dupedLibErrors = versionedLibIds.values().stream().filter(modFiles -> modFiles.size() > 1).map(mods -> String.format("\tLibrary: '%s' from files: %s", UniqueModListBuilder.getModId((ModFile)mods.getFirst()), mods.stream().map(ModFile::getFileName).collect(Collectors.joining(", ")))).toList();
        if (!dupedLibErrors.isEmpty()) {
            LOGGER.error(LogMarkers.LOADING, "Found duplicate plugins or libraries:\n{}", (Object)dupedLibErrors.stream().collect(Collectors.joining("\n")));
            throw new EarlyLoadingException("Duplicate plugins or libraries found", null, dupedLibErrors.stream().map(s -> new EarlyLoadingException.ExceptionData((String)s, new Object[0])).toList());
        }
        Map<String, List<ModFile>> uniqueModFilesByFirstId = uniqueModList.stream().collect(Collectors.groupingBy(UniqueModListBuilder::getModId));
        ArrayList<ModFile> loadedList = new ArrayList<ModFile>(uniqueModList);
        loadedList.addAll(uniqueLibListWithVersion);
        return new UniqueModListData(loadedList, uniqueModFilesByFirstId);
    }

    private static ModFile selectNewestModInfo(Map.Entry<String, List<ModFile>> fullList) {
        List<ModFile> modInfoList = fullList.getValue();
        if (modInfoList.size() > 1) {
            LOGGER.debug("Found {} mods for first modid {}, selecting most recent based on version data", (Object)modInfoList.size(), (Object)fullList.getKey());
            modInfoList.sort(Comparator.comparing(UniqueModListBuilder::getVersion).reversed());
            LOGGER.debug("Selected file {} for modid {} with version {}", new Object[]{modInfoList.getFirst().getFileName(), fullList.getKey(), UniqueModListBuilder.getVersion(modInfoList.getFirst())});
        }
        return modInfoList.get(0);
    }

    private static ArtifactVersion getVersion(ModFile mf) {
        if (mf.getModFileInfo() == null || mf.getModInfos() == null || mf.getModInfos().isEmpty()) {
            return mf.getJarVersion();
        }
        return mf.getModInfos().get(0).getVersion();
    }

    private static String getModId(ModFile modFile) {
        if (modFile.getModFileInfo() == null || modFile.getModFileInfo().getMods().isEmpty()) {
            return modFile.getSecureJar().name();
        }
        return ((IModInfo)modFile.getModFileInfo().getMods().get(0)).getModId();
    }

    public record UniqueModListData(List<ModFile> modFiles, Map<String, List<ModFile>> modFilesByFirstId) {
    }
}

