/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.javafmlmod;

import cpw.mods.jarhandling.SecureJar;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.jar.Attributes;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.javafmlmod.AutomaticEventSubscriber;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.unsafe.UnsafeHacks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class FMLModContainer
extends ModContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker LOADING = MarkerManager.getMarker((String)"LOADING");
    private final ModFileScanData scanResults;
    private final BusGroup eventBusGroup;
    private Object modInstance;
    private final Class<?> modClass;
    private final FMLJavaModLoadingContext context = new FMLJavaModLoadingContext(this);
    private static Method implAddExportsOrOpens;

    public FMLModContainer(IModInfo info, String className, ModFileScanData modFileScanResults, ModuleLayer gameLayer) {
        super(info);
        LOGGER.debug(LOADING, "Creating FMLModContainer instance for {}", (Object)className);
        this.scanResults = modFileScanResults;
        this.activityMap.put(ModLoadingStage.CONSTRUCT, this::constructMod);
        this.eventBusGroup = BusGroup.create((String)("modBusFor" + info.getModId()));
        this.contextExtension = () -> this.context;
        try {
            String moduleName = info.getOwningFile().moduleName();
            Module module = gameLayer.findModule(moduleName).orElseThrow(() -> new IllegalStateException("Failed to find " + moduleName + " in " + String.valueOf(gameLayer)));
            FMLModContainer.openModules(gameLayer, module, info.getOwningFile().getFile().getSecureJar());
            this.modClass = Class.forName(module, className);
            LOGGER.debug(LOADING, "Loaded modclass {}/{} with {}", (Object)this.modClass.getModule().getName(), (Object)this.modClass.getName(), (Object)this.modClass.getClassLoader());
        }
        catch (Throwable e) {
            LOGGER.error(LOADING, "Failed to load class {}", (Object)className, (Object)e);
            throw new ModLoadingException(info, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmodclass", e, new Object[0]);
        }
    }

    private static void openModules(ModuleLayer layer, Module self, SecureJar jar) throws NoSuchMethodException, SecurityException, IllegalAccessException, InvocationTargetException {
        Attributes manifest = jar.moduleDataProvider().getManifest().getMainAttributes();
        FMLModContainer.addOpenOrExports(layer, self, true, manifest);
        FMLModContainer.addOpenOrExports(layer, self, false, manifest);
    }

    private static void addOpenOrExports(ModuleLayer layer, Module self, boolean open, Attributes attrs) throws NoSuchMethodException, SecurityException, IllegalAccessException, InvocationTargetException {
        String key = open ? "Add-Opens" : "Add-Exports";
        String entry = attrs.getValue(key);
        if (entry == null) {
            return;
        }
        for (String pair : entry.split(" ")) {
            String[] pts = pair.trim().split("/");
            if (pts.length == 2) {
                Module target = layer.findModule(pts[0]).orElse(null);
                if (target == null || !target.getDescriptor().packages().contains(pts[1])) continue;
                FMLModContainer.addOpenOrExport(target, pts[1], self, open);
                continue;
            }
            LOGGER.warn(LOADING, "Invalid {} entry in {}: {}", (Object)key, (Object)self.getName(), (Object)pair);
        }
    }

    private static void addOpenOrExport(Module target, String pkg, Module reader, boolean open) throws NoSuchMethodException, SecurityException, IllegalAccessException, InvocationTargetException {
        if (implAddExportsOrOpens == null) {
            implAddExportsOrOpens = Module.class.getDeclaredMethod("implAddExportsOrOpens", String.class, Module.class, Boolean.TYPE, Boolean.TYPE);
            UnsafeHacks.setAccessible((AccessibleObject)implAddExportsOrOpens);
        }
        LOGGER.info(LOADING, "{} {}/{} to {}", (Object)(open ? "Opening" : "Exporting"), (Object)target.getName(), (Object)pkg, (Object)reader.getName());
        implAddExportsOrOpens.invoke((Object)target, pkg, reader, open, true);
    }

    private void constructMod() {
        try {
            Constructor<?> constructor;
            LOGGER.trace(LOADING, "Loading mod instance {} of type {}", (Object)this.getModId(), (Object)this.modClass.getName());
            try {
                constructor = this.modClass.getDeclaredConstructor(((Object)((Object)this.context)).getClass());
            }
            catch (NoSuchMethodException | SecurityException exception) {
                constructor = this.modClass.getDeclaredConstructor(new Class[0]);
            }
            this.modInstance = constructor.getParameterCount() == 0 ? constructor.newInstance(new Object[0]) : constructor.newInstance(new Object[]{this.context});
            LOGGER.trace(LOADING, "Loaded mod instance {} of type {}", (Object)this.getModId(), (Object)this.modClass.getName());
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException wrapped = (InvocationTargetException)e;
                e = Objects.requireNonNullElse(wrapped.getCause(), e);
            }
            LOGGER.error(LOADING, "Failed to create mod instance. ModID: {}, class {}", (Object)this.getModId(), (Object)this.modClass.getName(), (Object)e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", e, new Object[]{this.modClass});
        }
        try {
            LOGGER.trace(LOADING, "Injecting Automatic event subscribers for {}", (Object)this.getModId());
            AutomaticEventSubscriber.inject(this, this.scanResults, this.modClass.getClassLoader());
            LOGGER.trace(LOADING, "Completed Automatic event subscribers for {}", (Object)this.getModId());
        }
        catch (Throwable e) {
            LOGGER.error(LOADING, "Failed to register automatic subscribers. ModID: {}, class {}", (Object)this.getModId(), (Object)this.modClass.getName(), (Object)e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", e, new Object[]{this.modClass});
        }
    }

    public boolean matches(Object mod) {
        return mod == this.modInstance;
    }

    public Object getMod() {
        return this.modInstance;
    }

    public BusGroup getModBusGroup() {
        return this.eventBusGroup;
    }

    protected <T extends IModBusEvent> void acceptEvent(T e) {
        try {
            LOGGER.trace(LOADING, "Firing event for modid {} : {}", (Object)this.getModId(), e);
            EventBus eventBus = IModBusEvent.getBus((BusGroup)this.eventBusGroup, (Class)e.getClass());
            eventBus.post(e);
            LOGGER.trace(LOADING, "Fired event for modid {} : {}", (Object)this.getModId(), e);
        }
        catch (Throwable t) {
            LOGGER.error(LOADING, "Caught exception during event {} dispatch for modid {}", e, (Object)this.getModId(), (Object)t);
            throw new ModLoadingException(this.modInfo, this.modLoadingStage, "fml.modloading.errorduringevent", t, new Object[0]);
        }
    }

    public void dispatchConfigEvent(IConfigEvent event) {
        EventBus eventBus = EventBus.create((BusGroup)this.eventBusGroup, event.self().getClass());
        eventBus.post((Event)event.self());
    }

    public String toString() {
        return "FMLModContainer[" + this.getModInfo().getModId() + ", " + ((Object)((Object)this)).getClass().getName() + "]";
    }
}

