/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@FunctionalInterface
@OnlyIn(value=Dist.CLIENT)
public interface SpriteResourceLoader {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static SpriteResourceLoader create(Collection<MetadataSectionType<?>> p_299052_) {
        return (p_374679_, p_374680_) -> {
            SpriteContents contents;
            FrameSize framesize;
            NativeImage nativeimage;
            ResourceMetadata resourcemetadata;
            try {
                resourcemetadata = p_374680_.metadata().copySections(p_299052_);
            }
            catch (Exception exception) {
                LOGGER.error("Unable to parse metadata from {}", (Object)p_374679_, (Object)exception);
                return null;
            }
            try (InputStream inputstream = p_374680_.open();){
                nativeimage = NativeImage.read((InputStream)inputstream);
            }
            catch (IOException ioexception) {
                LOGGER.error("Using missing texture, unable to load {}", (Object)p_374679_, (Object)ioexception);
                return null;
            }
            Optional optional = resourcemetadata.getSection(AnimationMetadataSection.TYPE);
            if (optional.isPresent()) {
                framesize = ((AnimationMetadataSection)optional.get()).calculateFrameSize(nativeimage.getWidth(), nativeimage.getHeight());
                if (!Mth.isMultipleOf(nativeimage.getWidth(), framesize.width()) || !Mth.isMultipleOf(nativeimage.getHeight(), framesize.height())) {
                    LOGGER.error("Image {} size {},{} is not multiple of frame size {},{}", new Object[]{p_374679_, nativeimage.getWidth(), nativeimage.getHeight(), framesize.width(), framesize.height()});
                    nativeimage.close();
                    return null;
                }
            } else {
                framesize = new FrameSize(nativeimage.getWidth(), nativeimage.getHeight());
            }
            if ((contents = ForgeHooksClient.loadSpriteContents((ResourceLocation)p_374679_, (Resource)p_374680_, (FrameSize)framesize, (NativeImage)nativeimage, (ResourceMetadata)resourcemetadata)) != null) {
                return contents;
            }
            return new SpriteContents(p_374679_, framesize, nativeimage, resourcemetadata);
        };
    }

    @Nullable
    public SpriteContents loadSprite(ResourceLocation var1, Resource var2);
}

