/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeSupplier {
    private final Map<Holder<Attribute>, AttributeInstance> instances;

    AttributeSupplier(Map<Holder<Attribute>, AttributeInstance> p_22243_) {
        this.instances = p_22243_;
    }

    private AttributeInstance getAttributeInstance(Holder<Attribute> p_335900_) {
        AttributeInstance attributeinstance = this.instances.get(p_335900_);
        if (attributeinstance == null) {
            throw new IllegalArgumentException("Can't find attribute " + p_335900_.getRegisteredName());
        }
        return attributeinstance;
    }

    public double getValue(Holder<Attribute> p_333974_) {
        return this.getAttributeInstance(p_333974_).getValue();
    }

    public double getBaseValue(Holder<Attribute> p_333849_) {
        return this.getAttributeInstance(p_333849_).getBaseValue();
    }

    public double getModifierValue(Holder<Attribute> p_333807_, ResourceLocation p_344356_) {
        AttributeModifier attributemodifier = this.getAttributeInstance(p_333807_).getModifier(p_344356_);
        if (attributemodifier == null) {
            throw new IllegalArgumentException("Can't find modifier " + String.valueOf(p_344356_) + " on attribute " + p_333807_.getRegisteredName());
        }
        return attributemodifier.amount();
    }

    @Nullable
    public AttributeInstance createInstance(Consumer<AttributeInstance> p_22251_, Holder<Attribute> p_333997_) {
        AttributeInstance attributeinstance = this.instances.get(p_333997_);
        if (attributeinstance == null) {
            return null;
        }
        AttributeInstance attributeinstance1 = new AttributeInstance(p_333997_, p_22251_);
        attributeinstance1.replaceFrom(attributeinstance);
        return attributeinstance1;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasAttribute(Holder<Attribute> p_331710_) {
        return this.instances.containsKey(p_331710_);
    }

    public boolean hasModifier(Holder<Attribute> p_335566_, ResourceLocation p_343659_) {
        AttributeInstance attributeinstance = this.instances.get(p_335566_);
        return attributeinstance != null && attributeinstance.getModifier(p_343659_) != null;
    }

    public static class Builder {
        private final Map<Holder<Attribute>, AttributeInstance> builder = new HashMap<Holder<Attribute>, AttributeInstance>();
        private boolean instanceFrozen;
        private final List<Builder> others = new ArrayList<Builder>();

        public Builder() {
        }

        public Builder(AttributeSupplier attributeMap) {
            this.builder.putAll(attributeMap.instances);
        }

        public void combine(Builder other) {
            this.builder.putAll(other.builder);
            this.others.add(other);
        }

        public boolean hasAttribute(Holder<Attribute> attribute) {
            return this.builder.containsKey(attribute);
        }

        private AttributeInstance create(Holder<Attribute> p_334904_) {
            AttributeInstance attributeinstance = new AttributeInstance(p_334904_, p_326800_ -> {
                if (this.instanceFrozen) {
                    throw new UnsupportedOperationException("Tried to change value for default attribute instance: " + p_334904_.getRegisteredName());
                }
            });
            this.builder.put(p_334904_, attributeinstance);
            return attributeinstance;
        }

        public Builder add(Holder<Attribute> p_334664_) {
            this.create(p_334664_);
            return this;
        }

        public Builder add(Holder<Attribute> p_329131_, double p_22270_) {
            AttributeInstance attributeinstance = this.create(p_329131_);
            attributeinstance.setBaseValue(p_22270_);
            return this;
        }

        public AttributeSupplier build() {
            this.instanceFrozen = true;
            this.others.forEach(b -> {
                b.instanceFrozen = true;
            });
            return new AttributeSupplier((Map<Holder<Attribute>, AttributeInstance>)ImmutableMap.copyOf(this.builder));
        }
    }
}

