/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.Connection;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract sealed class ClientPlayerNetworkEvent
extends MutableEvent
implements InheritableEvent {
    public static final EventBus<ClientPlayerNetworkEvent> BUS = EventBus.create(ClientPlayerNetworkEvent.class);
    private final MultiPlayerGameMode multiPlayerGameMode;
    private final LocalPlayer player;
    private final Connection connection;

    @ApiStatus.Internal
    protected ClientPlayerNetworkEvent(MultiPlayerGameMode multiPlayerGameMode, LocalPlayer player, Connection connection) {
        this.multiPlayerGameMode = multiPlayerGameMode;
        this.player = player;
        this.connection = connection;
    }

    public MultiPlayerGameMode getMultiPlayerGameMode() {
        return this.multiPlayerGameMode;
    }

    public LocalPlayer getPlayer() {
        return this.player;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public static final class Clone
    extends ClientPlayerNetworkEvent {
        public static final EventBus<Clone> BUS = EventBus.create(Clone.class);
        private final LocalPlayer oldPlayer;

        @ApiStatus.Internal
        public Clone(MultiPlayerGameMode pc, LocalPlayer oldPlayer, LocalPlayer newPlayer, Connection networkManager) {
            super(pc, newPlayer, networkManager);
            this.oldPlayer = oldPlayer;
        }

        public LocalPlayer getOldPlayer() {
            return this.oldPlayer;
        }

        public LocalPlayer getNewPlayer() {
            return super.getPlayer();
        }

        @Override
        public LocalPlayer getPlayer() {
            return super.getPlayer();
        }
    }

    public static final class LoggingOut
    extends ClientPlayerNetworkEvent {
        public static final EventBus<LoggingOut> BUS = EventBus.create(LoggingOut.class);

        @ApiStatus.Internal
        public LoggingOut(@Nullable MultiPlayerGameMode controller, @Nullable LocalPlayer player, @Nullable Connection networkManager) {
            super(controller, player, networkManager);
        }

        @Override
        @Nullable
        public MultiPlayerGameMode getMultiPlayerGameMode() {
            return super.getMultiPlayerGameMode();
        }

        @Override
        @Nullable
        public LocalPlayer getPlayer() {
            return super.getPlayer();
        }

        @Override
        @Nullable
        public Connection getConnection() {
            return super.getConnection();
        }
    }

    public static final class LoggingIn
    extends ClientPlayerNetworkEvent {
        public static final EventBus<LoggingIn> BUS = EventBus.create(LoggingIn.class);

        @ApiStatus.Internal
        public LoggingIn(MultiPlayerGameMode controller, LocalPlayer player, Connection networkManager) {
            super(controller, player, networkManager);
        }
    }
}

