/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;

public final class RegisterNamedRenderTypesEvent
implements IModBusEvent {
    private final Map<ResourceLocation, RenderTypeGroup> renderTypes;

    public static EventBus<RegisterNamedRenderTypesEvent> getBus(BusGroup modBusGroup) {
        return IModBusEvent.getBus((BusGroup)modBusGroup, RegisterNamedRenderTypesEvent.class);
    }

    @ApiStatus.Internal
    public RegisterNamedRenderTypesEvent(Map<ResourceLocation, RenderTypeGroup> renderTypes) {
        this.renderTypes = renderTypes;
    }

    public void register(String name, ChunkSectionLayer blockRenderType, RenderType entityRenderType) {
        this.register(name, blockRenderType, entityRenderType, entityRenderType);
    }

    public void register(String name, ChunkSectionLayer blockRenderType, RenderType entityRenderType, RenderType fabulousEntityRenderType) {
        ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)ModLoadingContext.get().getActiveNamespace(), (String)name);
        Preconditions.checkArgument((!this.renderTypes.containsKey(key) ? 1 : 0) != 0, (Object)("Render type already registered: " + String.valueOf(key)));
        Preconditions.checkArgument((entityRenderType.format() == DefaultVertexFormat.NEW_ENTITY ? 1 : 0) != 0, (Object)"The entity render type must use the NEW_ENTITY vertex format.");
        Preconditions.checkArgument((fabulousEntityRenderType.format() == DefaultVertexFormat.NEW_ENTITY ? 1 : 0) != 0, (Object)"The fabulous entity render type must use the NEW_ENTITY vertex format.");
        this.renderTypes.put(key, new RenderTypeGroup(blockRenderType, entityRenderType, fabulousEntityRenderType));
    }
}

