/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.textures.ITextureAtlasSpriteLoader;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.characteristic.SelfDestructing;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;

public final class RegisterTextureAtlasSpriteLoadersEvent
implements SelfDestructing,
IModBusEvent {
    private final BiMap<ResourceLocation, ITextureAtlasSpriteLoader> loaders;

    public static EventBus<RegisterTextureAtlasSpriteLoadersEvent> getBus(BusGroup modBusGroup) {
        return IModBusEvent.getBus((BusGroup)modBusGroup, RegisterTextureAtlasSpriteLoadersEvent.class);
    }

    @ApiStatus.Internal
    public RegisterTextureAtlasSpriteLoadersEvent(BiMap<ResourceLocation, ITextureAtlasSpriteLoader> loaders) {
        this.loaders = loaders;
    }

    public void register(String name, ITextureAtlasSpriteLoader loader) {
        ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)ModLoadingContext.get().getActiveNamespace(), (String)name);
        Preconditions.checkArgument((!this.loaders.containsKey((Object)key) ? 1 : 0) != 0, (Object)("Sprite loader already registered: " + String.valueOf(key)));
        Preconditions.checkArgument((!this.loaders.containsValue((Object)loader) ? 1 : 0) != 0, (Object)("Sprite loader already registered as " + String.valueOf(this.loaders.inverse().get((Object)loader))));
        this.loaders.put((Object)key, (Object)loader);
    }
}

