/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;

public class DungeonHooks {
    private static WeightedList<EntityType<?>> dungeonMobs = WeightedList.builder().add((Object)EntityType.SKELETON, 100).add((Object)EntityType.ZOMBIE, 200).add((Object)EntityType.SPIDER, 100).build();

    public static float addDungeonMob(EntityType<?> type, int rarity) {
        if (rarity <= 0) {
            throw new IllegalArgumentException("Rarity must be greater then zero");
        }
        ArrayList list = new ArrayList(dungeonMobs.unwrap());
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            Weighted mob = (Weighted)itr.next();
            if (type != mob.value()) continue;
            itr.remove();
            rarity = mob.weight() + rarity;
            break;
        }
        dungeonMobs = WeightedList.builder().addAll(list).add(type, rarity).build();
        return rarity;
    }

    public static int removeDungeonMob(EntityType<?> name) {
        ArrayList list = new ArrayList(dungeonMobs.unwrap());
        for (Weighted mob : list) {
            if (mob.value() != name) continue;
            list.remove(mob);
            dungeonMobs = WeightedList.builder().addAll(list).build();
            return mob.weight();
        }
        return 0;
    }

    public static EntityType<?> getRandomDungeonMob(RandomSource rand) {
        return (EntityType)dungeonMobs.getRandomOrThrow(rand);
    }
}

