/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.lang.invoke.MethodHandles;
import net.minecraft.server.TickTask;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.common.loot.LootModifierManager;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.network.ConnectionStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.filters.NetworkFilters;
import net.minecraftforge.server.command.ConfigCommand;
import net.minecraftforge.server.command.ForgeCommand;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ForgeInternalHandler {
    private static LootModifierManager INSTANCE;

    static void register() {
        BusGroup.DEFAULT.register(MethodHandles.lookup(), ForgeInternalHandler.class);
    }

    @SubscribeEvent(priority=64)
    static boolean onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity newEntity;
        ItemStack stack;
        Item item;
        Entity entity = event.getEntity();
        if (entity.getClass() == ItemEntity.class && (item = (stack = ((ItemEntity)entity).getItem()).getItem()).hasCustomEntity(stack) && (newEntity = item.createEntity(event.getLevel(), entity, stack)) != null) {
            entity.discard();
            BlockableEventLoop<? super TickTask> executor = LogicalSidedProvider.WORKQUEUE.get(event.getLevel().isClientSide ? LogicalSide.CLIENT : LogicalSide.SERVER);
            executor.schedule((Runnable)new TickTask(0, () -> event.getLevel().addFreshEntity(newEntity)));
            return true;
        }
        return false;
    }

    @SubscribeEvent
    static void onChunkUnload(ChunkEvent.Unload event) {
        if (!event.getLevel().isClientSide()) {
            FarmlandWaterManager.removeTickets(event.getChunk());
        }
    }

    @SubscribeEvent
    static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        UsernameCache.setUsername(event.getEntity().getUUID(), event.getEntity().getGameProfile().getName());
    }

    @SubscribeEvent
    static void onCommandsRegister(RegisterCommandsEvent event) {
        new ForgeCommand(event.getDispatcher());
        ConfigCommand.register(event.getDispatcher());
    }

    @SubscribeEvent
    static void onResourceReload(AddReloadListenerEvent event) {
        INSTANCE = new LootModifierManager(event.getRegistries());
        event.addListener((PreparableReloadListener)INSTANCE);
    }

    static LootModifierManager getLootModifierManager() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Can not retrieve LootModifierManager until resources have loaded once.");
        }
        return INSTANCE;
    }

    @SubscribeEvent
    static void resourceReloadListeners(AddReloadListenerEvent event) {
        event.addListener(CreativeModeTabRegistry.getReloadListener());
    }

    @SubscribeEvent(priority=127)
    static boolean builtinMobSpawnBlocker(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity = event.getEntity();
        return entity instanceof Mob && (mob = (Mob)entity).isSpawnCancelled();
    }

    @SubscribeEvent
    static void onConnectionStart(ConnectionStartEvent event) {
        NetworkFilters.injectIfNecessary(event.getConnection());
    }

    @SubscribeEvent
    static void serverStopping(ServerStoppingEvent evt) {
        WorldWorkerManager.clear();
    }

    @SubscribeEvent
    static void registerPermissionNodes(PermissionGatherEvent.Nodes event) {
        event.addNodes(ForgeMod.USE_SELECTORS_PERMISSION);
    }
}

