/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootModifierManager
extends SimpleJsonResourceReloadListener<JsonElement> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String FOLDER = "loot_modifiers";
    private final HolderLookup.Provider registries;
    private Map<ResourceLocation, IGlobalLootModifier> modifiers = ImmutableMap.of();

    public LootModifierManager(HolderLookup.Provider registries) {
        super((DynamicOps)registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE), ExtraCodecs.JSON, FileToIdConverter.json((String)FOLDER));
        this.registries = registries;
    }

    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resources, ProfilerFiller profilerFiller) {
        ResourceLocation path = ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"loot_modifiers/global_loot_modifiers.json");
        ArrayList<ResourceLocation> toLoad = new ArrayList<ResourceLocation>();
        for (Resource resource : resources.getResourceStack(path)) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonObject json = (JsonObject)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (GsonHelper.getAsBoolean((JsonObject)json, (String)"replace", (boolean)false)) {
                        toLoad.clear();
                    }
                    for (JsonElement entry : GsonHelper.getAsJsonArray((JsonObject)json, (String)"entries")) {
                        ResourceLocation loc = ResourceLocation.parse((String)entry.getAsString());
                        toLoad.remove(loc);
                        toLoad.add(loc);
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException | RuntimeException ioexception) {
                LOGGER.error("Couldn't read global loot modifier list {} in data pack {}", (Object)path, (Object)resource.sourcePackId(), (Object)ioexception);
            }
        }
        Map ret = super.prepare(resources, profilerFiller);
        ret.keySet().removeIf(k -> !toLoad.contains(k));
        return ret;
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        RegistryOps ops = this.registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        resources.forEach((location, json) -> IGlobalLootModifier.DIRECT_CODEC.parse((DynamicOps)ops, json).ifError(error -> LOGGER.warn("Could not decode GlobalLootModifier with json id {} - error: {}", location, (Object)error.message())).ifSuccess(modifier -> builder.put(location, modifier)));
        this.modifiers = builder.build();
    }

    public Collection<IGlobalLootModifier> getAllLootMods() {
        return this.modifiers.values();
    }
}

