/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.fml.ModLoader;

public final class AddReloadListenerEvent
extends MutableEvent {
    public static final EventBus<AddReloadListenerEvent> BUS = EventBus.create(AddReloadListenerEvent.class);
    private final List<PreparableReloadListener> listeners = new ArrayList<PreparableReloadListener>();
    private final ReloadableServerResources serverResources;
    private final HolderLookup.Provider registries;
    @Deprecated(forRemoval=true, since="1.21.4")
    private final RegistryAccess registryAccess;

    @Deprecated(forRemoval=true, since="1.21.4")
    public AddReloadListenerEvent(ReloadableServerResources serverResources, RegistryAccess registryAccess) {
        this(serverResources, (HolderLookup.Provider)registryAccess, registryAccess);
    }

    public AddReloadListenerEvent(ReloadableServerResources serverResources, HolderLookup.Provider registries, @Deprecated(forRemoval=true, since="1.21.4") RegistryAccess registryAccess) {
        this.serverResources = serverResources;
        this.registries = registries;
        this.registryAccess = registryAccess;
    }

    public void addListener(PreparableReloadListener listener) {
        this.listeners.add(new WrappedStateAwareListener(listener));
    }

    public List<PreparableReloadListener> getListeners() {
        return ImmutableList.copyOf(this.listeners);
    }

    public ReloadableServerResources getServerResources() {
        return this.serverResources;
    }

    public ICondition.IContext getConditionContext() {
        return this.serverResources.getConditionContext();
    }

    public HolderLookup.Provider getRegistries() {
        return this.registries;
    }

    @Deprecated(forRemoval=true, since="1.21.4")
    public RegistryAccess getRegistryAccess() {
        return this.registryAccess;
    }

    private record WrappedStateAwareListener(PreparableReloadListener wrapped) implements PreparableReloadListener
    {
        public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
            if (ModLoader.isLoadingStateValid()) {
                return this.wrapped.reload(stage, resourceManager, backgroundExecutor, gameExecutor);
            }
            return CompletableFuture.completedFuture(null);
        }

        public String getName() {
            return this.wrapped.getName();
        }
    }
}

