/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity;

import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.MutableEvent;

public class EntityEvent
extends MutableEvent
implements InheritableEvent {
    public static final EventBus<EntityEvent> BUS = EventBus.create(EntityEvent.class);
    private final Entity entity;

    public EntityEvent(Entity entity) {
        this.entity = entity;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public static final class EnteringSection
    extends EntityEvent {
        public static final EventBus<EnteringSection> BUS = EventBus.create(EnteringSection.class);
        private final long packedOldPos;
        private final long packedNewPos;

        public EnteringSection(Entity entity, long packedOldPos, long packedNewPos) {
            super(entity);
            this.packedOldPos = packedOldPos;
            this.packedNewPos = packedNewPos;
        }

        public long getPackedOldPos() {
            return this.packedOldPos;
        }

        public long getPackedNewPos() {
            return this.packedNewPos;
        }

        public SectionPos getOldPos() {
            return SectionPos.of((long)this.packedOldPos);
        }

        public SectionPos getNewPos() {
            return SectionPos.of((long)this.packedNewPos);
        }

        public boolean didChunkChange() {
            return SectionPos.x((long)this.packedOldPos) != SectionPos.x((long)this.packedNewPos) || SectionPos.z((long)this.packedOldPos) != SectionPos.z((long)this.packedNewPos);
        }
    }

    public static final class EntityConstructing
    extends EntityEvent {
        public static final EventBus<EntityConstructing> BUS = EventBus.create(EntityConstructing.class);

        public EntityConstructing(Entity entity) {
            super(entity);
        }
    }
}

