/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.Nullable;

public class LivingEvent
extends EntityEvent {
    public static final EventBus<LivingEvent> BUS = EventBus.create(LivingEvent.class);
    private final LivingEntity livingEntity;

    public LivingEvent(LivingEntity entity) {
        super((Entity)entity);
        this.livingEntity = entity;
    }

    public LivingEntity getEntity() {
        return this.livingEntity;
    }

    public static final class LivingVisibilityEvent
    extends LivingEvent {
        public static final EventBus<LivingVisibilityEvent> BUS = EventBus.create(LivingVisibilityEvent.class);
        private double visibilityModifier;
        @Nullable
        private final Entity lookingEntity;

        public LivingVisibilityEvent(LivingEntity livingEntity, @Nullable Entity lookingEntity, double originalMultiplier) {
            super(livingEntity);
            this.visibilityModifier = originalMultiplier;
            this.lookingEntity = lookingEntity;
        }

        public void modifyVisibility(double mod) {
            this.visibilityModifier *= mod;
        }

        public double getVisibilityModifier() {
            return this.visibilityModifier;
        }

        @Nullable
        public Entity getLookingEntity() {
            return this.lookingEntity;
        }
    }

    public static final class LivingJumpEvent
    extends LivingEvent {
        public static final EventBus<LivingJumpEvent> BUS = EventBus.create(LivingJumpEvent.class);

        public LivingJumpEvent(LivingEntity e) {
            super(e);
        }
    }

    public static final class LivingTickEvent
    extends LivingEvent
    implements Cancellable {
        public static final CancellableEventBus<LivingTickEvent> BUS = CancellableEventBus.create(LivingTickEvent.class);

        public LivingTickEvent(LivingEntity e) {
            super(e);
        }
    }
}

