/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.Nullable;

public final class PlayerSetSpawnEvent
extends PlayerEvent
implements Cancellable {
    public static final CancellableEventBus<PlayerSetSpawnEvent> BUS = CancellableEventBus.create(PlayerSetSpawnEvent.class);
    @Nullable
    private final ServerPlayer.RespawnConfig config;
    @Deprecated(forRemoval=true, since="1.21.5")
    private final ResourceKey<Level> spawnLevel;
    @Deprecated(forRemoval=true, since="1.21.5")
    private final boolean forced;
    @Deprecated(forRemoval=true, since="1.21.5")
    @Nullable
    private final BlockPos newSpawn;

    public PlayerSetSpawnEvent(ServerPlayer player, @Nullable ServerPlayer.RespawnConfig config) {
        super((Player)player);
        this.config = config;
        boolean hasConfig = config != null;
        this.forced = hasConfig && config.forced();
        this.spawnLevel = hasConfig ? config.dimension() : Level.OVERWORLD;
        this.newSpawn = hasConfig ? config.pos() : null;
    }

    @Nullable
    public ServerPlayer.RespawnConfig getConfig() {
        return this.config;
    }

    @Deprecated(forRemoval=true, since="1.21.5")
    public boolean isForced() {
        return this.forced;
    }

    @Deprecated(forRemoval=true, since="1.21.5")
    @Nullable
    public BlockPos getNewSpawn() {
        return this.newSpawn;
    }

    @Deprecated(forRemoval=true, since="1.21.5")
    public ResourceKey<Level> getSpawnLevel() {
        return this.spawnLevel;
    }
}

