// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// VulnerabilityType The vulnerability type.
type VulnerabilityType string

// List of VulnerabilityType.
const (
	VULNERABILITYTYPE_ADMIN_CONSOLE_ACTIVE               VulnerabilityType = "AdminConsoleActive"
	VULNERABILITYTYPE_CODE_INJECTION                     VulnerabilityType = "CodeInjection"
	VULNERABILITYTYPE_COMMAND_INJECTION                  VulnerabilityType = "CommandInjection"
	VULNERABILITYTYPE_COMPONENT_WITH_KNOWN_VULNERABILITY VulnerabilityType = "ComponentWithKnownVulnerability"
	VULNERABILITYTYPE_DANGEROUS_WORKFLOWS                VulnerabilityType = "DangerousWorkflows"
	VULNERABILITYTYPE_DEFAULT_APP_DEPLOYED               VulnerabilityType = "DefaultAppDeployed"
	VULNERABILITYTYPE_DEFAULT_HTML_ESCAPE_INVALID        VulnerabilityType = "DefaultHtmlEscapeInvalid"
	VULNERABILITYTYPE_DIRECTORY_LISTING_LEAK             VulnerabilityType = "DirectoryListingLeak"
	VULNERABILITYTYPE_EMAIL_HTML_INJECTION               VulnerabilityType = "EmailHtmlInjection"
	VULNERABILITYTYPE_END_OF_LIFE                        VulnerabilityType = "EndOfLife"
	VULNERABILITYTYPE_HARDCODED_PASSWORD                 VulnerabilityType = "HardcodedPassword"
	VULNERABILITYTYPE_HARDCODED_SECRET                   VulnerabilityType = "HardcodedSecret"
	VULNERABILITYTYPE_HEADER_INJECTION                   VulnerabilityType = "HeaderInjection"
	VULNERABILITYTYPE_HSTS_HEADER_MISSING                VulnerabilityType = "HstsHeaderMissing"
	VULNERABILITYTYPE_INSECURE_AUTH_PROTOCOL             VulnerabilityType = "InsecureAuthProtocol"
	VULNERABILITYTYPE_INSECURE_COOKIE                    VulnerabilityType = "InsecureCookie"
	VULNERABILITYTYPE_INSECURE_JSP_LAYOUT                VulnerabilityType = "InsecureJspLayout"
	VULNERABILITYTYPE_LDAP_INJECTION                     VulnerabilityType = "LdapInjection"
	VULNERABILITYTYPE_MALICIOUS_PACKAGE                  VulnerabilityType = "MaliciousPackage"
	VULNERABILITYTYPE_MANDATORY_REMEDIATION              VulnerabilityType = "MandatoryRemediation"
	VULNERABILITYTYPE_NO_HTTP_ONLY_COOKIE                VulnerabilityType = "NoHttpOnlyCookie"
	VULNERABILITYTYPE_NO_SAME_SITE_COOKIE                VulnerabilityType = "NoSameSiteCookie"
	VULNERABILITYTYPE_NO_SQL_MONGO_DB_INJECTION          VulnerabilityType = "NoSqlMongoDbInjection"
	VULNERABILITYTYPE_PATH_TRAVERSAL                     VulnerabilityType = "PathTraversal"
	VULNERABILITYTYPE_REFLECTION_INJECTION               VulnerabilityType = "ReflectionInjection"
	VULNERABILITYTYPE_RISKY_LICENSE                      VulnerabilityType = "RiskyLicense"
	VULNERABILITYTYPE_SESSION_REWRITING                  VulnerabilityType = "SessionRewriting"
	VULNERABILITYTYPE_SESSION_TIMEOUT                    VulnerabilityType = "SessionTimeout"
	VULNERABILITYTYPE_SQL_INJECTION                      VulnerabilityType = "SqlInjection"
	VULNERABILITYTYPE_SSRF                               VulnerabilityType = "Ssrf"
	VULNERABILITYTYPE_STACK_TRACE_LEAK                   VulnerabilityType = "StackTraceLeak"
	VULNERABILITYTYPE_TRUST_BOUNDARY_VIOLATION           VulnerabilityType = "TrustBoundaryViolation"
	VULNERABILITYTYPE_UNMAINTAINED                       VulnerabilityType = "Unmaintained"
	VULNERABILITYTYPE_UNTRUSTED_DESERIALIZATION          VulnerabilityType = "UntrustedDeserialization"
	VULNERABILITYTYPE_UNVALIDATED_REDIRECT               VulnerabilityType = "UnvalidatedRedirect"
	VULNERABILITYTYPE_VERB_TAMPERING                     VulnerabilityType = "VerbTampering"
	VULNERABILITYTYPE_WEAK_CIPHER                        VulnerabilityType = "WeakCipher"
	VULNERABILITYTYPE_WEAK_HASH                          VulnerabilityType = "WeakHash"
	VULNERABILITYTYPE_WEAK_RANDOMNESS                    VulnerabilityType = "WeakRandomness"
	VULNERABILITYTYPE_X_CONTENT_TYPE_HEADER_MISSING      VulnerabilityType = "XContentTypeHeaderMissing"
	VULNERABILITYTYPE_X_PATH_INJECTION                   VulnerabilityType = "XPathInjection"
	VULNERABILITYTYPE_XSS                                VulnerabilityType = "Xss"
)

var allowedVulnerabilityTypeEnumValues = []VulnerabilityType{
	VULNERABILITYTYPE_ADMIN_CONSOLE_ACTIVE,
	VULNERABILITYTYPE_CODE_INJECTION,
	VULNERABILITYTYPE_COMMAND_INJECTION,
	VULNERABILITYTYPE_COMPONENT_WITH_KNOWN_VULNERABILITY,
	VULNERABILITYTYPE_DANGEROUS_WORKFLOWS,
	VULNERABILITYTYPE_DEFAULT_APP_DEPLOYED,
	VULNERABILITYTYPE_DEFAULT_HTML_ESCAPE_INVALID,
	VULNERABILITYTYPE_DIRECTORY_LISTING_LEAK,
	VULNERABILITYTYPE_EMAIL_HTML_INJECTION,
	VULNERABILITYTYPE_END_OF_LIFE,
	VULNERABILITYTYPE_HARDCODED_PASSWORD,
	VULNERABILITYTYPE_HARDCODED_SECRET,
	VULNERABILITYTYPE_HEADER_INJECTION,
	VULNERABILITYTYPE_HSTS_HEADER_MISSING,
	VULNERABILITYTYPE_INSECURE_AUTH_PROTOCOL,
	VULNERABILITYTYPE_INSECURE_COOKIE,
	VULNERABILITYTYPE_INSECURE_JSP_LAYOUT,
	VULNERABILITYTYPE_LDAP_INJECTION,
	VULNERABILITYTYPE_MALICIOUS_PACKAGE,
	VULNERABILITYTYPE_MANDATORY_REMEDIATION,
	VULNERABILITYTYPE_NO_HTTP_ONLY_COOKIE,
	VULNERABILITYTYPE_NO_SAME_SITE_COOKIE,
	VULNERABILITYTYPE_NO_SQL_MONGO_DB_INJECTION,
	VULNERABILITYTYPE_PATH_TRAVERSAL,
	VULNERABILITYTYPE_REFLECTION_INJECTION,
	VULNERABILITYTYPE_RISKY_LICENSE,
	VULNERABILITYTYPE_SESSION_REWRITING,
	VULNERABILITYTYPE_SESSION_TIMEOUT,
	VULNERABILITYTYPE_SQL_INJECTION,
	VULNERABILITYTYPE_SSRF,
	VULNERABILITYTYPE_STACK_TRACE_LEAK,
	VULNERABILITYTYPE_TRUST_BOUNDARY_VIOLATION,
	VULNERABILITYTYPE_UNMAINTAINED,
	VULNERABILITYTYPE_UNTRUSTED_DESERIALIZATION,
	VULNERABILITYTYPE_UNVALIDATED_REDIRECT,
	VULNERABILITYTYPE_VERB_TAMPERING,
	VULNERABILITYTYPE_WEAK_CIPHER,
	VULNERABILITYTYPE_WEAK_HASH,
	VULNERABILITYTYPE_WEAK_RANDOMNESS,
	VULNERABILITYTYPE_X_CONTENT_TYPE_HEADER_MISSING,
	VULNERABILITYTYPE_X_PATH_INJECTION,
	VULNERABILITYTYPE_XSS,
}

// GetAllowedValues reeturns the list of possible values.
func (v *VulnerabilityType) GetAllowedValues() []VulnerabilityType {
	return allowedVulnerabilityTypeEnumValues
}

// UnmarshalJSON deserializes the given payload.
func (v *VulnerabilityType) UnmarshalJSON(src []byte) error {
	var value string
	err := datadog.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	*v = VulnerabilityType(value)
	return nil
}

// NewVulnerabilityTypeFromValue returns a pointer to a valid VulnerabilityType
// for the value passed as argument, or an error if the value passed is not allowed by the enum.
func NewVulnerabilityTypeFromValue(v string) (*VulnerabilityType, error) {
	ev := VulnerabilityType(v)
	if ev.IsValid() {
		return &ev, nil
	}
	return nil, fmt.Errorf("invalid value '%v' for VulnerabilityType: valid values are %v", v, allowedVulnerabilityTypeEnumValues)
}

// IsValid return true if the value is valid for the enum, false otherwise.
func (v VulnerabilityType) IsValid() bool {
	for _, existing := range allowedVulnerabilityTypeEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to VulnerabilityType value.
func (v VulnerabilityType) Ptr() *VulnerabilityType {
	return &v
}
