// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package entity

import (
	"iter"
	"sort"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
)

// EntityRefSlice logically represents a slice of EntityRef.
//
// This is a reference type. If passed by value and callee modifies it, the
// caller will see the modification.
//
// Must use NewEntityRefSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type EntityRefSlice internal.EntityRefSlice

func newEntityRefSlice(orig *[]*otlpcommon.EntityRef, state *internal.State) EntityRefSlice {
	return EntityRefSlice(internal.NewEntityRefSlice(orig, state))
}

// NewEntityRefSlice creates a EntityRefSlice with 0 elements.
// Can use "EnsureCapacity" to initialize with a given capacity.
func NewEntityRefSlice() EntityRefSlice {
	orig := []*otlpcommon.EntityRef(nil)
	return newEntityRefSlice(&orig, internal.NewState())
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewEntityRefSlice()".
func (es EntityRefSlice) Len() int {
	return len(*es.getOrig())
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
//
//	for i := 0; i < es.Len(); i++ {
//	    e := es.At(i)
//	    ... // Do something with the element
//	}
func (es EntityRefSlice) At(i int) EntityRef {
	return newEntityRef((*es.getOrig())[i], es.getState())
}

// All returns an iterator over index-value pairs in the slice.
//
//	for i, v := range es.All() {
//	    ... // Do something with index-value pair
//	}
func (es EntityRefSlice) All() iter.Seq2[int, EntityRef] {
	return func(yield func(int, EntityRef) bool) {
		for i := 0; i < es.Len(); i++ {
			if !yield(i, es.At(i)) {
				return
			}
		}
	}
}

// EnsureCapacity is an operation that ensures the slice has at least the specified capacity.
// 1. If the newCap <= cap then no change in capacity.
// 2. If the newCap > cap then the slice capacity will be expanded to equal newCap.
//
// Here is how a new EntityRefSlice can be initialized:
//
//	es := NewEntityRefSlice()
//	es.EnsureCapacity(4)
//	for i := 0; i < 4; i++ {
//	    e := es.AppendEmpty()
//	    // Here should set all the values for e.
//	}
func (es EntityRefSlice) EnsureCapacity(newCap int) {
	es.getState().AssertMutable()
	oldCap := cap(*es.getOrig())
	if newCap <= oldCap {
		return
	}

	newOrig := make([]*otlpcommon.EntityRef, len(*es.getOrig()), newCap)
	copy(newOrig, *es.getOrig())
	*es.getOrig() = newOrig
}

// AppendEmpty will append to the end of the slice an empty EntityRef.
// It returns the newly added EntityRef.
func (es EntityRefSlice) AppendEmpty() EntityRef {
	es.getState().AssertMutable()
	*es.getOrig() = append(*es.getOrig(), internal.NewOrigEntityRef())
	return es.At(es.Len() - 1)
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es EntityRefSlice) MoveAndAppendTo(dest EntityRefSlice) {
	es.getState().AssertMutable()
	dest.getState().AssertMutable()
	// If they point to the same data, they are the same, nothing to do.
	if es.getOrig() == dest.getOrig() {
		return
	}
	if *dest.getOrig() == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.getOrig() = *es.getOrig()
	} else {
		*dest.getOrig() = append(*dest.getOrig(), *es.getOrig()...)
	}
	*es.getOrig() = nil
}

// RemoveIf calls f sequentially for each element present in the slice.
// If f returns true, the element is removed from the slice.
func (es EntityRefSlice) RemoveIf(f func(EntityRef) bool) {
	es.getState().AssertMutable()
	newLen := 0
	for i := 0; i < len(*es.getOrig()); i++ {
		if f(es.At(i)) {
			internal.DeleteOrigEntityRef((*es.getOrig())[i], true)
			(*es.getOrig())[i] = nil

			continue
		}
		if newLen == i {
			// Nothing to move, element is at the right place.
			newLen++
			continue
		}
		(*es.getOrig())[newLen] = (*es.getOrig())[i]
		// Cannot delete here since we just move the data(or pointer to data) to a different position in the slice.
		(*es.getOrig())[i] = nil
		newLen++
	}
	*es.getOrig() = (*es.getOrig())[:newLen]
}

// CopyTo copies all elements from the current slice overriding the destination.
func (es EntityRefSlice) CopyTo(dest EntityRefSlice) {
	dest.getState().AssertMutable()
	if es.getOrig() == dest.getOrig() {
		return
	}
	*dest.getOrig() = internal.CopyOrigEntityRefSlice(*dest.getOrig(), *es.getOrig())
}

// Sort sorts the EntityRef elements within EntityRefSlice given the
// provided less function so that two instances of EntityRefSlice
// can be compared.
func (es EntityRefSlice) Sort(less func(a, b EntityRef) bool) {
	es.getState().AssertMutable()
	sort.SliceStable(*es.getOrig(), func(i, j int) bool { return less(es.At(i), es.At(j)) })
}

func (ms EntityRefSlice) getOrig() *[]*otlpcommon.EntityRef {
	return internal.GetOrigEntityRefSlice(internal.EntityRefSlice(ms))
}

func (ms EntityRefSlice) getState() *internal.State {
	return internal.GetEntityRefSliceState(internal.EntityRefSlice(ms))
}
