// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolProfilesDictionary = sync.Pool{
		New: func() any {
			return &otlpprofiles.ProfilesDictionary{}
		},
	}
)

func NewOrigProfilesDictionary() *otlpprofiles.ProfilesDictionary {
	if !UseProtoPooling.IsEnabled() {
		return &otlpprofiles.ProfilesDictionary{}
	}
	return protoPoolProfilesDictionary.Get().(*otlpprofiles.ProfilesDictionary)
}

func DeleteOrigProfilesDictionary(orig *otlpprofiles.ProfilesDictionary, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.MappingTable {
		DeleteOrigMapping(orig.MappingTable[i], true)
	}
	for i := range orig.LocationTable {
		DeleteOrigLocation(orig.LocationTable[i], true)
	}
	for i := range orig.FunctionTable {
		DeleteOrigFunction(orig.FunctionTable[i], true)
	}
	for i := range orig.LinkTable {
		DeleteOrigLink(orig.LinkTable[i], true)
	}
	for i := range orig.AttributeTable {
		DeleteOrigKeyValue(&orig.AttributeTable[i], false)
	}
	for i := range orig.AttributeUnits {
		DeleteOrigAttributeUnit(orig.AttributeUnits[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolProfilesDictionary.Put(orig)
	}
}

func CopyOrigProfilesDictionary(dest, src *otlpprofiles.ProfilesDictionary) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.MappingTable = CopyOrigMappingSlice(dest.MappingTable, src.MappingTable)
	dest.LocationTable = CopyOrigLocationSlice(dest.LocationTable, src.LocationTable)
	dest.FunctionTable = CopyOrigFunctionSlice(dest.FunctionTable, src.FunctionTable)
	dest.LinkTable = CopyOrigLinkSlice(dest.LinkTable, src.LinkTable)
	dest.StringTable = CopyOrigStringSlice(dest.StringTable, src.StringTable)
	dest.AttributeTable = CopyOrigKeyValueSlice(dest.AttributeTable, src.AttributeTable)
	dest.AttributeUnits = CopyOrigAttributeUnitSlice(dest.AttributeUnits, src.AttributeUnits)
}

func GenTestOrigProfilesDictionary() *otlpprofiles.ProfilesDictionary {
	orig := NewOrigProfilesDictionary()
	orig.MappingTable = GenerateOrigTestMappingSlice()
	orig.LocationTable = GenerateOrigTestLocationSlice()
	orig.FunctionTable = GenerateOrigTestFunctionSlice()
	orig.LinkTable = GenerateOrigTestLinkSlice()
	orig.StringTable = GenerateOrigTestStringSlice()
	orig.AttributeTable = GenerateOrigTestKeyValueSlice()
	orig.AttributeUnits = GenerateOrigTestAttributeUnitSlice()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigProfilesDictionary(orig *otlpprofiles.ProfilesDictionary, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.MappingTable) > 0 {
		dest.WriteObjectField("mappingTable")
		dest.WriteArrayStart()
		MarshalJSONOrigMapping(orig.MappingTable[0], dest)
		for i := 1; i < len(orig.MappingTable); i++ {
			dest.WriteMore()
			MarshalJSONOrigMapping(orig.MappingTable[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.LocationTable) > 0 {
		dest.WriteObjectField("locationTable")
		dest.WriteArrayStart()
		MarshalJSONOrigLocation(orig.LocationTable[0], dest)
		for i := 1; i < len(orig.LocationTable); i++ {
			dest.WriteMore()
			MarshalJSONOrigLocation(orig.LocationTable[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.FunctionTable) > 0 {
		dest.WriteObjectField("functionTable")
		dest.WriteArrayStart()
		MarshalJSONOrigFunction(orig.FunctionTable[0], dest)
		for i := 1; i < len(orig.FunctionTable); i++ {
			dest.WriteMore()
			MarshalJSONOrigFunction(orig.FunctionTable[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.LinkTable) > 0 {
		dest.WriteObjectField("linkTable")
		dest.WriteArrayStart()
		MarshalJSONOrigLink(orig.LinkTable[0], dest)
		for i := 1; i < len(orig.LinkTable); i++ {
			dest.WriteMore()
			MarshalJSONOrigLink(orig.LinkTable[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.StringTable) > 0 {
		dest.WriteObjectField("stringTable")
		dest.WriteArrayStart()
		dest.WriteString(orig.StringTable[0])
		for i := 1; i < len(orig.StringTable); i++ {
			dest.WriteMore()
			dest.WriteString(orig.StringTable[i])
		}
		dest.WriteArrayEnd()
	}
	if len(orig.AttributeTable) > 0 {
		dest.WriteObjectField("attributeTable")
		dest.WriteArrayStart()
		MarshalJSONOrigKeyValue(&orig.AttributeTable[0], dest)
		for i := 1; i < len(orig.AttributeTable); i++ {
			dest.WriteMore()
			MarshalJSONOrigKeyValue(&orig.AttributeTable[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.AttributeUnits) > 0 {
		dest.WriteObjectField("attributeUnits")
		dest.WriteArrayStart()
		MarshalJSONOrigAttributeUnit(orig.AttributeUnits[0], dest)
		for i := 1; i < len(orig.AttributeUnits); i++ {
			dest.WriteMore()
			MarshalJSONOrigAttributeUnit(orig.AttributeUnits[i], dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigProfilesDictionary unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigProfilesDictionary(orig *otlpprofiles.ProfilesDictionary, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "mappingTable", "mapping_table":
			for iter.ReadArray() {
				orig.MappingTable = append(orig.MappingTable, NewOrigMapping())
				UnmarshalJSONOrigMapping(orig.MappingTable[len(orig.MappingTable)-1], iter)
			}

		case "locationTable", "location_table":
			for iter.ReadArray() {
				orig.LocationTable = append(orig.LocationTable, NewOrigLocation())
				UnmarshalJSONOrigLocation(orig.LocationTable[len(orig.LocationTable)-1], iter)
			}

		case "functionTable", "function_table":
			for iter.ReadArray() {
				orig.FunctionTable = append(orig.FunctionTable, NewOrigFunction())
				UnmarshalJSONOrigFunction(orig.FunctionTable[len(orig.FunctionTable)-1], iter)
			}

		case "linkTable", "link_table":
			for iter.ReadArray() {
				orig.LinkTable = append(orig.LinkTable, NewOrigLink())
				UnmarshalJSONOrigLink(orig.LinkTable[len(orig.LinkTable)-1], iter)
			}

		case "stringTable", "string_table":
			for iter.ReadArray() {
				orig.StringTable = append(orig.StringTable, iter.ReadString())
			}

		case "attributeTable", "attribute_table":
			for iter.ReadArray() {
				orig.AttributeTable = append(orig.AttributeTable, otlpcommon.KeyValue{})
				UnmarshalJSONOrigKeyValue(&orig.AttributeTable[len(orig.AttributeTable)-1], iter)
			}

		case "attributeUnits", "attribute_units":
			for iter.ReadArray() {
				orig.AttributeUnits = append(orig.AttributeUnits, NewOrigAttributeUnit())
				UnmarshalJSONOrigAttributeUnit(orig.AttributeUnits[len(orig.AttributeUnits)-1], iter)
			}

		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigProfilesDictionary(orig *otlpprofiles.ProfilesDictionary) int {
	var n int
	var l int
	_ = l
	for i := range orig.MappingTable {
		l = SizeProtoOrigMapping(orig.MappingTable[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.LocationTable {
		l = SizeProtoOrigLocation(orig.LocationTable[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.FunctionTable {
		l = SizeProtoOrigFunction(orig.FunctionTable[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.LinkTable {
		l = SizeProtoOrigLink(orig.LinkTable[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for _, s := range orig.StringTable {
		l = len(s)
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.AttributeTable {
		l = SizeProtoOrigKeyValue(&orig.AttributeTable[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.AttributeUnits {
		l = SizeProtoOrigAttributeUnit(orig.AttributeUnits[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigProfilesDictionary(orig *otlpprofiles.ProfilesDictionary, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.MappingTable) - 1; i >= 0; i-- {
		l = MarshalProtoOrigMapping(orig.MappingTable[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	for i := len(orig.LocationTable) - 1; i >= 0; i-- {
		l = MarshalProtoOrigLocation(orig.LocationTable[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	for i := len(orig.FunctionTable) - 1; i >= 0; i-- {
		l = MarshalProtoOrigFunction(orig.FunctionTable[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	for i := len(orig.LinkTable) - 1; i >= 0; i-- {
		l = MarshalProtoOrigLink(orig.LinkTable[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x22
	}
	for i := len(orig.StringTable) - 1; i >= 0; i-- {
		l = len(orig.StringTable[i])
		pos -= l
		copy(buf[pos:], orig.StringTable[i])
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x2a
	}
	for i := len(orig.AttributeTable) - 1; i >= 0; i-- {
		l = MarshalProtoOrigKeyValue(&orig.AttributeTable[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x32
	}
	for i := len(orig.AttributeUnits) - 1; i >= 0; i-- {
		l = MarshalProtoOrigAttributeUnit(orig.AttributeUnits[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x3a
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigProfilesDictionary(orig *otlpprofiles.ProfilesDictionary, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field MappingTable", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.MappingTable = append(orig.MappingTable, NewOrigMapping())
			err = UnmarshalProtoOrigMapping(orig.MappingTable[len(orig.MappingTable)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field LocationTable", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.LocationTable = append(orig.LocationTable, NewOrigLocation())
			err = UnmarshalProtoOrigLocation(orig.LocationTable[len(orig.LocationTable)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field FunctionTable", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.FunctionTable = append(orig.FunctionTable, NewOrigFunction())
			err = UnmarshalProtoOrigFunction(orig.FunctionTable[len(orig.FunctionTable)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 4:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field LinkTable", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.LinkTable = append(orig.LinkTable, NewOrigLink())
			err = UnmarshalProtoOrigLink(orig.LinkTable[len(orig.LinkTable)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field StringTable", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.StringTable = append(orig.StringTable, string(buf[startPos:pos]))

		case 6:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeTable", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.AttributeTable = append(orig.AttributeTable, otlpcommon.KeyValue{})
			err = UnmarshalProtoOrigKeyValue(&orig.AttributeTable[len(orig.AttributeTable)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 7:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeUnits", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.AttributeUnits = append(orig.AttributeUnits, NewOrigAttributeUnit())
			err = UnmarshalProtoOrigAttributeUnit(orig.AttributeUnits[len(orig.AttributeUnits)-1], buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
