// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolSample = sync.Pool{
		New: func() any {
			return &otlpprofiles.Sample{}
		},
	}
	ProtoPoolSample_LinkIndex = sync.Pool{
		New: func() any {
			return &otlpprofiles.Sample_LinkIndex{}
		},
	}
)

func NewOrigSample() *otlpprofiles.Sample {
	if !UseProtoPooling.IsEnabled() {
		return &otlpprofiles.Sample{}
	}
	return protoPoolSample.Get().(*otlpprofiles.Sample)
}

func DeleteOrigSample(orig *otlpprofiles.Sample, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	switch ov := orig.LinkIndex_.(type) {
	case *otlpprofiles.Sample_LinkIndex:
		if UseProtoPooling.IsEnabled() {
			ov.LinkIndex = int32(0)
			ProtoPoolSample_LinkIndex.Put(ov)
		}

	}

	orig.Reset()
	if nullable {
		protoPoolSample.Put(orig)
	}
}

func CopyOrigSample(dest, src *otlpprofiles.Sample) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.LocationsStartIndex = src.LocationsStartIndex
	dest.LocationsLength = src.LocationsLength
	dest.Value = CopyOrigInt64Slice(dest.Value, src.Value)
	dest.AttributeIndices = CopyOrigInt32Slice(dest.AttributeIndices, src.AttributeIndices)
	if srcLinkIndex, ok := src.LinkIndex_.(*otlpprofiles.Sample_LinkIndex); ok {
		destLinkIndex, ok := dest.LinkIndex_.(*otlpprofiles.Sample_LinkIndex)
		if !ok {
			destLinkIndex = &otlpprofiles.Sample_LinkIndex{}
			dest.LinkIndex_ = destLinkIndex
		}
		destLinkIndex.LinkIndex = srcLinkIndex.LinkIndex
	} else {
		dest.LinkIndex_ = nil
	}
	dest.TimestampsUnixNano = CopyOrigUint64Slice(dest.TimestampsUnixNano, src.TimestampsUnixNano)
}

func GenTestOrigSample() *otlpprofiles.Sample {
	orig := NewOrigSample()
	orig.LocationsStartIndex = int32(13)
	orig.LocationsLength = int32(13)
	orig.Value = GenerateOrigTestInt64Slice()
	orig.AttributeIndices = GenerateOrigTestInt32Slice()
	orig.LinkIndex_ = &otlpprofiles.Sample_LinkIndex{LinkIndex: int32(13)}
	orig.TimestampsUnixNano = GenerateOrigTestUint64Slice()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigSample(orig *otlpprofiles.Sample, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.LocationsStartIndex != int32(0) {
		dest.WriteObjectField("locationsStartIndex")
		dest.WriteInt32(orig.LocationsStartIndex)
	}
	if orig.LocationsLength != int32(0) {
		dest.WriteObjectField("locationsLength")
		dest.WriteInt32(orig.LocationsLength)
	}
	if len(orig.Value) > 0 {
		dest.WriteObjectField("value")
		dest.WriteArrayStart()
		dest.WriteInt64(orig.Value[0])
		for i := 1; i < len(orig.Value); i++ {
			dest.WriteMore()
			dest.WriteInt64(orig.Value[i])
		}
		dest.WriteArrayEnd()
	}
	if len(orig.AttributeIndices) > 0 {
		dest.WriteObjectField("attributeIndices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.AttributeIndices[0])
		for i := 1; i < len(orig.AttributeIndices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.AttributeIndices[i])
		}
		dest.WriteArrayEnd()
	}
	if orig, ok := orig.LinkIndex_.(*otlpprofiles.Sample_LinkIndex); ok {
		dest.WriteObjectField("linkIndex")
		dest.WriteInt32(orig.LinkIndex)
	}
	if len(orig.TimestampsUnixNano) > 0 {
		dest.WriteObjectField("timestampsUnixNano")
		dest.WriteArrayStart()
		dest.WriteUint64(orig.TimestampsUnixNano[0])
		for i := 1; i < len(orig.TimestampsUnixNano); i++ {
			dest.WriteMore()
			dest.WriteUint64(orig.TimestampsUnixNano[i])
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigSample unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigSample(orig *otlpprofiles.Sample, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "locationsStartIndex", "locations_start_index":
			orig.LocationsStartIndex = iter.ReadInt32()
		case "locationsLength", "locations_length":
			orig.LocationsLength = iter.ReadInt32()
		case "value":
			for iter.ReadArray() {
				orig.Value = append(orig.Value, iter.ReadInt64())
			}

		case "attributeIndices", "attribute_indices":
			for iter.ReadArray() {
				orig.AttributeIndices = append(orig.AttributeIndices, iter.ReadInt32())
			}

		case "linkIndex", "link_index":
			{
				var ov *otlpprofiles.Sample_LinkIndex
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpprofiles.Sample_LinkIndex{}
				} else {
					ov = ProtoPoolSample_LinkIndex.Get().(*otlpprofiles.Sample_LinkIndex)
				}
				ov.LinkIndex = iter.ReadInt32()
				orig.LinkIndex_ = ov
			}

		case "timestampsUnixNano", "timestamps_unix_nano":
			for iter.ReadArray() {
				orig.TimestampsUnixNano = append(orig.TimestampsUnixNano, iter.ReadUint64())
			}

		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigSample(orig *otlpprofiles.Sample) int {
	var n int
	var l int
	_ = l
	if orig.LocationsStartIndex != 0 {
		n += 1 + proto.Sov(uint64(orig.LocationsStartIndex))
	}
	if orig.LocationsLength != 0 {
		n += 1 + proto.Sov(uint64(orig.LocationsLength))
	}
	if len(orig.Value) > 0 {
		l = 0
		for _, e := range orig.Value {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if len(orig.AttributeIndices) > 0 {
		l = 0
		for _, e := range orig.AttributeIndices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig, ok := orig.LinkIndex_.(*otlpprofiles.Sample_LinkIndex); ok {
		_ = orig
		n += 1 + proto.Sov(uint64(orig.LinkIndex))
	}
	if len(orig.TimestampsUnixNano) > 0 {
		l = 0
		for _, e := range orig.TimestampsUnixNano {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigSample(orig *otlpprofiles.Sample, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.LocationsStartIndex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.LocationsStartIndex))
		pos--
		buf[pos] = 0x8
	}
	if orig.LocationsLength != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.LocationsLength))
		pos--
		buf[pos] = 0x10
	}
	l = len(orig.Value)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.Value[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x1a
	}
	l = len(orig.AttributeIndices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.AttributeIndices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x22
	}
	if orig, ok := orig.LinkIndex_.(*otlpprofiles.Sample_LinkIndex); ok {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.LinkIndex))
		pos--
		buf[pos] = 0x28
	}
	l = len(orig.TimestampsUnixNano)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.TimestampsUnixNano[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x32
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigSample(orig *otlpprofiles.Sample, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field LocationsStartIndex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.LocationsStartIndex = int32(num)

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field LocationsLength", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.LocationsLength = int32(num)
		case 3:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				var num uint64
				for startPos < pos {
					num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.Value = append(orig.Value, int64(num))
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field Value", pos-startPos)
				}
			case proto.WireTypeVarint:
				var num uint64
				num, pos, err = proto.ConsumeVarint(buf, pos)
				if err != nil {
					return err
				}
				orig.Value = append(orig.Value, int64(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
		case 4:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				var num uint64
				for startPos < pos {
					num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field AttributeIndices", pos-startPos)
				}
			case proto.WireTypeVarint:
				var num uint64
				num, pos, err = proto.ConsumeVarint(buf, pos)
				if err != nil {
					return err
				}
				orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeIndices", wireType)
			}

		case 5:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field LinkIndex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			var ov *otlpprofiles.Sample_LinkIndex
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpprofiles.Sample_LinkIndex{}
			} else {
				ov = ProtoPoolSample_LinkIndex.Get().(*otlpprofiles.Sample_LinkIndex)
			}
			ov.LinkIndex = int32(num)
			orig.LinkIndex_ = ov
		case 6:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				var num uint64
				for startPos < pos {
					num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.TimestampsUnixNano = append(orig.TimestampsUnixNano, uint64(num))
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field TimestampsUnixNano", pos-startPos)
				}
			case proto.WireTypeVarint:
				var num uint64
				num, pos, err = proto.ConsumeVarint(buf, pos)
				if err != nil {
					return err
				}
				orig.TimestampsUnixNano = append(orig.TimestampsUnixNano, uint64(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field TimestampsUnixNano", wireType)
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
