// Code generated by mdatagen. DO NOT EDIT.

package metadata

import (
	"errors"
	"sync"

	"go.opentelemetry.io/otel/metric"
	"go.opentelemetry.io/otel/trace"

	"go.opentelemetry.io/collector/component"
)

func Meter(settings component.TelemetrySettings) metric.Meter {
	return settings.MeterProvider.Meter("go.opentelemetry.io/collector/processor/memorylimiterprocessor")
}

func Tracer(settings component.TelemetrySettings) trace.Tracer {
	return settings.TracerProvider.Tracer("go.opentelemetry.io/collector/processor/memorylimiterprocessor")
}

// TelemetryBuilder provides an interface for components to report telemetry
// as defined in metadata and user config.
type TelemetryBuilder struct {
	meter                         metric.Meter
	mu                            sync.Mutex
	registrations                 []metric.Registration
	ProcessorAcceptedLogRecords   metric.Int64Counter
	ProcessorAcceptedMetricPoints metric.Int64Counter
	ProcessorAcceptedSpans        metric.Int64Counter
	ProcessorRefusedLogRecords    metric.Int64Counter
	ProcessorRefusedMetricPoints  metric.Int64Counter
	ProcessorRefusedSpans         metric.Int64Counter
}

// TelemetryBuilderOption applies changes to default builder.
type TelemetryBuilderOption interface {
	apply(*TelemetryBuilder)
}

type telemetryBuilderOptionFunc func(mb *TelemetryBuilder)

func (tbof telemetryBuilderOptionFunc) apply(mb *TelemetryBuilder) {
	tbof(mb)
}

// Shutdown unregister all registered callbacks for async instruments.
func (builder *TelemetryBuilder) Shutdown() {
	builder.mu.Lock()
	defer builder.mu.Unlock()
	for _, reg := range builder.registrations {
		reg.Unregister()
	}
}

// NewTelemetryBuilder provides a struct with methods to update all internal telemetry
// for a component
func NewTelemetryBuilder(settings component.TelemetrySettings, options ...TelemetryBuilderOption) (*TelemetryBuilder, error) {
	builder := TelemetryBuilder{}
	for _, op := range options {
		op.apply(&builder)
	}
	builder.meter = Meter(settings)
	var err, errs error
	builder.ProcessorAcceptedLogRecords, err = builder.meter.Int64Counter(
		"otelcol_processor_accepted_log_records",
		metric.WithDescription("Number of log records successfully pushed into the next component in the pipeline. [Deprecated since v0.110.0]"),
		metric.WithUnit("{records}"),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorAcceptedMetricPoints, err = builder.meter.Int64Counter(
		"otelcol_processor_accepted_metric_points",
		metric.WithDescription("Number of metric points successfully pushed into the next component in the pipeline. [Deprecated since v0.110.0]"),
		metric.WithUnit("{datapoints}"),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorAcceptedSpans, err = builder.meter.Int64Counter(
		"otelcol_processor_accepted_spans",
		metric.WithDescription("Number of spans successfully pushed into the next component in the pipeline. [Deprecated since v0.110.0]"),
		metric.WithUnit("{spans}"),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorRefusedLogRecords, err = builder.meter.Int64Counter(
		"otelcol_processor_refused_log_records",
		metric.WithDescription("Number of log records that were rejected by the next component in the pipeline. [Deprecated since v0.110.0]"),
		metric.WithUnit("{records}"),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorRefusedMetricPoints, err = builder.meter.Int64Counter(
		"otelcol_processor_refused_metric_points",
		metric.WithDescription("Number of metric points that were rejected by the next component in the pipeline. [Deprecated since v0.110.0]"),
		metric.WithUnit("{datapoints}"),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorRefusedSpans, err = builder.meter.Int64Counter(
		"otelcol_processor_refused_spans",
		metric.WithDescription("Number of spans that were rejected by the next component in the pipeline. [Deprecated since v0.110.0]"),
		metric.WithUnit("{spans}"),
	)
	errs = errors.Join(errs, err)
	return &builder, errs
}
