/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.bandwidthestimation2.BweDefinesKt;
import org.jitsi.nlj.rtp.bandwidthestimation2.LossBasedBweV2Kt;
import org.jitsi.nlj.rtp.bandwidthestimation2.LossBasedState;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacketResult;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.InstantKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b-\u0018\u0000 u2\u00020\u0001:\tmnopqrstuB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020)J\u0006\u0010+\u001a\u00020)J\u0006\u0010,\u001a\u00020)J\u0006\u0010-\u001a\u00020\"J\u0015\u0010.\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b0\u00101J\u001d\u00102\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b\u00a2\u0006\u0004\b3\u00104J+\u00105\u001a\u00020/2\f\u00106\u001a\b\u0012\u0004\u0012\u000208072\u0006\u0010 \u001a\u00020\b2\u0006\u00109\u001a\u00020)\u00a2\u0006\u0004\b:\u0010;J\r\u0010<\u001a\u00020\b\u00a2\u0006\u0004\b=\u0010>J\u0015\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020\b\u00a2\u0006\u0004\bA\u00101J\b\u0010B\u001a\u00020/H\u0002J\b\u0010C\u001a\u00020\u0019H\u0002J\b\u0010D\u001a\u00020\u0019H\u0002J\u000f\u0010E\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bF\u0010>J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020\n072\u0006\u00109\u001a\u00020)H\u0002J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\nH\u0002J\u0010\u0010K\u001a\u00020\u00192\u0006\u0010J\u001a\u00020\nH\u0002J\u0017\u0010L\u001a\u00020\u00192\u0006\u0010M\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bN\u0010OJ\u0018\u0010P\u001a\u00020\u00192\u0006\u0010Q\u001a\u00020\u00192\u0006\u0010R\u001a\u00020\u0019H\u0002J\u0017\u0010S\u001a\u00020\u00192\u0006\u0010M\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bT\u0010OJ\u0010\u0010U\u001a\u00020\u00192\u0006\u0010J\u001a\u00020\nH\u0002J\u0017\u0010V\u001a\u00020\b2\u0006\u0010W\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bX\u0010YJ\u000f\u0010Z\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b[\u0010>J\b\u0010\\\u001a\u00020/H\u0002J\u000f\u0010]\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b^\u0010>J\b\u0010_\u001a\u00020/H\u0002J\b\u0010`\u001a\u00020/H\u0002J\u0010\u0010a\u001a\u00020/2\u0006\u0010J\u001a\u00020\nH\u0002J\u0016\u0010b\u001a\u00020)2\f\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0002J\u001f\u0010c\u001a\u00020)2\u0006\u0010d\u001a\u00020\b2\u0006\u0010e\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bf\u0010gJ\b\u0010h\u001a\u00020)H\u0002J\u0017\u0010i\u001a\u00020)2\u0006\u0010j\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bk\u0010lR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2;", "", "configIn", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Config;", "<init>", "(Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Config;)V", "config", "acknowledgedBitrate", "Lorg/jitsi/nlj/util/Bandwidth;", "currentBestEstimate", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$ChannelParameters;", "numObservations", "", "observations", "", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Observation;", "partialObservation", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$PartialObservation;", "lastSendTimeMostRecentObservation", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "lastTimeEstimateReduced", "cachedInstantUpperBound", "cachedInstantLowerBound", "instantUpperBoundTemporalWeights", "", "temporalWeights", "recoveringAfterLossTimestamp", "bandwidthLimitInCurrentWindow", "J", "minBitrate", "maxBitrate", "delayBasedEstimate", "lossBasedResult", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Result;", "lastHoldInfo", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$HoldInfo;", "lastPaddingInfo", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$PaddingInfo;", "averageReportedLossRatio", "isEnabled", "", "isReady", "readyToUseInStartPhase", "useInStartPhase", "getLossBasedResult", "setAcknowledgedBitrate", "", "setAcknowledgedBitrate-_2icLw0", "(J)V", "setMinMaxBitrate", "setMinMaxBitrate-YUm52VA", "(JJ)V", "updateBandwidthEstimate", "packetResults", "", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacketResult;", "inAlr", "updateBandwidthEstimate-hO97Cac", "(Ljava/util/List;JZ)V", "getMedianSendingRate", "getMedianSendingRate-rlWvAKk", "()J", "setBandwidthEstimate", "bandwidthEstimate", "setBandwidthEstimate-_2icLw0", "updateAverageReportedLossRatio", "calculateAverageReportedPacketLossRatio", "calculateAverageReportedByteLossRatio", "getCandidateBandwidthUpperBound", "getCandidateBandwidthUpperBound-rlWvAKk", "getCandidates", "getDerivatives", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Derivatives;", "channelParameters", "getFeasibleInherentLoss", "getInherentLossUpperBound", "bandwidth", "getInherentLossUpperBound-_2icLw0", "(J)D", "adjustBiasFactor", "lossRate", "biasFactor", "getHighBandwidthBias", "getHighBandwidthBias-_2icLw0", "getObjective", "getSendingRate", "instantaneousSendingRate", "getSendingRate-GI7mN98", "(J)J", "getInstantUpperBound", "getInstantUpperBound-rlWvAKk", "calculateInstantUpperBound", "getInstantLowerBound", "getInstantLowerBound-rlWvAKk", "calculateInstantLowerBound", "calculateTemporalWeights", "newtonsMethodUpdate", "pushBackObservation", "isEstimateIncreasingWhenLossLimited", "oldEstimate", "newEstimate", "isEstimateIncreasingWhenLossLimited-YUm52VA", "(JJ)Z", "isInLossLimitedState", "canKeepIncreasingState", "estimate", "canKeepIncreasingState-_2icLw0", "(J)Z", "Result", "ChannelParameters", "Config", "Derivatives", "Observation", "PartialObservation", "PaddingInfo", "HoldInfo", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nLossBasedBweV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LossBasedBweV2.kt\norg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1190:1\n1#2:1191\n*E\n"})
public final class LossBasedBweV2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    @Nullable
    private Bandwidth acknowledgedBitrate;
    @NotNull
    private ChannelParameters currentBestEstimate;
    private int numObservations;
    @NotNull
    private final List<Observation> observations;
    @NotNull
    private PartialObservation partialObservation;
    private Instant lastSendTimeMostRecentObservation;
    private Instant lastTimeEstimateReduced;
    @Nullable
    private Bandwidth cachedInstantUpperBound;
    @Nullable
    private Bandwidth cachedInstantLowerBound;
    @NotNull
    private final List<Double> instantUpperBoundTemporalWeights;
    @NotNull
    private final List<Double> temporalWeights;
    private Instant recoveringAfterLossTimestamp;
    private long bandwidthLimitInCurrentWindow;
    private long minBitrate;
    private long maxBitrate;
    private long delayBasedEstimate;
    @NotNull
    private Result lossBasedResult;
    @NotNull
    private HoldInfo lastHoldInfo;
    @NotNull
    private PaddingInfo lastPaddingInfo;
    private double averageReportedLossRatio;
    @NotNull
    private static final Config defaultConfig = new Config(false, 0.0, 0.0, 0.0, 0.0, null, null, 0.0, 0.0, 0.0, 0.0, 0.0, 0L, 0.0, 0.0, 0, 0.0, false, false, false, null, 0, 0.0, 0.0, 0L, 0.0, 0.0, 0.0, 0.0, null, false, false, false, 0, 0.0, 0.0, false, null, false, 0.0, -1, 255, null);
    @NotNull
    private static final Logger logger = LoggerExtensionsKt.createLogger$default((Object)Companion, null, null, (int)3, null);

    public LossBasedBweV2(@NotNull Config configIn) {
        int it;
        ArrayList<Object> arrayList;
        int n;
        Intrinsics.checkNotNullParameter((Object)configIn, (String)"configIn");
        this.config = Config.copy-4dTakhU$default(configIn, false, 0.0, 0.0, 0.0, 0.0, null, null, 0.0, 0.0, 0.0, 0.0, 0.0, 0L, 0.0, 0.0, 0, 0.0, false, false, false, null, 0, 0.0, 0.0, 0L, 0.0, 0.0, 0.0, 0.0, null, false, false, false, 0, 0.0, 0.0, false, null, false, 0.0, -1, 255, null);
        this.currentBestEstimate = new ChannelParameters(this.config.getInitialInherentLossEstimate(), 0L, 2, null);
        int n2 = this.config.getObservationWindowSize();
        LossBasedBweV2 lossBasedBweV2 = this;
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n = n3++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(new Observation());
        }
        lossBasedBweV2.observations = arrayList2;
        this.partialObservation = new PartialObservation();
        this.lastSendTimeMostRecentObservation = Instant.MAX;
        this.lastTimeEstimateReduced = Instant.MIN;
        n2 = this.config.getObservationWindowSize();
        lossBasedBweV2 = this;
        arrayList2 = new ArrayList(n2);
        n3 = 0;
        while (n3 < n2) {
            it = n = n3++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(0.0);
        }
        lossBasedBweV2.instantUpperBoundTemporalWeights = arrayList2;
        n2 = this.config.getObservationWindowSize();
        lossBasedBweV2 = this;
        arrayList2 = new ArrayList(n2);
        n3 = 0;
        while (n3 < n2) {
            it = n = n3++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(0.0);
        }
        lossBasedBweV2.temporalWeights = arrayList2;
        this.recoveringAfterLossTimestamp = Instant.MIN;
        this.bandwidthLimitInCurrentWindow = Bandwidth.Companion.getINFINITY-rlWvAKk();
        this.minBitrate = BandwidthKt.getKbps(1);
        this.maxBitrate = Bandwidth.Companion.getINFINITY-rlWvAKk();
        this.delayBasedEstimate = Bandwidth.Companion.getINFINITY-rlWvAKk();
        this.lossBasedResult = new Result(0L, null, 3, null);
        this.lastHoldInfo = new HoldInfo(null, LossBasedBweV2Kt.access$getKInitHoldDuration$p(), 0L, 5, null);
        this.lastPaddingInfo = new PaddingInfo();
        if (!this.config.getEnabled()) {
            logger.debug((Object)"The configuration does not specify that the estimator should be enabled, disabling it.");
        }
        if (!this.config.isValid()) {
            logger.warn((Object)"The configuration is not valid, disabling the estimator.");
            this.config.setEnabled(false);
        }
        this.calculateTemporalWeights();
    }

    public /* synthetic */ LossBasedBweV2(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = defaultConfig;
        }
        this(config);
    }

    public final boolean isEnabled() {
        return this.config.getEnabled();
    }

    public final boolean isReady() {
        return this.isEnabled() && LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl(this.currentBestEstimate.getLossLimitedBandwidth-rlWvAKk())) && this.numObservations >= this.config.getMinNumObservations();
    }

    public final boolean readyToUseInStartPhase() {
        return this.isReady() && this.config.getUseInStartPhase();
    }

    public final boolean useInStartPhase() {
        return this.config.getUseInStartPhase();
    }

    @NotNull
    public final Result getLossBasedResult() {
        if (!this.isReady()) {
            if (!this.isEnabled()) {
                logger.warn((Object)"The estimator must be enabled before it can be used.");
            } else {
                if (!LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl(this.currentBestEstimate.getLossLimitedBandwidth-rlWvAKk()))) {
                    logger.warn((Object)"The estimator must be initialized before it can be used.");
                }
                if (this.numObservations <= this.config.getMinNumObservations()) {
                    logger.warn((Object)"The estimator must receive enough loss statistics before it can be used.");
                }
            }
            return new Result(LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl(this.delayBasedEstimate)) ? this.delayBasedEstimate : Bandwidth.Companion.getINFINITY-rlWvAKk(), LossBasedState.kDelayBasedEstimate, null);
        }
        return Result.copy-SimD6oM$default(this.lossBasedResult, 0L, null, 3, null);
    }

    public final void setAcknowledgedBitrate-_2icLw0(long l) {
        if (LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl(l))) {
            this.acknowledgedBitrate = Bandwidth.box-impl(l);
            this.calculateInstantLowerBound();
        } else {
            logger.warn((Object)("The acknowledged bitrate must be finite: " + Bandwidth.toString-impl(l)));
        }
    }

    public final void setMinMaxBitrate-YUm52VA(long l, long l2) {
        if (LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl(l))) {
            this.minBitrate = l;
            this.calculateInstantLowerBound();
        } else {
            logger.warn((Object)("The min bitrate must be finite: " + Bandwidth.toString-impl(l)));
        }
        if (LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl(l2))) {
            this.maxBitrate = l2;
        } else {
            logger.warn((Object)("The max bitrate must be finite: " + Bandwidth.toString-impl(l2)));
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void updateBandwidthEstimate-hO97Cac(@NotNull List<PacketResult> packetResults, long $v$c$org-jitsi-nlj-util-Bandwidth$-delayBasedEstimate$0, boolean inAlr) {
        block25: {
            Intrinsics.checkNotNullParameter(packetResults, (String)"packetResults");
            this.delayBasedEstimate = $v$c$org-jitsi-nlj-util-Bandwidth$-delayBasedEstimate$0;
            if (!this.isEnabled()) {
                LossBasedBweV2.logger.warn((Object)"The estimator must be enabled before it can be used.");
                return;
            }
            if (packetResults.isEmpty()) {
                LossBasedBweV2.logger.debug((Object)"The estimate cannot be updated without any loss statistics.");
                return;
            }
            if (!this.pushBackObservation(packetResults)) {
                return;
            }
            if (!LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl(this.currentBestEstimate.getLossLimitedBandwidth-rlWvAKk()))) {
                if (!LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl($v$c$org-jitsi-nlj-util-Bandwidth$-delayBasedEstimate$0))) {
                    LossBasedBweV2.logger.warn((Object)("The delay based estimate must be finite: " + Bandwidth.toString-impl($v$c$org-jitsi-nlj-util-Bandwidth$-delayBasedEstimate$0) + "."));
                    return;
                }
                this.currentBestEstimate.setLossLimitedBandwidth-_2icLw0($v$c$org-jitsi-nlj-util-Bandwidth$-delayBasedEstimate$0);
                this.lossBasedResult = new Result($v$c$org-jitsi-nlj-util-Bandwidth$-delayBasedEstimate$0, LossBasedState.kDelayBasedEstimate, null);
            }
            bestCandidate = this.currentBestEstimate;
            objectiveMax = -1.7976931348623157E308;
            for (ChannelParameters candidate : this.getCandidates(inAlr)) {
                this.newtonsMethodUpdate(candidate);
                candidateObjective = this.getObjective(candidate);
                if (!(candidateObjective > objectiveMax)) continue;
                objectiveMax = candidateObjective;
                bestCandidate = candidate;
            }
            if (Bandwidth.compareTo-_2icLw0(bestCandidate.getLossLimitedBandwidth-rlWvAKk(), this.currentBestEstimate.getLossLimitedBandwidth-rlWvAKk()) < 0) {
                this.lastTimeEstimateReduced = this.lastSendTimeMostRecentObservation;
            }
            if (this.averageReportedLossRatio > bestCandidate.getInherentLoss() && this.config.getNotIncreaseIfInherentLossLessThanAverageLoss() && Bandwidth.compareTo-_2icLw0(this.currentBestEstimate.getLossLimitedBandwidth-rlWvAKk(), bestCandidate.getLossLimitedBandwidth-rlWvAKk()) < 0) {
                bestCandidate.setLossLimitedBandwidth-_2icLw0(this.currentBestEstimate.getLossLimitedBandwidth-rlWvAKk());
            }
            if (!this.isInLossLimitedState()) break block25;
            v0 = this.recoveringAfterLossTimestamp;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"recoveringAfterLossTimestamp");
            if (InstantKt.isFinite((Instant)v0) && this.recoveringAfterLossTimestamp.plus(this.config.getDelayedIncreaseWindow()).compareTo(this.lastSendTimeMostRecentObservation) > 0 && Bandwidth.compareTo-_2icLw0(bestCandidate.getLossLimitedBandwidth-rlWvAKk(), this.bandwidthLimitInCurrentWindow) > 0) {
                bestCandidate.setLossLimitedBandwidth-_2icLw0(this.bandwidthLimitInCurrentWindow);
            }
            if (!(increasingWhenLossLimited = this.isEstimateIncreasingWhenLossLimited-YUm52VA(this.currentBestEstimate.getLossLimitedBandwidth-rlWvAKk(), bestCandidate.getLossLimitedBandwidth-rlWvAKk())) || !LossBasedBweV2Kt.access$isValid-eKiYIew(this.acknowledgedBitrate)) break block25;
            if (!LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl(this.lastHoldInfo.getRate-rlWvAKk()))) ** GOTO lbl-1000
            v1 = this.acknowledgedBitrate;
            Intrinsics.checkNotNull((Object)v1);
            if (Bandwidth.compareTo-_2icLw0(v1.unbox-impl(), BandwidthKt.times-ERFH51c(this.config.getBandwidthRampupHoldThreshold(), this.lastHoldInfo.getRate-rlWvAKk())) < 0) {
                v2 = this.config.getBandwidthRampupUpperBoundFactorInHold();
            } else lbl-1000:
            // 2 sources

            {
                v2 = this.config.getBandwidthRampupUpperBoundFactor();
            }
            rampupFactor = v2;
            v3 = this.currentBestEstimate.getLossLimitedBandwidth-rlWvAKk();
            v4 = bestCandidate.getLossLimitedBandwidth-rlWvAKk();
            v5 = this.acknowledgedBitrate;
            Intrinsics.checkNotNull((Object)v5);
            bestCandidate.setLossLimitedBandwidth-_2icLw0(BandwidthKt.max-YUm52VA(v3, BandwidthKt.min-YUm52VA(v4, BandwidthKt.times-ERFH51c(rampupFactor, v5.unbox-impl()))));
            if (this.lossBasedResult.getState() == LossBasedState.kDecreasing && Bandwidth.equals-impl0(bestCandidate.getLossLimitedBandwidth-rlWvAKk(), this.currentBestEstimate.getLossLimitedBandwidth-rlWvAKk())) {
                bestCandidate.setLossLimitedBandwidth-_2icLw0(Bandwidth.plus-GI7mN98(this.currentBestEstimate.getLossLimitedBandwidth-rlWvAKk(), BandwidthKt.getBps(1)));
            }
        }
        boundedBandwidthEstimate = new Ref.LongRef();
        boundedBandwidthEstimate.element = Bandwidth.Companion.getINFINITY-rlWvAKk();
        v6 = boundedBandwidthEstimate.element = LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl($v$c$org-jitsi-nlj-util-Bandwidth$-delayBasedEstimate$0)) != false ? BandwidthKt.max-YUm52VA(this.getInstantLowerBound-rlWvAKk(), ((Bandwidth)ComparisonsKt.minOf((Comparable)Bandwidth.box-impl(bestCandidate.getLossLimitedBandwidth-rlWvAKk()), (Comparable)Bandwidth.box-impl(this.getInstantUpperBound-rlWvAKk()), (Comparable)Bandwidth.box-impl($v$c$org-jitsi-nlj-util-Bandwidth$-delayBasedEstimate$0))).unbox-impl()) : BandwidthKt.max-YUm52VA(this.getInstantLowerBound-rlWvAKk(), BandwidthKt.min-YUm52VA(bestCandidate.getLossLimitedBandwidth-rlWvAKk(), this.getInstantUpperBound-rlWvAKk()));
        if (this.config.getBoundBestCandidate() && Bandwidth.compareTo-_2icLw0(boundedBandwidthEstimate.element, bestCandidate.getLossLimitedBandwidth-rlWvAKk()) < 0) {
            this.currentBestEstimate.setLossLimitedBandwidth-_2icLw0(boundedBandwidthEstimate.element);
            this.currentBestEstimate.setInherentLoss(0.0);
        } else {
            this.currentBestEstimate = bestCandidate;
            if (this.config.getLowerBoundByAckedRateFactor() > 0.0) {
                this.currentBestEstimate.setLossLimitedBandwidth-_2icLw0(BandwidthKt.max-YUm52VA(this.currentBestEstimate.getLossLimitedBandwidth-rlWvAKk(), this.getInstantLowerBound-rlWvAKk()));
            }
        }
        if (this.lossBasedResult.getState() == LossBasedState.kDecreasing && this.lastHoldInfo.getTimestamp().compareTo(this.lastSendTimeMostRecentObservation) > 0 && Bandwidth.compareTo-_2icLw0(boundedBandwidthEstimate.element, $v$c$org-jitsi-nlj-util-Bandwidth$-delayBasedEstimate$0) < 0) {
            if (this.config.getLowerBoundByAckedRateFactor() > 0.0) {
                this.lastHoldInfo.setRate-_2icLw0(BandwidthKt.max-YUm52VA(this.getInstantLowerBound-rlWvAKk(), this.lastHoldInfo.getRate-rlWvAKk()));
            }
            this.lossBasedResult.setBandwidthEstimate-_2icLw0(BandwidthKt.min-YUm52VA(this.lastHoldInfo.getRate-rlWvAKk(), boundedBandwidthEstimate.element));
            return;
        }
        if (this.isEstimateIncreasingWhenLossLimited-YUm52VA(this.lossBasedResult.getBandwidthEstimate-rlWvAKk(), boundedBandwidthEstimate.element) && this.canKeepIncreasingState-_2icLw0(boundedBandwidthEstimate.element) && Bandwidth.compareTo-_2icLw0(boundedBandwidthEstimate.element, $v$c$org-jitsi-nlj-util-Bandwidth$-delayBasedEstimate$0) < 0 && Bandwidth.compareTo-_2icLw0(boundedBandwidthEstimate.element, this.maxBitrate) < 0) {
            if (this.config.getPaddingDuration().compareTo(Duration.ZERO) > 0 && Bandwidth.compareTo-_2icLw0(boundedBandwidthEstimate.element, this.lastPaddingInfo.getPaddingRate-rlWvAKk()) > 0) {
                this.lastPaddingInfo.setPaddingRate-_2icLw0(boundedBandwidthEstimate.element);
                this.lastPaddingInfo.setPaddingTimestamp(this.lastSendTimeMostRecentObservation);
            }
            this.lossBasedResult.setState(this.config.getPaddingDuration().compareTo(Duration.ZERO) > 0 ? LossBasedState.kIncreaseUsingPadding : LossBasedState.kIncreasing);
        } else if (Bandwidth.compareTo-_2icLw0(boundedBandwidthEstimate.element, $v$c$org-jitsi-nlj-util-Bandwidth$-delayBasedEstimate$0) < 0 && Bandwidth.compareTo-_2icLw0(boundedBandwidthEstimate.element, this.maxBitrate) < 0) {
            if (this.lossBasedResult.getState() != LossBasedState.kDecreasing && this.config.getHoldDurationFactor() > 0.0) {
                LossBasedBweV2.logger.info((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, updateBandwidthEstimate_hO97Cac$lambda$0(kotlin.jvm.internal.Ref$LongRef org.jitsi.nlj.rtp.bandwidthestimation2.LossBasedBweV2 ), ()Ljava/lang/String;)((Ref.LongRef)boundedBandwidthEstimate, (LossBasedBweV2)this));
                v7 = this.lastSendTimeMostRecentObservation.plus(this.lastHoldInfo.getDuration());
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"plus(...)");
                this.lastHoldInfo = new HoldInfo(v7, DurationKt.min((Duration)LossBasedBweV2Kt.access$getKMaxHoldDuration$p(), (Duration)DurationKt.times((Duration)this.lastHoldInfo.getDuration(), (double)this.config.getHoldDurationFactor())), boundedBandwidthEstimate.element, null);
            }
            this.lossBasedResult.setState(LossBasedState.kDecreasing);
        } else {
            v8 = Instant.MIN;
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"MIN");
            this.lastHoldInfo = new HoldInfo(v8, LossBasedBweV2Kt.access$getKInitHoldDuration$p(), Bandwidth.Companion.getINFINITY-rlWvAKk(), null);
            this.lossBasedResult.setState(LossBasedState.kDelayBasedEstimate);
        }
        this.lossBasedResult.setBandwidthEstimate-_2icLw0(boundedBandwidthEstimate.element);
        if (this.isInLossLimitedState()) {
            v9 = this.recoveringAfterLossTimestamp;
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"recoveringAfterLossTimestamp");
            if (InstantKt.isInfinite((Instant)v9) || this.recoveringAfterLossTimestamp.plus(this.config.getDelayedIncreaseWindow()).compareTo(this.lastSendTimeMostRecentObservation) < 0) {
                this.bandwidthLimitInCurrentWindow = BandwidthKt.max-YUm52VA(BweDefinesKt.getKCongestionControllerMinBitrate(), Bandwidth.times-WElJv5I(this.currentBestEstimate.getLossLimitedBandwidth-rlWvAKk(), this.config.getMaxIncreaseFactor()));
                this.recoveringAfterLossTimestamp = this.lastSendTimeMostRecentObservation;
            }
        }
    }

    public final long getMedianSendingRate-rlWvAKk() {
        List sendingRates = new ArrayList();
        for (Observation observation : this.observations) {
            if (!observation.isInitialized() || !LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl(observation.getSendingRate-rlWvAKk())) || Bandwidth.equals-impl0(observation.getSendingRate-rlWvAKk(), Bandwidth.Companion.getZERO-rlWvAKk())) continue;
            sendingRates.add(Bandwidth.box-impl(observation.getSendingRate-rlWvAKk()));
        }
        if (sendingRates.isEmpty()) {
            return Bandwidth.Companion.getZERO-rlWvAKk();
        }
        CollectionsKt.sort((List)sendingRates);
        if (sendingRates.size() % 2 == 0) {
            return Bandwidth.div-WElJv5I(Bandwidth.plus-GI7mN98(((Bandwidth)sendingRates.get(sendingRates.size() / 2 - 1)).unbox-impl(), ((Bandwidth)sendingRates.get(sendingRates.size() / 2)).unbox-impl()), 2);
        }
        return ((Bandwidth)sendingRates.get(sendingRates.size() / 2)).unbox-impl();
    }

    public final void setBandwidthEstimate-_2icLw0(long l) {
        if (LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl(l))) {
            this.currentBestEstimate.setLossLimitedBandwidth-_2icLw0(l);
            this.lossBasedResult = new Result(l, LossBasedState.kDelayBasedEstimate, null);
        } else {
            logger.warn((Object)("The bandwidth estimate must be finite: " + Bandwidth.toString-impl(l)));
        }
    }

    private final void updateAverageReportedLossRatio() {
        this.averageReportedLossRatio = this.config.getUseByteLossRate() ? this.calculateAverageReportedByteLossRatio() : this.calculateAverageReportedPacketLossRatio();
    }

    private final double calculateAverageReportedPacketLossRatio() {
        if (this.numObservations <= 0) {
            return 0.0;
        }
        double numPackets = 0.0;
        double numLostPackets = 0.0;
        for (Observation observation : this.observations) {
            if (!observation.isInitialized()) continue;
            double instantTemporalWeight = ((Number)this.instantUpperBoundTemporalWeights.get(this.numObservations - 1 - observation.getId())).doubleValue();
            numPackets += instantTemporalWeight * (double)observation.getNumPackets();
            numLostPackets += instantTemporalWeight * (double)observation.getNumLostPackets();
        }
        return numLostPackets / numPackets;
    }

    private final double calculateAverageReportedByteLossRatio() {
        if (this.numObservations <= 0) {
            return 0.0;
        }
        DataSize totalBytes = DataSize.Companion.getZERO();
        DataSize lostBytes = DataSize.Companion.getZERO();
        double minLossRate = 1.0;
        double maxLossRate = 0.0;
        DataSize minLostBytes = DataSize.Companion.getZERO();
        DataSize maxLostBytes = DataSize.Companion.getZERO();
        DataSize minBytesReceived = DataSize.Companion.getZERO();
        DataSize maxBytesReceived = DataSize.Companion.getZERO();
        long sendRateOfMaxLossObservation = Bandwidth.Companion.getZERO-rlWvAKk();
        for (Observation observation : this.observations) {
            double lossRate;
            if (!observation.isInitialized()) continue;
            double instantTemporalWeight = ((Number)this.instantUpperBoundTemporalWeights.get(this.numObservations - 1 - observation.getId())).doubleValue();
            totalBytes = totalBytes.plus(observation.getSize().times(instantTemporalWeight));
            lostBytes = lostBytes.plus(observation.getLostSize().times(instantTemporalWeight));
            double d = lossRate = !Intrinsics.areEqual((Object)observation.getSize(), (Object)DataSize.Companion.getZERO()) ? observation.getLostSize().div(observation.getSize()) : 0.0;
            if (this.numObservations <= 3) continue;
            if (lossRate > maxLossRate) {
                maxLossRate = lossRate;
                maxLostBytes = DataSizeKt.times(instantTemporalWeight, observation.getLostSize());
                maxBytesReceived = DataSizeKt.times(instantTemporalWeight, observation.getSize());
                sendRateOfMaxLossObservation = observation.getSendingRate-rlWvAKk();
            }
            if (!(lossRate < minLossRate)) continue;
            minLossRate = lossRate;
            minLostBytes = DataSizeKt.times(instantTemporalWeight, observation.getLostSize());
            minBytesReceived = DataSizeKt.times(instantTemporalWeight, observation.getSize());
        }
        if (Bandwidth.compareTo-_2icLw0(Bandwidth.times-WElJv5I(this.getMedianSendingRate-rlWvAKk(), this.config.getMedianSendingRateFactor()), sendRateOfMaxLossObservation) <= 0) {
            return lostBytes.div(totalBytes);
        }
        if (Intrinsics.areEqual((Object)totalBytes, (Object)maxBytesReceived.plus(minBytesReceived))) {
            return lostBytes.div(totalBytes);
        }
        return lostBytes.minus(minLostBytes).minus(maxLostBytes).div(totalBytes.minus(maxBytesReceived).minus(minBytesReceived));
    }

    private final long getCandidateBandwidthUpperBound-rlWvAKk() {
        long candidateBandwidthUpperBound = this.maxBitrate;
        if (this.isInLossLimitedState() && LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl(this.bandwidthLimitInCurrentWindow))) {
            candidateBandwidthUpperBound = this.bandwidthLimitInCurrentWindow;
        }
        if (this.acknowledgedBitrate == null) {
            return candidateBandwidthUpperBound;
        }
        if (this.config.getRampupAccelerationMaxFactor() > 0.0) {
            Duration duration = this.config.getRampupAccelerationMaxoutTime();
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
            Duration duration3 = Duration.between(this.lastTimeEstimateReduced, this.lastSendTimeMostRecentObservation);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"between(...)");
            Duration timeSinceBandwidthReduced = DurationKt.min((Duration)duration, (Duration)DurationKt.max((Duration)duration2, (Duration)duration3));
            double rampupAcceleration = this.config.getRampupAccelerationMaxFactor() * DurationKt.div((Duration)timeSinceBandwidthReduced, (Duration)this.config.getRampupAccelerationMaxoutTime());
            Bandwidth bandwidth = this.acknowledgedBitrate;
            Intrinsics.checkNotNull((Object)bandwidth);
            candidateBandwidthUpperBound = Bandwidth.plus-GI7mN98(candidateBandwidthUpperBound, BandwidthKt.times-ERFH51c(rampupAcceleration, bandwidth.unbox-impl()));
        }
        return candidateBandwidthUpperBound;
    }

    private final List<ChannelParameters> getCandidates(boolean inAlr) {
        ChannelParameters bestEstimate = ChannelParameters.copy-ERFH51c$default(this.currentBestEstimate, 0.0, 0L, 3, null);
        List bandwidths = new ArrayList();
        for (double candidateFactor : this.config.getCandidateFactors()) {
            bandwidths.add(Bandwidth.box-impl(BandwidthKt.times-ERFH51c(candidateFactor, this.currentBestEstimate.getLossLimitedBandwidth-rlWvAKk())));
        }
        if (this.acknowledgedBitrate != null && this.config.getAppendAcknowledgedRateCandidate() && (!this.config.getNotUseAckedRateInAlr() || !inAlr || this.config.getPaddingDuration().compareTo(Duration.ZERO) > 0 && this.lastPaddingInfo.getPaddingTimestamp().plus(this.config.getPaddingDuration()).compareTo(this.lastSendTimeMostRecentObservation) >= 0)) {
            Bandwidth bandwidth = this.acknowledgedBitrate;
            Intrinsics.checkNotNull((Object)bandwidth);
            bandwidths.add(Bandwidth.box-impl(Bandwidth.times-WElJv5I(bandwidth.unbox-impl(), this.config.getBandwidthBackoffLowerBoundFactor())));
        }
        if (LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl(this.delayBasedEstimate)) && this.config.getAppendDelayBasedEstimateCandidate() && Bandwidth.compareTo-_2icLw0(this.delayBasedEstimate, bestEstimate.getLossLimitedBandwidth-rlWvAKk()) > 0) {
            bandwidths.add(Bandwidth.box-impl(this.delayBasedEstimate));
        }
        if (inAlr && this.config.getAppendUpperBoundCandidateInAlr() && Bandwidth.compareTo-_2icLw0(bestEstimate.getLossLimitedBandwidth-rlWvAKk(), this.getInstantUpperBound-rlWvAKk()) > 0) {
            bandwidths.add(Bandwidth.box-impl(this.getInstantUpperBound-rlWvAKk()));
        }
        long candidateBandwidthUpperBound = this.getCandidateBandwidthUpperBound-rlWvAKk();
        List candidates = new ArrayList();
        int n = ((Collection)bandwidths).size();
        for (int i = 0; i < n; ++i) {
            ChannelParameters candidate = ChannelParameters.copy-ERFH51c$default(bestEstimate, 0.0, 0L, 3, null);
            candidate.setLossLimitedBandwidth-_2icLw0(BandwidthKt.min-YUm52VA(((Bandwidth)bandwidths.get(i)).unbox-impl(), BandwidthKt.max-YUm52VA(bestEstimate.getLossLimitedBandwidth-rlWvAKk(), candidateBandwidthUpperBound)));
            candidate.setInherentLoss(this.getFeasibleInherentLoss(candidate));
            candidates.add(candidate);
        }
        if (!(candidates.size() == bandwidths.size())) {
            throw new IllegalStateException("Check failed.");
        }
        return candidates;
    }

    private final Derivatives getDerivatives(ChannelParameters channelParameters) {
        Derivatives derivatives = new Derivatives(0.0, 0.0, 3, null);
        for (Observation observation : this.observations) {
            if (!observation.isInitialized()) continue;
            double lossProbability = LossBasedBweV2Kt.access$getLossProbability-3l-g26c(channelParameters.getInherentLoss(), channelParameters.getLossLimitedBandwidth-rlWvAKk(), observation.getSendingRate-rlWvAKk());
            double temporalWeight = ((Number)this.temporalWeights.get(this.numObservations - 1 - observation.getId())).doubleValue();
            if (this.config.getUseByteLossRate()) {
                derivatives.setFirst(derivatives.getFirst() + temporalWeight * (observation.getLostSize().getKiloBytes() / lossProbability - observation.getSize().minus(observation.getLostSize()).getKiloBytes() / (1.0 - lossProbability)));
                derivatives.setSecond(derivatives.getSecond() - temporalWeight * (observation.getLostSize().getKiloBytes() / Math.pow(lossProbability, 2) + observation.getSize().minus(observation.getLostSize()).getKiloBytes() / Math.pow(1.0 - lossProbability, 2)));
                continue;
            }
            derivatives.setFirst(derivatives.getFirst() + temporalWeight * ((double)observation.getNumLostPackets() / lossProbability - (double)observation.getNumReceivedPackets() / (1.0 - lossProbability)));
            derivatives.setSecond(derivatives.getSecond() - temporalWeight * ((double)observation.getNumLostPackets() / Math.pow(lossProbability, 2) + (double)observation.getNumReceivedPackets() / Math.pow(1.0 - lossProbability, 2)));
        }
        if (derivatives.getSecond() >= 0.0) {
            logger.error((Object)("The second derivative is mathematically guaranteed to be negative but is " + derivatives.getSecond() + "."));
            derivatives.setSecond(-1000000.0);
        }
        return derivatives;
    }

    private final double getFeasibleInherentLoss(ChannelParameters channelParameters) {
        return Math.min(Math.max(channelParameters.getInherentLoss(), this.config.getInherentLossLowerBound()), this.getInherentLossUpperBound-_2icLw0(channelParameters.getLossLimitedBandwidth-rlWvAKk()));
    }

    private final double getInherentLossUpperBound-_2icLw0(long l) {
        if (Bandwidth.equals-impl0(l, Bandwidth.Companion.getZERO-rlWvAKk())) {
            return 1.0;
        }
        double inherentLossUpperBound = this.config.getInherentLossUpperBoundOffset() + Bandwidth.div-_2icLw0(this.config.getInherentLossUpperBoundBandwidthBalance-rlWvAKk(), l);
        return Math.min(inherentLossUpperBound, 1.0);
    }

    private final double adjustBiasFactor(double lossRate, double biasFactor) {
        return biasFactor * (this.config.getLossThresholdOfHighBandwidthPreference() - lossRate) / (this.config.getBandwidthPreferenceSmoothingFactor() + Math.abs(this.config.getLossThresholdOfHighBandwidthPreference() - lossRate));
    }

    private final double getHighBandwidthBias-_2icLw0(long l) {
        if (LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl(l))) {
            return this.adjustBiasFactor(this.averageReportedLossRatio, this.config.getHigherBandwidthBiasFactor()) * Bandwidth.getKbps-impl(l) + this.adjustBiasFactor(this.averageReportedLossRatio, this.config.getHigherLogBandwidthBiasFactor()) * Math.log(1.0 + Bandwidth.getKbps-impl(l));
        }
        return 0.0;
    }

    private final double getObjective(ChannelParameters channelParameters) {
        double objective = 0.0;
        double highBandwidthBias = this.getHighBandwidthBias-_2icLw0(channelParameters.getLossLimitedBandwidth-rlWvAKk());
        for (Observation observation : this.observations) {
            if (!observation.isInitialized()) continue;
            double lossProbability = LossBasedBweV2Kt.access$getLossProbability-3l-g26c(channelParameters.getInherentLoss(), channelParameters.getLossLimitedBandwidth-rlWvAKk(), observation.getSendingRate-rlWvAKk());
            double temporalWeight = ((Number)this.temporalWeights.get(this.numObservations - 1 - observation.getId())).doubleValue();
            if (this.config.getUseByteLossRate()) {
                objective += temporalWeight * (observation.getLostSize().getKiloBytes() * Math.log(lossProbability) + observation.getSize().minus(observation.getLostSize()).getKiloBytes() * Math.log(1.0 - lossProbability));
                objective += temporalWeight * highBandwidthBias * observation.getSize().getKiloBytes();
                continue;
            }
            objective += temporalWeight * ((double)observation.getNumLostPackets() * Math.log(lossProbability) + (double)observation.getNumReceivedPackets() * Math.log(1.0 - lossProbability));
            objective += temporalWeight * highBandwidthBias * (double)observation.getNumPackets();
        }
        return objective;
    }

    private final long getSendingRate-GI7mN98(long l) {
        if (this.numObservations <= 0) {
            return l;
        }
        int mostRecentObservationIdx = (this.numObservations - 1) % this.config.getObservationWindowSize();
        Observation mostRecentObservation = this.observations.get(mostRecentObservationIdx);
        long sendingRatePreviousObservation = mostRecentObservation.getSendingRate-rlWvAKk();
        return Bandwidth.plus-GI7mN98(BandwidthKt.times-ERFH51c(this.config.getSendingRateSmoothingFactor(), sendingRatePreviousObservation), BandwidthKt.times-ERFH51c(1.0 - this.config.getSendingRateSmoothingFactor(), l));
    }

    private final long getInstantUpperBound-rlWvAKk() {
        Bandwidth bandwidth = this.cachedInstantUpperBound;
        return bandwidth != null ? bandwidth.unbox-impl() : this.maxBitrate;
    }

    private final void calculateInstantUpperBound() {
        long instantLimit = this.maxBitrate;
        if (this.averageReportedLossRatio > this.config.getInstantUpperBoundLossOffset()) {
            instantLimit = Bandwidth.div-WElJv5I(this.config.getInstantUpperBoundBandwidthBalance-rlWvAKk(), this.averageReportedLossRatio - this.config.getInstantUpperBoundLossOffset());
        }
        this.cachedInstantUpperBound = Bandwidth.box-impl(instantLimit);
    }

    private final long getInstantLowerBound-rlWvAKk() {
        Bandwidth bandwidth = this.cachedInstantLowerBound;
        return bandwidth != null ? bandwidth.unbox-impl() : Bandwidth.Companion.getZERO-rlWvAKk();
    }

    private final void calculateInstantLowerBound() {
        long instanceLowerBound = Bandwidth.Companion.getZERO-rlWvAKk();
        if (LossBasedBweV2Kt.access$isValid-eKiYIew(this.acknowledgedBitrate) && this.config.getLowerBoundByAckedRateFactor() > 0.0) {
            double d = this.config.getLowerBoundByAckedRateFactor();
            Bandwidth bandwidth = this.acknowledgedBitrate;
            Intrinsics.checkNotNull((Object)bandwidth);
            instanceLowerBound = BandwidthKt.times-ERFH51c(d, bandwidth.unbox-impl());
        }
        if (LossBasedBweV2Kt.access$isValid-eKiYIew(Bandwidth.box-impl(this.minBitrate))) {
            instanceLowerBound = BandwidthKt.max-YUm52VA(instanceLowerBound, this.minBitrate);
        }
        this.cachedInstantLowerBound = Bandwidth.box-impl(instanceLowerBound);
    }

    private final void calculateTemporalWeights() {
        int n = this.config.getObservationWindowSize();
        for (int i = 0; i < n; ++i) {
            this.temporalWeights.set(i, Math.pow(this.config.getTemporalWeightFactor(), i));
            this.instantUpperBoundTemporalWeights.set(i, Math.pow(this.config.getInstantUpperBoundTemporalWeightFactor(), i));
        }
    }

    private final void newtonsMethodUpdate(ChannelParameters channelParameters) {
        if (this.numObservations <= 0) {
            return;
        }
        int n = this.config.getNewtonIterations();
        for (int i = 0; i < n; ++i) {
            Derivatives derivatives = this.getDerivatives(channelParameters);
            channelParameters.setInherentLoss(channelParameters.getInherentLoss() - this.config.getNewtonStepSize() * derivatives.getFirst() / derivatives.getSecond());
            channelParameters.setInherentLoss(this.getFeasibleInherentLoss(channelParameters));
        }
    }

    private final boolean pushBackObservation(List<PacketResult> packetResults) {
        Duration observationDuration;
        Iterator iterator;
        if (packetResults.isEmpty()) {
            return false;
        }
        PartialObservation partialObservation = this.partialObservation;
        partialObservation.setNumPackets(partialObservation.getNumPackets() + packetResults.size());
        Instant lastSendTime = Instant.MIN;
        Instant firstSendTime = Instant.MAX;
        for (PacketResult packet : packetResults) {
            if (packet.isReceived()) {
                this.partialObservation.getLostPackets().remove(packet.getSentPacket().getSequenceNumber());
            } else {
                ((Map)this.partialObservation.getLostPackets()).put(packet.getSentPacket().getSequenceNumber(), packet.getSentPacket().getSize());
            }
            iterator = this.partialObservation;
            ((PartialObservation)((Object)iterator)).setSize(((PartialObservation)((Object)iterator)).getSize().plus(packet.getSentPacket().getSize()));
            iterator = lastSendTime;
            Intrinsics.checkNotNull((Object)iterator);
            lastSendTime = InstantKt.max((Instant)((Object)iterator), (Instant)packet.getSentPacket().getSendTime());
            iterator = firstSendTime;
            Intrinsics.checkNotNull((Object)iterator);
            firstSendTime = InstantKt.min((Instant)((Object)iterator), (Instant)packet.getSentPacket().getSendTime());
        }
        Instant instant = this.lastSendTimeMostRecentObservation;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"lastSendTimeMostRecentObservation");
        if (!LossBasedBweV2Kt.access$isValid(instant)) {
            this.lastSendTimeMostRecentObservation = firstSendTime;
        }
        if ((observationDuration = Duration.between(this.lastSendTimeMostRecentObservation, lastSendTime)).compareTo(Duration.ZERO) <= 0 || observationDuration.compareTo(this.config.getObservationDurationLowerBound()) < 0) {
            return false;
        }
        this.lastSendTimeMostRecentObservation = lastSendTime;
        Observation observation = new Observation();
        observation.setNumPackets(this.partialObservation.getNumPackets());
        observation.setNumLostPackets(this.partialObservation.getLostPackets().size());
        observation.setNumReceivedPackets(observation.getNumPackets() - observation.getNumLostPackets());
        DataSize dataSize = this.partialObservation.getSize();
        Intrinsics.checkNotNull((Object)observationDuration);
        observation.setSendingRate-_2icLw0(this.getSendingRate-GI7mN98(BandwidthKt.per(dataSize, observationDuration)));
        iterator = ((Map)this.partialObservation.getLostPackets()).entrySet().iterator();
        while (iterator.hasNext()) {
            DataSize packetSize = (DataSize)iterator.next().getValue();
            observation.setLostSize(observation.getLostSize().plus(packetSize));
        }
        observation.setSize(this.partialObservation.getSize());
        int n = this.numObservations;
        this.numObservations = n + 1;
        observation.setId(n);
        this.observations.set(observation.getId() % this.config.getObservationWindowSize(), observation);
        this.partialObservation = new PartialObservation();
        this.updateAverageReportedLossRatio();
        this.calculateInstantUpperBound();
        return true;
    }

    private final boolean isEstimateIncreasingWhenLossLimited-YUm52VA(long l, long l2) {
        return (Bandwidth.compareTo-_2icLw0(l, l2) < 0 || Bandwidth.equals-impl0(l, l2) && (this.lossBasedResult.getState() == LossBasedState.kIncreasing || this.lossBasedResult.getState() == LossBasedState.kIncreaseUsingPadding)) && this.isInLossLimitedState();
    }

    private final boolean isInLossLimitedState() {
        return this.lossBasedResult.getState() != LossBasedState.kDelayBasedEstimate;
    }

    private final boolean canKeepIncreasingState-_2icLw0(long l) {
        if (Intrinsics.areEqual((Object)this.config.getPaddingDuration(), (Object)Duration.ZERO) || this.lossBasedResult.getState() != LossBasedState.kIncreaseUsingPadding) {
            return true;
        }
        return this.lastPaddingInfo.getPaddingTimestamp().plus(this.config.getPaddingDuration()).compareTo(this.lastSendTimeMostRecentObservation) >= 0 || Bandwidth.compareTo-_2icLw0(this.lastPaddingInfo.getPaddingRate-rlWvAKk(), l) < 0;
    }

    private static final String updateBandwidthEstimate_hO97Cac$lambda$0(Ref.LongRef $boundedBandwidthEstimate, LossBasedBweV2 this$0) {
        return "Switch to HOLD. Bounded BWE: " + Bandwidth.toString-impl($boundedBandwidthEstimate.element) + ", duration: " + this$0.lastHoldInfo.getDuration();
    }

    public LossBasedBweV2() {
        this(null, 1, null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\rJ$\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$ChannelParameters;", "", "inherentLoss", "", "lossLimitedBandwidth", "Lorg/jitsi/nlj/util/Bandwidth;", "<init>", "(DJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getInherentLoss", "()D", "setInherentLoss", "(D)V", "getLossLimitedBandwidth-rlWvAKk", "()J", "setLossLimitedBandwidth-_2icLw0", "(J)V", "J", "component1", "component2", "component2-rlWvAKk", "copy", "copy-ERFH51c", "(DJ)Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$ChannelParameters;", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-media-transform"})
    private static final class ChannelParameters {
        private double inherentLoss;
        private long lossLimitedBandwidth;

        private ChannelParameters(double inherentLoss, long lossLimitedBandwidth) {
            this.inherentLoss = inherentLoss;
            this.lossLimitedBandwidth = lossLimitedBandwidth;
        }

        public /* synthetic */ ChannelParameters(double d, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                d = 0.0;
            }
            if ((n & 2) != 0) {
                l = Bandwidth.Companion.getMINUS_INFINITY-rlWvAKk();
            }
            this(d, l, null);
        }

        public final double getInherentLoss() {
            return this.inherentLoss;
        }

        public final void setInherentLoss(double d) {
            this.inherentLoss = d;
        }

        public final long getLossLimitedBandwidth-rlWvAKk() {
            return this.lossLimitedBandwidth;
        }

        public final void setLossLimitedBandwidth-_2icLw0(long l) {
            this.lossLimitedBandwidth = l;
        }

        public final double component1() {
            return this.inherentLoss;
        }

        public final long component2-rlWvAKk() {
            return this.lossLimitedBandwidth;
        }

        @NotNull
        public final ChannelParameters copy-ERFH51c(double inherentLoss, long l) {
            return new ChannelParameters(inherentLoss, l, null);
        }

        public static /* synthetic */ ChannelParameters copy-ERFH51c$default(ChannelParameters channelParameters, double d, long l, int n, Object object) {
            if ((n & 1) != 0) {
                d = channelParameters.inherentLoss;
            }
            if ((n & 2) != 0) {
                l = channelParameters.lossLimitedBandwidth;
            }
            return channelParameters.copy-ERFH51c(d, l);
        }

        @NotNull
        public String toString() {
            return "ChannelParameters(inherentLoss=" + this.inherentLoss + ", lossLimitedBandwidth=" + Bandwidth.toString-impl(this.lossLimitedBandwidth) + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.inherentLoss);
            result = result * 31 + Bandwidth.hashCode-impl(this.lossLimitedBandwidth);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChannelParameters)) {
                return false;
            }
            ChannelParameters channelParameters = (ChannelParameters)other;
            if (Double.compare(this.inherentLoss, channelParameters.inherentLoss) != 0) {
                return false;
            }
            return Bandwidth.equals-impl0(this.lossLimitedBandwidth, channelParameters.lossLimitedBandwidth);
        }

        public /* synthetic */ ChannelParameters(double inherentLoss, long lossLimitedBandwidth, DefaultConstructorMarker $constructor_marker) {
            this(inherentLoss, lossLimitedBandwidth);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Companion;", "", "<init>", "()V", "defaultConfig", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Config;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b}\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0097\u0003\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u001c\u001a\u00020\n\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u001e\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u001f\u001a\u00020\u0005\u0012\b\b\u0002\u0010 \u001a\u00020\u0013\u0012\b\b\u0002\u0010!\u001a\u00020\u0005\u0012\b\b\u0002\u0010\"\u001a\u00020\u0005\u0012\b\b\u0002\u0010#\u001a\u00020\u0005\u0012\b\b\u0002\u0010$\u001a\u00020\u0005\u0012\b\b\u0002\u0010%\u001a\u00020\n\u0012\b\b\u0002\u0010&\u001a\u00020\u0003\u0012\b\b\u0002\u0010'\u001a\u00020\u0003\u0012\b\b\u0002\u0010(\u001a\u00020\u0003\u0012\b\b\u0002\u0010)\u001a\u00020\u0017\u0012\b\b\u0002\u0010*\u001a\u00020\u0005\u0012\b\b\u0002\u0010+\u001a\u00020\u0005\u0012\b\b\u0002\u0010,\u001a\u00020\u0003\u0012\b\b\u0002\u0010-\u001a\u00020\n\u0012\b\b\u0002\u0010.\u001a\u00020\u0003\u0012\b\b\u0002\u0010/\u001a\u00020\u0005\u00a2\u0006\u0004\b0\u00101J\u0006\u0010c\u001a\u00020\u0003J\t\u0010d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010g\u001a\u00020\u0005H\u00c6\u0003J\t\u0010h\u001a\u00020\u0005H\u00c6\u0003J\t\u0010i\u001a\u00020\nH\u00c6\u0003J\t\u0010j\u001a\u00020\fH\u00c6\u0003J\t\u0010k\u001a\u00020\u0005H\u00c6\u0003J\t\u0010l\u001a\u00020\u0005H\u00c6\u0003J\t\u0010m\u001a\u00020\u0005H\u00c6\u0003J\t\u0010n\u001a\u00020\u0005H\u00c6\u0003J\t\u0010o\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010p\u001a\u00020\u0013H\u00c6\u0003\u00a2\u0006\u0004\bq\u0010EJ\t\u0010r\u001a\u00020\u0005H\u00c6\u0003J\t\u0010s\u001a\u00020\u0005H\u00c6\u0003J\t\u0010t\u001a\u00020\u0017H\u00c6\u0003J\t\u0010u\u001a\u00020\u0005H\u00c6\u0003J\t\u0010v\u001a\u00020\u0003H\u00c6\u0003J\t\u0010w\u001a\u00020\u0003H\u00c6\u0003J\t\u0010x\u001a\u00020\u0003H\u00c6\u0003J\t\u0010y\u001a\u00020\nH\u00c6\u0003J\t\u0010z\u001a\u00020\u0017H\u00c6\u0003J\t\u0010{\u001a\u00020\u0005H\u00c6\u0003J\t\u0010|\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010}\u001a\u00020\u0013H\u00c6\u0003\u00a2\u0006\u0004\b~\u0010EJ\t\u0010\u007f\u001a\u00020\u0005H\u00c6\u0003J\n\u0010\u0080\u0001\u001a\u00020\u0005H\u00c6\u0003J\n\u0010\u0081\u0001\u001a\u00020\u0005H\u00c6\u0003J\n\u0010\u0082\u0001\u001a\u00020\u0005H\u00c6\u0003J\n\u0010\u0083\u0001\u001a\u00020\nH\u00c6\u0003J\n\u0010\u0084\u0001\u001a\u00020\u0003H\u00c6\u0003J\n\u0010\u0085\u0001\u001a\u00020\u0003H\u00c6\u0003J\n\u0010\u0086\u0001\u001a\u00020\u0003H\u00c6\u0003J\n\u0010\u0087\u0001\u001a\u00020\u0017H\u00c6\u0003J\n\u0010\u0088\u0001\u001a\u00020\u0005H\u00c6\u0003J\n\u0010\u0089\u0001\u001a\u00020\u0005H\u00c6\u0003J\n\u0010\u008a\u0001\u001a\u00020\u0003H\u00c6\u0003J\n\u0010\u008b\u0001\u001a\u00020\nH\u00c6\u0003J\n\u0010\u008c\u0001\u001a\u00020\u0003H\u00c6\u0003J\n\u0010\u008d\u0001\u001a\u00020\u0005H\u00c6\u0003J\u00a3\u0003\u0010\u008e\u0001\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00052\b\b\u0002\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\n2\b\b\u0002\u0010\u001d\u001a\u00020\u00172\b\b\u0002\u0010\u001e\u001a\u00020\u00052\b\b\u0002\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010 \u001a\u00020\u00132\b\b\u0002\u0010!\u001a\u00020\u00052\b\b\u0002\u0010\"\u001a\u00020\u00052\b\b\u0002\u0010#\u001a\u00020\u00052\b\b\u0002\u0010$\u001a\u00020\u00052\b\b\u0002\u0010%\u001a\u00020\n2\b\b\u0002\u0010&\u001a\u00020\u00032\b\b\u0002\u0010'\u001a\u00020\u00032\b\b\u0002\u0010(\u001a\u00020\u00032\b\b\u0002\u0010)\u001a\u00020\u00172\b\b\u0002\u0010*\u001a\u00020\u00052\b\b\u0002\u0010+\u001a\u00020\u00052\b\b\u0002\u0010,\u001a\u00020\u00032\b\b\u0002\u0010-\u001a\u00020\n2\b\b\u0002\u0010.\u001a\u00020\u00032\b\b\u0002\u0010/\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0006\b\u008f\u0001\u0010\u0090\u0001J\u0015\u0010\u0091\u0001\u001a\u00020\u00032\t\u0010\u0092\u0001\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\n\u0010\u0093\u0001\u001a\u00020\u0017H\u00d6\u0001J\u000b\u0010\u0094\u0001\u001a\u00030\u0095\u0001H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00107R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00107R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u00107R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u00107R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u00107R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u00107R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u00107R\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u00107R\u0013\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\n\n\u0002\u0010F\u001a\u0004\bD\u0010ER\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u00107R\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u00107R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u00107R\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u00103R\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u00103R\u0011\u0010\u001b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u00103R\u0011\u0010\u001c\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010<R\u0011\u0010\u001d\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010JR\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u00107R\u0011\u0010\u001f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u00107R\u0013\u0010 \u001a\u00020\u0013\u00a2\u0006\n\n\u0002\u0010F\u001a\u0004\bS\u0010ER\u0011\u0010!\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u00107R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u00107R\u0011\u0010#\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u00107R\u0011\u0010$\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u00107R\u0011\u0010%\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010<R\u0011\u0010&\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u00103R\u0011\u0010'\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u00103R\u0011\u0010(\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u00103R\u0011\u0010)\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010JR\u0011\u0010*\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u00107R\u0011\u0010+\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u00107R\u0011\u0010,\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u00103R\u0011\u0010-\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010<R\u0011\u0010.\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u00103R\u0011\u0010/\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u00107\u00a8\u0006\u0096\u0001"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Config;", "", "enabled", "", "bandwidthRampupUpperBoundFactor", "", "bandwidthRampupUpperBoundFactorInHold", "bandwidthRampupHoldThreshold", "rampupAccelerationMaxFactor", "rampupAccelerationMaxoutTime", "Ljava/time/Duration;", "candidateFactors", "", "higherBandwidthBiasFactor", "higherLogBandwidthBiasFactor", "inherentLossLowerBound", "lossThresholdOfHighBandwidthPreference", "bandwidthPreferenceSmoothingFactor", "inherentLossUpperBoundBandwidthBalance", "Lorg/jitsi/nlj/util/Bandwidth;", "inherentLossUpperBoundOffset", "initialInherentLossEstimate", "newtonIterations", "", "newtonStepSize", "appendAcknowledgedRateCandidate", "appendDelayBasedEstimateCandidate", "appendUpperBoundCandidateInAlr", "observationDurationLowerBound", "observationWindowSize", "sendingRateSmoothingFactor", "instantUpperBoundTemporalWeightFactor", "instantUpperBoundBandwidthBalance", "instantUpperBoundLossOffset", "temporalWeightFactor", "bandwidthBackoffLowerBoundFactor", "maxIncreaseFactor", "delayedIncreaseWindow", "notIncreaseIfInherentLossLessThanAverageLoss", "notUseAckedRateInAlr", "useInStartPhase", "minNumObservations", "lowerBoundByAckedRateFactor", "holdDurationFactor", "useByteLossRate", "paddingDuration", "boundBestCandidate", "medianSendingRateFactor", "<init>", "(ZDDDDLjava/time/Duration;[DDDDDDJDDIDZZZLjava/time/Duration;IDDJDDDDLjava/time/Duration;ZZZIDDZLjava/time/Duration;ZDLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getEnabled", "()Z", "setEnabled", "(Z)V", "getBandwidthRampupUpperBoundFactor", "()D", "getBandwidthRampupUpperBoundFactorInHold", "getBandwidthRampupHoldThreshold", "getRampupAccelerationMaxFactor", "getRampupAccelerationMaxoutTime", "()Ljava/time/Duration;", "getCandidateFactors", "()[D", "getHigherBandwidthBiasFactor", "getHigherLogBandwidthBiasFactor", "getInherentLossLowerBound", "getLossThresholdOfHighBandwidthPreference", "getBandwidthPreferenceSmoothingFactor", "getInherentLossUpperBoundBandwidthBalance-rlWvAKk", "()J", "J", "getInherentLossUpperBoundOffset", "getInitialInherentLossEstimate", "getNewtonIterations", "()I", "getNewtonStepSize", "getAppendAcknowledgedRateCandidate", "getAppendDelayBasedEstimateCandidate", "getAppendUpperBoundCandidateInAlr", "getObservationDurationLowerBound", "getObservationWindowSize", "getSendingRateSmoothingFactor", "getInstantUpperBoundTemporalWeightFactor", "getInstantUpperBoundBandwidthBalance-rlWvAKk", "getInstantUpperBoundLossOffset", "getTemporalWeightFactor", "getBandwidthBackoffLowerBoundFactor", "getMaxIncreaseFactor", "getDelayedIncreaseWindow", "getNotIncreaseIfInherentLossLessThanAverageLoss", "getNotUseAckedRateInAlr", "getUseInStartPhase", "getMinNumObservations", "getLowerBoundByAckedRateFactor", "getHoldDurationFactor", "getUseByteLossRate", "getPaddingDuration", "getBoundBestCandidate", "getMedianSendingRateFactor", "isValid", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component13-rlWvAKk", "component14", "component15", "component16", "component17", "component18", "component19", "component20", "component21", "component22", "component23", "component24", "component25", "component25-rlWvAKk", "component26", "component27", "component28", "component29", "component30", "component31", "component32", "component33", "component34", "component35", "component36", "component37", "component38", "component39", "component40", "copy", "copy-4dTakhU", "(ZDDDDLjava/time/Duration;[DDDDDDJDDIDZZZLjava/time/Duration;IDDJDDDDLjava/time/Duration;ZZZIDDZLjava/time/Duration;ZD)Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Config;", "equals", "other", "hashCode", "toString", "", "jitsi-media-transform"})
    @SourceDebugExtension(value={"SMAP\nLossBasedBweV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LossBasedBweV2.kt\norg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Config\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1190:1\n13030#2,2:1191\n*S KotlinDebug\n*F\n+ 1 LossBasedBweV2.kt\norg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Config\n*L\n549#1:1191,2\n*E\n"})
    public static final class Config {
        private boolean enabled;
        private final double bandwidthRampupUpperBoundFactor;
        private final double bandwidthRampupUpperBoundFactorInHold;
        private final double bandwidthRampupHoldThreshold;
        private final double rampupAccelerationMaxFactor;
        @NotNull
        private final Duration rampupAccelerationMaxoutTime;
        @NotNull
        private final double[] candidateFactors;
        private final double higherBandwidthBiasFactor;
        private final double higherLogBandwidthBiasFactor;
        private final double inherentLossLowerBound;
        private final double lossThresholdOfHighBandwidthPreference;
        private final double bandwidthPreferenceSmoothingFactor;
        private final long inherentLossUpperBoundBandwidthBalance;
        private final double inherentLossUpperBoundOffset;
        private final double initialInherentLossEstimate;
        private final int newtonIterations;
        private final double newtonStepSize;
        private final boolean appendAcknowledgedRateCandidate;
        private final boolean appendDelayBasedEstimateCandidate;
        private final boolean appendUpperBoundCandidateInAlr;
        @NotNull
        private final Duration observationDurationLowerBound;
        private final int observationWindowSize;
        private final double sendingRateSmoothingFactor;
        private final double instantUpperBoundTemporalWeightFactor;
        private final long instantUpperBoundBandwidthBalance;
        private final double instantUpperBoundLossOffset;
        private final double temporalWeightFactor;
        private final double bandwidthBackoffLowerBoundFactor;
        private final double maxIncreaseFactor;
        @NotNull
        private final Duration delayedIncreaseWindow;
        private final boolean notIncreaseIfInherentLossLessThanAverageLoss;
        private final boolean notUseAckedRateInAlr;
        private final boolean useInStartPhase;
        private final int minNumObservations;
        private final double lowerBoundByAckedRateFactor;
        private final double holdDurationFactor;
        private final boolean useByteLossRate;
        @NotNull
        private final Duration paddingDuration;
        private final boolean boundBestCandidate;
        private final double medianSendingRateFactor;

        private Config(boolean enabled2, double bandwidthRampupUpperBoundFactor, double bandwidthRampupUpperBoundFactorInHold, double bandwidthRampupHoldThreshold, double rampupAccelerationMaxFactor, Duration rampupAccelerationMaxoutTime, double[] candidateFactors, double higherBandwidthBiasFactor, double higherLogBandwidthBiasFactor, double inherentLossLowerBound, double lossThresholdOfHighBandwidthPreference, double bandwidthPreferenceSmoothingFactor, long inherentLossUpperBoundBandwidthBalance, double inherentLossUpperBoundOffset, double initialInherentLossEstimate, int newtonIterations, double newtonStepSize, boolean appendAcknowledgedRateCandidate, boolean appendDelayBasedEstimateCandidate, boolean appendUpperBoundCandidateInAlr, Duration observationDurationLowerBound, int observationWindowSize, double sendingRateSmoothingFactor, double instantUpperBoundTemporalWeightFactor, long instantUpperBoundBandwidthBalance, double instantUpperBoundLossOffset, double temporalWeightFactor, double bandwidthBackoffLowerBoundFactor, double maxIncreaseFactor, Duration delayedIncreaseWindow, boolean notIncreaseIfInherentLossLessThanAverageLoss, boolean notUseAckedRateInAlr, boolean useInStartPhase, int minNumObservations, double lowerBoundByAckedRateFactor, double holdDurationFactor, boolean useByteLossRate, Duration paddingDuration, boolean boundBestCandidate, double medianSendingRateFactor) {
            Intrinsics.checkNotNullParameter((Object)rampupAccelerationMaxoutTime, (String)"rampupAccelerationMaxoutTime");
            Intrinsics.checkNotNullParameter((Object)candidateFactors, (String)"candidateFactors");
            Intrinsics.checkNotNullParameter((Object)observationDurationLowerBound, (String)"observationDurationLowerBound");
            Intrinsics.checkNotNullParameter((Object)delayedIncreaseWindow, (String)"delayedIncreaseWindow");
            Intrinsics.checkNotNullParameter((Object)paddingDuration, (String)"paddingDuration");
            this.enabled = enabled2;
            this.bandwidthRampupUpperBoundFactor = bandwidthRampupUpperBoundFactor;
            this.bandwidthRampupUpperBoundFactorInHold = bandwidthRampupUpperBoundFactorInHold;
            this.bandwidthRampupHoldThreshold = bandwidthRampupHoldThreshold;
            this.rampupAccelerationMaxFactor = rampupAccelerationMaxFactor;
            this.rampupAccelerationMaxoutTime = rampupAccelerationMaxoutTime;
            this.candidateFactors = candidateFactors;
            this.higherBandwidthBiasFactor = higherBandwidthBiasFactor;
            this.higherLogBandwidthBiasFactor = higherLogBandwidthBiasFactor;
            this.inherentLossLowerBound = inherentLossLowerBound;
            this.lossThresholdOfHighBandwidthPreference = lossThresholdOfHighBandwidthPreference;
            this.bandwidthPreferenceSmoothingFactor = bandwidthPreferenceSmoothingFactor;
            this.inherentLossUpperBoundBandwidthBalance = inherentLossUpperBoundBandwidthBalance;
            this.inherentLossUpperBoundOffset = inherentLossUpperBoundOffset;
            this.initialInherentLossEstimate = initialInherentLossEstimate;
            this.newtonIterations = newtonIterations;
            this.newtonStepSize = newtonStepSize;
            this.appendAcknowledgedRateCandidate = appendAcknowledgedRateCandidate;
            this.appendDelayBasedEstimateCandidate = appendDelayBasedEstimateCandidate;
            this.appendUpperBoundCandidateInAlr = appendUpperBoundCandidateInAlr;
            this.observationDurationLowerBound = observationDurationLowerBound;
            this.observationWindowSize = observationWindowSize;
            this.sendingRateSmoothingFactor = sendingRateSmoothingFactor;
            this.instantUpperBoundTemporalWeightFactor = instantUpperBoundTemporalWeightFactor;
            this.instantUpperBoundBandwidthBalance = instantUpperBoundBandwidthBalance;
            this.instantUpperBoundLossOffset = instantUpperBoundLossOffset;
            this.temporalWeightFactor = temporalWeightFactor;
            this.bandwidthBackoffLowerBoundFactor = bandwidthBackoffLowerBoundFactor;
            this.maxIncreaseFactor = maxIncreaseFactor;
            this.delayedIncreaseWindow = delayedIncreaseWindow;
            this.notIncreaseIfInherentLossLessThanAverageLoss = notIncreaseIfInherentLossLessThanAverageLoss;
            this.notUseAckedRateInAlr = notUseAckedRateInAlr;
            this.useInStartPhase = useInStartPhase;
            this.minNumObservations = minNumObservations;
            this.lowerBoundByAckedRateFactor = lowerBoundByAckedRateFactor;
            this.holdDurationFactor = holdDurationFactor;
            this.useByteLossRate = useByteLossRate;
            this.paddingDuration = paddingDuration;
            this.boundBestCandidate = boundBestCandidate;
            this.medianSendingRateFactor = medianSendingRateFactor;
        }

        public /* synthetic */ Config(boolean bl, double d, double d2, double d3, double d4, Duration duration, double[] dArray, double d5, double d6, double d7, double d8, double d9, long l, double d10, double d11, int n, double d12, boolean bl2, boolean bl3, boolean bl4, Duration duration2, int n2, double d13, double d14, long l2, double d15, double d16, double d17, double d18, Duration duration3, boolean bl5, boolean bl6, boolean bl7, int n3, double d19, double d20, boolean bl8, Duration duration4, boolean bl9, double d21, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                bl = true;
            }
            if ((n4 & 2) != 0) {
                d = 1.5;
            }
            if ((n4 & 4) != 0) {
                d2 = 1.2;
            }
            if ((n4 & 8) != 0) {
                d3 = 1.3;
            }
            if ((n4 & 0x10) != 0) {
                d4 = 0.0;
            }
            if ((n4 & 0x20) != 0) {
                duration = DurationKt.getSecs((int)60);
            }
            if ((n4 & 0x40) != 0) {
                double[] dArray2 = new double[]{1.02, 1.0, 0.95};
                dArray = dArray2;
            }
            if ((n4 & 0x80) != 0) {
                d5 = 2.0E-4;
            }
            if ((n4 & 0x100) != 0) {
                d6 = 0.02;
            }
            if ((n4 & 0x200) != 0) {
                d7 = 0.001;
            }
            if ((n4 & 0x400) != 0) {
                d8 = 0.2;
            }
            if ((n4 & 0x800) != 0) {
                d9 = 0.002;
            }
            if ((n4 & 0x1000) != 0) {
                l = BandwidthKt.getKbps(100);
            }
            if ((n4 & 0x2000) != 0) {
                d10 = 0.05;
            }
            if ((n4 & 0x4000) != 0) {
                d11 = 0.01;
            }
            if ((n4 & 0x8000) != 0) {
                n = 1;
            }
            if ((n4 & 0x10000) != 0) {
                d12 = 0.75;
            }
            if ((n4 & 0x20000) != 0) {
                bl2 = true;
            }
            if ((n4 & 0x40000) != 0) {
                bl3 = true;
            }
            if ((n4 & 0x80000) != 0) {
                bl4 = false;
            }
            if ((n4 & 0x100000) != 0) {
                duration2 = DurationKt.getMs((int)250);
            }
            if ((n4 & 0x200000) != 0) {
                n2 = 15;
            }
            if ((n4 & 0x400000) != 0) {
                d13 = 0.0;
            }
            if ((n4 & 0x800000) != 0) {
                d14 = 0.9;
            }
            if ((n4 & 0x1000000) != 0) {
                l2 = BandwidthKt.getKbps(100);
            }
            if ((n4 & 0x2000000) != 0) {
                d15 = 0.05;
            }
            if ((n4 & 0x4000000) != 0) {
                d16 = 0.9;
            }
            if ((n4 & 0x8000000) != 0) {
                d17 = 1.0;
            }
            if ((n4 & 0x10000000) != 0) {
                d18 = 1.3;
            }
            if ((n4 & 0x20000000) != 0) {
                duration3 = DurationKt.getMs((int)300);
            }
            if ((n4 & 0x40000000) != 0) {
                bl5 = true;
            }
            if ((n4 & Integer.MIN_VALUE) != 0) {
                bl6 = true;
            }
            if ((n5 & 1) != 0) {
                bl7 = true;
            }
            if ((n5 & 2) != 0) {
                n3 = 3;
            }
            if ((n5 & 4) != 0) {
                d19 = 1.0;
            }
            if ((n5 & 8) != 0) {
                d20 = 2.0;
            }
            if ((n5 & 0x10) != 0) {
                bl8 = true;
            }
            if ((n5 & 0x20) != 0) {
                duration4 = DurationKt.getSecs((int)2);
            }
            if ((n5 & 0x40) != 0) {
                bl9 = true;
            }
            if ((n5 & 0x80) != 0) {
                d21 = 2.0;
            }
            this(bl, d, d2, d3, d4, duration, dArray, d5, d6, d7, d8, d9, l, d10, d11, n, d12, bl2, bl3, bl4, duration2, n2, d13, d14, l2, d15, d16, d17, d18, duration3, bl5, bl6, bl7, n3, d19, d20, bl8, duration4, bl9, d21, null);
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public final double getBandwidthRampupUpperBoundFactor() {
            return this.bandwidthRampupUpperBoundFactor;
        }

        public final double getBandwidthRampupUpperBoundFactorInHold() {
            return this.bandwidthRampupUpperBoundFactorInHold;
        }

        public final double getBandwidthRampupHoldThreshold() {
            return this.bandwidthRampupHoldThreshold;
        }

        public final double getRampupAccelerationMaxFactor() {
            return this.rampupAccelerationMaxFactor;
        }

        @NotNull
        public final Duration getRampupAccelerationMaxoutTime() {
            return this.rampupAccelerationMaxoutTime;
        }

        @NotNull
        public final double[] getCandidateFactors() {
            return this.candidateFactors;
        }

        public final double getHigherBandwidthBiasFactor() {
            return this.higherBandwidthBiasFactor;
        }

        public final double getHigherLogBandwidthBiasFactor() {
            return this.higherLogBandwidthBiasFactor;
        }

        public final double getInherentLossLowerBound() {
            return this.inherentLossLowerBound;
        }

        public final double getLossThresholdOfHighBandwidthPreference() {
            return this.lossThresholdOfHighBandwidthPreference;
        }

        public final double getBandwidthPreferenceSmoothingFactor() {
            return this.bandwidthPreferenceSmoothingFactor;
        }

        public final long getInherentLossUpperBoundBandwidthBalance-rlWvAKk() {
            return this.inherentLossUpperBoundBandwidthBalance;
        }

        public final double getInherentLossUpperBoundOffset() {
            return this.inherentLossUpperBoundOffset;
        }

        public final double getInitialInherentLossEstimate() {
            return this.initialInherentLossEstimate;
        }

        public final int getNewtonIterations() {
            return this.newtonIterations;
        }

        public final double getNewtonStepSize() {
            return this.newtonStepSize;
        }

        public final boolean getAppendAcknowledgedRateCandidate() {
            return this.appendAcknowledgedRateCandidate;
        }

        public final boolean getAppendDelayBasedEstimateCandidate() {
            return this.appendDelayBasedEstimateCandidate;
        }

        public final boolean getAppendUpperBoundCandidateInAlr() {
            return this.appendUpperBoundCandidateInAlr;
        }

        @NotNull
        public final Duration getObservationDurationLowerBound() {
            return this.observationDurationLowerBound;
        }

        public final int getObservationWindowSize() {
            return this.observationWindowSize;
        }

        public final double getSendingRateSmoothingFactor() {
            return this.sendingRateSmoothingFactor;
        }

        public final double getInstantUpperBoundTemporalWeightFactor() {
            return this.instantUpperBoundTemporalWeightFactor;
        }

        public final long getInstantUpperBoundBandwidthBalance-rlWvAKk() {
            return this.instantUpperBoundBandwidthBalance;
        }

        public final double getInstantUpperBoundLossOffset() {
            return this.instantUpperBoundLossOffset;
        }

        public final double getTemporalWeightFactor() {
            return this.temporalWeightFactor;
        }

        public final double getBandwidthBackoffLowerBoundFactor() {
            return this.bandwidthBackoffLowerBoundFactor;
        }

        public final double getMaxIncreaseFactor() {
            return this.maxIncreaseFactor;
        }

        @NotNull
        public final Duration getDelayedIncreaseWindow() {
            return this.delayedIncreaseWindow;
        }

        public final boolean getNotIncreaseIfInherentLossLessThanAverageLoss() {
            return this.notIncreaseIfInherentLossLessThanAverageLoss;
        }

        public final boolean getNotUseAckedRateInAlr() {
            return this.notUseAckedRateInAlr;
        }

        public final boolean getUseInStartPhase() {
            return this.useInStartPhase;
        }

        public final int getMinNumObservations() {
            return this.minNumObservations;
        }

        public final double getLowerBoundByAckedRateFactor() {
            return this.lowerBoundByAckedRateFactor;
        }

        public final double getHoldDurationFactor() {
            return this.holdDurationFactor;
        }

        public final boolean getUseByteLossRate() {
            return this.useByteLossRate;
        }

        @NotNull
        public final Duration getPaddingDuration() {
            return this.paddingDuration;
        }

        public final boolean getBoundBestCandidate() {
            return this.boundBestCandidate;
        }

        public final double getMedianSendingRateFactor() {
            return this.medianSendingRateFactor;
        }

        public final boolean isValid() {
            if (!this.enabled) {
                return false;
            }
            boolean valid = true;
            if (this.bandwidthRampupUpperBoundFactor <= 1.0) {
                Companion.getLogger().warn((Object)("The bandwidth rampup upper bound factor must be greater than 1: " + this.bandwidthRampupUpperBoundFactor));
                valid = false;
            }
            if (this.bandwidthRampupUpperBoundFactorInHold <= 1.0) {
                Companion.getLogger().warn((Object)("The bandwidth rampup upper bound factor in hold must be greater than 1: " + this.bandwidthRampupUpperBoundFactorInHold));
                valid = false;
            }
            if (this.bandwidthRampupHoldThreshold < 0.0) {
                Companion.getLogger().warn((Object)("The bandwidth rampup hold threshold must be non-negative.: " + this.bandwidthRampupHoldThreshold));
                valid = false;
            }
            if (this.rampupAccelerationMaxFactor < 0.0) {
                Companion.getLogger().warn((Object)("The rampup acceleration max factor must be non-negative.: " + this.rampupAccelerationMaxFactor));
                valid = false;
            }
            if (this.rampupAccelerationMaxoutTime.compareTo(Duration.ZERO) <= 0) {
                Companion.getLogger().warn((Object)("The rampup acceleration maxout time must be above zero: " + this.rampupAccelerationMaxoutTime));
                valid = false;
            }
            double[] dArray = this.candidateFactors;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double candidateFactor = dArray[i];
                if (!(candidateFactor <= 0.0)) continue;
                Companion.getLogger().warn((Object)("All candidate factors must be greater than zero: " + candidateFactor));
                valid = false;
            }
            if (!this.appendAcknowledgedRateCandidate && !this.appendDelayBasedEstimateCandidate) {
                boolean bl;
                block31: {
                    double[] $this$any$iv = this.candidateFactors;
                    boolean $i$f$any = false;
                    int n2 = $this$any$iv.length;
                    for (n = 0; n < n2; ++n) {
                        double element$iv;
                        double it = element$iv = $this$any$iv[n];
                        boolean bl2 = false;
                        if (!(!(it == 1.0))) continue;
                        bl = true;
                        break block31;
                    }
                    bl = false;
                }
                if (!bl) {
                    Companion.getLogger().warn((Object)"The configuration does not allow generating candidates. Specify a candidate factor other than 1.0, allow the acknowledged rate to be a candidate, and/or allow the delay based estimate to be a candidate.");
                    valid = false;
                }
            }
            if (this.higherBandwidthBiasFactor < 0.0) {
                Companion.getLogger().warn((Object)("The higher bandwidth bias factor must be non-negative: " + this.higherBandwidthBiasFactor));
                valid = false;
            }
            if (this.inherentLossLowerBound < 0.0 || this.inherentLossLowerBound >= 1.0) {
                Companion.getLogger().warn((Object)("The inherent loss lower bound must be in [0, 1): " + this.inherentLossLowerBound));
                valid = false;
            }
            if (this.lossThresholdOfHighBandwidthPreference < 0.0 || this.lossThresholdOfHighBandwidthPreference >= 1.0) {
                Companion.getLogger().warn((Object)("The loss threshold of high bandwidth preference must be in [0, 1): " + this.lossThresholdOfHighBandwidthPreference));
                valid = false;
            }
            if (this.bandwidthPreferenceSmoothingFactor <= 0.0 || this.bandwidthPreferenceSmoothingFactor > 1.0) {
                Companion.getLogger().warn((Object)("The bandwidth preference smoothing factor must be in (0, 1]: " + this.bandwidthPreferenceSmoothingFactor));
                valid = false;
            }
            if (Bandwidth.compareTo-_2icLw0(this.inherentLossUpperBoundBandwidthBalance, Bandwidth.Companion.getZERO-rlWvAKk()) <= 0) {
                Companion.getLogger().warn((Object)("The inherent loss upper bound bandwidth balance must be positive: " + Bandwidth.toString-impl(this.inherentLossUpperBoundBandwidthBalance)));
                valid = false;
            }
            if (this.inherentLossUpperBoundOffset < this.inherentLossLowerBound || this.inherentLossUpperBoundOffset >= 1.0) {
                Companion.getLogger().warn((Object)("The inherent loss upper bound must be greater than or equal to the inherent loss lower bound, which is " + this.inherentLossLowerBound + ", and less than 1: " + this.inherentLossUpperBoundOffset));
                valid = false;
            }
            if (this.initialInherentLossEstimate < 0.0 || this.initialInherentLossEstimate >= 1.0) {
                Companion.getLogger().warn((Object)("The initial inherent loss estimate must be in [0, 1): " + this.initialInherentLossEstimate));
                valid = false;
            }
            if (this.newtonIterations <= 0) {
                Companion.getLogger().warn((Object)("The number of Newton iterations must be positive: " + this.newtonIterations));
                valid = false;
            }
            if (this.newtonStepSize <= 0.0) {
                Companion.getLogger().warn((Object)("The Newton step size must be positive: " + this.newtonStepSize));
                valid = false;
            }
            if (this.observationDurationLowerBound.compareTo(Duration.ZERO) <= 0) {
                Companion.getLogger().warn((Object)("The observation duration lower bound must be positive: " + this.observationDurationLowerBound));
                valid = false;
            }
            if (this.observationWindowSize < 2) {
                Companion.getLogger().warn((Object)("The observation window size must be at least 2: " + this.observationWindowSize));
                valid = false;
            }
            if (this.sendingRateSmoothingFactor < 0.0 || this.sendingRateSmoothingFactor >= 1.0) {
                Companion.getLogger().warn((Object)("The sending rate smoothing factor must be in [0, 1): " + this.sendingRateSmoothingFactor));
                valid = false;
            }
            if (this.instantUpperBoundTemporalWeightFactor <= 0.0 || this.instantUpperBoundTemporalWeightFactor > 1.0) {
                Companion.getLogger().warn((Object)("The instant upper bound temporal weight factor must be in (0, 1]: " + this.instantUpperBoundTemporalWeightFactor));
                valid = false;
            }
            if (Bandwidth.compareTo-_2icLw0(this.instantUpperBoundBandwidthBalance, Bandwidth.Companion.getZERO-rlWvAKk()) <= 0) {
                Companion.getLogger().warn((Object)("The instant upper bound bandwidth balance must be positive: " + Bandwidth.toString-impl(this.instantUpperBoundBandwidthBalance)));
                valid = false;
            }
            if (this.instantUpperBoundLossOffset < 0.0 || this.instantUpperBoundLossOffset >= 1.0) {
                Companion.getLogger().warn((Object)("The instant upper bound loss offset must be in [0, 1): " + this.instantUpperBoundLossOffset));
                valid = false;
            }
            if (this.temporalWeightFactor <= 0.0 || this.temporalWeightFactor > 1.0) {
                Companion.getLogger().warn((Object)("The temporal weight factor must be in (0, 1]: " + this.temporalWeightFactor));
                valid = false;
            }
            if (this.bandwidthBackoffLowerBoundFactor > 1.0) {
                Companion.getLogger().warn((Object)("The bandwidth backoff lower bound factor must not be greater than 1: " + this.bandwidthBackoffLowerBoundFactor));
                valid = false;
            }
            if (this.maxIncreaseFactor <= 0.0) {
                Companion.getLogger().warn((Object)("The maximum increase factor must be positive: " + this.maxIncreaseFactor));
                valid = false;
            }
            if (this.delayedIncreaseWindow.compareTo(Duration.ZERO) <= 0) {
                Companion.getLogger().warn((Object)("The delayed increase window must be positive: " + this.delayedIncreaseWindow));
                valid = false;
            }
            if (this.minNumObservations <= 0) {
                Companion.getLogger().warn((Object)("The min number of observations must be positive: " + this.minNumObservations));
                valid = false;
            }
            if (this.lowerBoundByAckedRateFactor < 0.0) {
                Companion.getLogger().warn((Object)("The estimate lower bound by acknowledged rate factor must be non-negative: " + this.lowerBoundByAckedRateFactor));
                valid = false;
            }
            return valid;
        }

        public final boolean component1() {
            return this.enabled;
        }

        public final double component2() {
            return this.bandwidthRampupUpperBoundFactor;
        }

        public final double component3() {
            return this.bandwidthRampupUpperBoundFactorInHold;
        }

        public final double component4() {
            return this.bandwidthRampupHoldThreshold;
        }

        public final double component5() {
            return this.rampupAccelerationMaxFactor;
        }

        @NotNull
        public final Duration component6() {
            return this.rampupAccelerationMaxoutTime;
        }

        @NotNull
        public final double[] component7() {
            return this.candidateFactors;
        }

        public final double component8() {
            return this.higherBandwidthBiasFactor;
        }

        public final double component9() {
            return this.higherLogBandwidthBiasFactor;
        }

        public final double component10() {
            return this.inherentLossLowerBound;
        }

        public final double component11() {
            return this.lossThresholdOfHighBandwidthPreference;
        }

        public final double component12() {
            return this.bandwidthPreferenceSmoothingFactor;
        }

        public final long component13-rlWvAKk() {
            return this.inherentLossUpperBoundBandwidthBalance;
        }

        public final double component14() {
            return this.inherentLossUpperBoundOffset;
        }

        public final double component15() {
            return this.initialInherentLossEstimate;
        }

        public final int component16() {
            return this.newtonIterations;
        }

        public final double component17() {
            return this.newtonStepSize;
        }

        public final boolean component18() {
            return this.appendAcknowledgedRateCandidate;
        }

        public final boolean component19() {
            return this.appendDelayBasedEstimateCandidate;
        }

        public final boolean component20() {
            return this.appendUpperBoundCandidateInAlr;
        }

        @NotNull
        public final Duration component21() {
            return this.observationDurationLowerBound;
        }

        public final int component22() {
            return this.observationWindowSize;
        }

        public final double component23() {
            return this.sendingRateSmoothingFactor;
        }

        public final double component24() {
            return this.instantUpperBoundTemporalWeightFactor;
        }

        public final long component25-rlWvAKk() {
            return this.instantUpperBoundBandwidthBalance;
        }

        public final double component26() {
            return this.instantUpperBoundLossOffset;
        }

        public final double component27() {
            return this.temporalWeightFactor;
        }

        public final double component28() {
            return this.bandwidthBackoffLowerBoundFactor;
        }

        public final double component29() {
            return this.maxIncreaseFactor;
        }

        @NotNull
        public final Duration component30() {
            return this.delayedIncreaseWindow;
        }

        public final boolean component31() {
            return this.notIncreaseIfInherentLossLessThanAverageLoss;
        }

        public final boolean component32() {
            return this.notUseAckedRateInAlr;
        }

        public final boolean component33() {
            return this.useInStartPhase;
        }

        public final int component34() {
            return this.minNumObservations;
        }

        public final double component35() {
            return this.lowerBoundByAckedRateFactor;
        }

        public final double component36() {
            return this.holdDurationFactor;
        }

        public final boolean component37() {
            return this.useByteLossRate;
        }

        @NotNull
        public final Duration component38() {
            return this.paddingDuration;
        }

        public final boolean component39() {
            return this.boundBestCandidate;
        }

        public final double component40() {
            return this.medianSendingRateFactor;
        }

        @NotNull
        public final Config copy-4dTakhU(boolean enabled2, double bandwidthRampupUpperBoundFactor, double bandwidthRampupUpperBoundFactorInHold, double bandwidthRampupHoldThreshold, double rampupAccelerationMaxFactor, @NotNull Duration rampupAccelerationMaxoutTime, @NotNull double[] candidateFactors, double higherBandwidthBiasFactor, double higherLogBandwidthBiasFactor, double inherentLossLowerBound, double lossThresholdOfHighBandwidthPreference, double bandwidthPreferenceSmoothingFactor, long l, double inherentLossUpperBoundOffset, double initialInherentLossEstimate, int newtonIterations, double newtonStepSize, boolean appendAcknowledgedRateCandidate, boolean appendDelayBasedEstimateCandidate, boolean appendUpperBoundCandidateInAlr, @NotNull Duration observationDurationLowerBound, int observationWindowSize, double sendingRateSmoothingFactor, double instantUpperBoundTemporalWeightFactor, long l2, double instantUpperBoundLossOffset, double temporalWeightFactor, double bandwidthBackoffLowerBoundFactor, double maxIncreaseFactor, @NotNull Duration delayedIncreaseWindow, boolean notIncreaseIfInherentLossLessThanAverageLoss, boolean notUseAckedRateInAlr, boolean useInStartPhase, int minNumObservations, double lowerBoundByAckedRateFactor, double holdDurationFactor, boolean useByteLossRate, @NotNull Duration paddingDuration, boolean boundBestCandidate, double medianSendingRateFactor) {
            Intrinsics.checkNotNullParameter((Object)rampupAccelerationMaxoutTime, (String)"rampupAccelerationMaxoutTime");
            Intrinsics.checkNotNullParameter((Object)candidateFactors, (String)"candidateFactors");
            Intrinsics.checkNotNullParameter((Object)observationDurationLowerBound, (String)"observationDurationLowerBound");
            Intrinsics.checkNotNullParameter((Object)delayedIncreaseWindow, (String)"delayedIncreaseWindow");
            Intrinsics.checkNotNullParameter((Object)paddingDuration, (String)"paddingDuration");
            return new Config(enabled2, bandwidthRampupUpperBoundFactor, bandwidthRampupUpperBoundFactorInHold, bandwidthRampupHoldThreshold, rampupAccelerationMaxFactor, rampupAccelerationMaxoutTime, candidateFactors, higherBandwidthBiasFactor, higherLogBandwidthBiasFactor, inherentLossLowerBound, lossThresholdOfHighBandwidthPreference, bandwidthPreferenceSmoothingFactor, l, inherentLossUpperBoundOffset, initialInherentLossEstimate, newtonIterations, newtonStepSize, appendAcknowledgedRateCandidate, appendDelayBasedEstimateCandidate, appendUpperBoundCandidateInAlr, observationDurationLowerBound, observationWindowSize, sendingRateSmoothingFactor, instantUpperBoundTemporalWeightFactor, l2, instantUpperBoundLossOffset, temporalWeightFactor, bandwidthBackoffLowerBoundFactor, maxIncreaseFactor, delayedIncreaseWindow, notIncreaseIfInherentLossLessThanAverageLoss, notUseAckedRateInAlr, useInStartPhase, minNumObservations, lowerBoundByAckedRateFactor, holdDurationFactor, useByteLossRate, paddingDuration, boundBestCandidate, medianSendingRateFactor, null);
        }

        public static /* synthetic */ Config copy-4dTakhU$default(Config config, boolean bl, double d, double d2, double d3, double d4, Duration duration, double[] dArray, double d5, double d6, double d7, double d8, double d9, long l, double d10, double d11, int n, double d12, boolean bl2, boolean bl3, boolean bl4, Duration duration2, int n2, double d13, double d14, long l2, double d15, double d16, double d17, double d18, Duration duration3, boolean bl5, boolean bl6, boolean bl7, int n3, double d19, double d20, boolean bl8, Duration duration4, boolean bl9, double d21, int n4, int n5, Object object) {
            if ((n4 & 1) != 0) {
                bl = config.enabled;
            }
            if ((n4 & 2) != 0) {
                d = config.bandwidthRampupUpperBoundFactor;
            }
            if ((n4 & 4) != 0) {
                d2 = config.bandwidthRampupUpperBoundFactorInHold;
            }
            if ((n4 & 8) != 0) {
                d3 = config.bandwidthRampupHoldThreshold;
            }
            if ((n4 & 0x10) != 0) {
                d4 = config.rampupAccelerationMaxFactor;
            }
            if ((n4 & 0x20) != 0) {
                duration = config.rampupAccelerationMaxoutTime;
            }
            if ((n4 & 0x40) != 0) {
                dArray = config.candidateFactors;
            }
            if ((n4 & 0x80) != 0) {
                d5 = config.higherBandwidthBiasFactor;
            }
            if ((n4 & 0x100) != 0) {
                d6 = config.higherLogBandwidthBiasFactor;
            }
            if ((n4 & 0x200) != 0) {
                d7 = config.inherentLossLowerBound;
            }
            if ((n4 & 0x400) != 0) {
                d8 = config.lossThresholdOfHighBandwidthPreference;
            }
            if ((n4 & 0x800) != 0) {
                d9 = config.bandwidthPreferenceSmoothingFactor;
            }
            if ((n4 & 0x1000) != 0) {
                l = config.inherentLossUpperBoundBandwidthBalance;
            }
            if ((n4 & 0x2000) != 0) {
                d10 = config.inherentLossUpperBoundOffset;
            }
            if ((n4 & 0x4000) != 0) {
                d11 = config.initialInherentLossEstimate;
            }
            if ((n4 & 0x8000) != 0) {
                n = config.newtonIterations;
            }
            if ((n4 & 0x10000) != 0) {
                d12 = config.newtonStepSize;
            }
            if ((n4 & 0x20000) != 0) {
                bl2 = config.appendAcknowledgedRateCandidate;
            }
            if ((n4 & 0x40000) != 0) {
                bl3 = config.appendDelayBasedEstimateCandidate;
            }
            if ((n4 & 0x80000) != 0) {
                bl4 = config.appendUpperBoundCandidateInAlr;
            }
            if ((n4 & 0x100000) != 0) {
                duration2 = config.observationDurationLowerBound;
            }
            if ((n4 & 0x200000) != 0) {
                n2 = config.observationWindowSize;
            }
            if ((n4 & 0x400000) != 0) {
                d13 = config.sendingRateSmoothingFactor;
            }
            if ((n4 & 0x800000) != 0) {
                d14 = config.instantUpperBoundTemporalWeightFactor;
            }
            if ((n4 & 0x1000000) != 0) {
                l2 = config.instantUpperBoundBandwidthBalance;
            }
            if ((n4 & 0x2000000) != 0) {
                d15 = config.instantUpperBoundLossOffset;
            }
            if ((n4 & 0x4000000) != 0) {
                d16 = config.temporalWeightFactor;
            }
            if ((n4 & 0x8000000) != 0) {
                d17 = config.bandwidthBackoffLowerBoundFactor;
            }
            if ((n4 & 0x10000000) != 0) {
                d18 = config.maxIncreaseFactor;
            }
            if ((n4 & 0x20000000) != 0) {
                duration3 = config.delayedIncreaseWindow;
            }
            if ((n4 & 0x40000000) != 0) {
                bl5 = config.notIncreaseIfInherentLossLessThanAverageLoss;
            }
            if ((n4 & Integer.MIN_VALUE) != 0) {
                bl6 = config.notUseAckedRateInAlr;
            }
            if ((n5 & 1) != 0) {
                bl7 = config.useInStartPhase;
            }
            if ((n5 & 2) != 0) {
                n3 = config.minNumObservations;
            }
            if ((n5 & 4) != 0) {
                d19 = config.lowerBoundByAckedRateFactor;
            }
            if ((n5 & 8) != 0) {
                d20 = config.holdDurationFactor;
            }
            if ((n5 & 0x10) != 0) {
                bl8 = config.useByteLossRate;
            }
            if ((n5 & 0x20) != 0) {
                duration4 = config.paddingDuration;
            }
            if ((n5 & 0x40) != 0) {
                bl9 = config.boundBestCandidate;
            }
            if ((n5 & 0x80) != 0) {
                d21 = config.medianSendingRateFactor;
            }
            return config.copy-4dTakhU(bl, d, d2, d3, d4, duration, dArray, d5, d6, d7, d8, d9, l, d10, d11, n, d12, bl2, bl3, bl4, duration2, n2, d13, d14, l2, d15, d16, d17, d18, duration3, bl5, bl6, bl7, n3, d19, d20, bl8, duration4, bl9, d21);
        }

        @NotNull
        public String toString() {
            return "Config(enabled=" + this.enabled + ", bandwidthRampupUpperBoundFactor=" + this.bandwidthRampupUpperBoundFactor + ", bandwidthRampupUpperBoundFactorInHold=" + this.bandwidthRampupUpperBoundFactorInHold + ", bandwidthRampupHoldThreshold=" + this.bandwidthRampupHoldThreshold + ", rampupAccelerationMaxFactor=" + this.rampupAccelerationMaxFactor + ", rampupAccelerationMaxoutTime=" + this.rampupAccelerationMaxoutTime + ", candidateFactors=" + Arrays.toString(this.candidateFactors) + ", higherBandwidthBiasFactor=" + this.higherBandwidthBiasFactor + ", higherLogBandwidthBiasFactor=" + this.higherLogBandwidthBiasFactor + ", inherentLossLowerBound=" + this.inherentLossLowerBound + ", lossThresholdOfHighBandwidthPreference=" + this.lossThresholdOfHighBandwidthPreference + ", bandwidthPreferenceSmoothingFactor=" + this.bandwidthPreferenceSmoothingFactor + ", inherentLossUpperBoundBandwidthBalance=" + Bandwidth.toString-impl(this.inherentLossUpperBoundBandwidthBalance) + ", inherentLossUpperBoundOffset=" + this.inherentLossUpperBoundOffset + ", initialInherentLossEstimate=" + this.initialInherentLossEstimate + ", newtonIterations=" + this.newtonIterations + ", newtonStepSize=" + this.newtonStepSize + ", appendAcknowledgedRateCandidate=" + this.appendAcknowledgedRateCandidate + ", appendDelayBasedEstimateCandidate=" + this.appendDelayBasedEstimateCandidate + ", appendUpperBoundCandidateInAlr=" + this.appendUpperBoundCandidateInAlr + ", observationDurationLowerBound=" + this.observationDurationLowerBound + ", observationWindowSize=" + this.observationWindowSize + ", sendingRateSmoothingFactor=" + this.sendingRateSmoothingFactor + ", instantUpperBoundTemporalWeightFactor=" + this.instantUpperBoundTemporalWeightFactor + ", instantUpperBoundBandwidthBalance=" + Bandwidth.toString-impl(this.instantUpperBoundBandwidthBalance) + ", instantUpperBoundLossOffset=" + this.instantUpperBoundLossOffset + ", temporalWeightFactor=" + this.temporalWeightFactor + ", bandwidthBackoffLowerBoundFactor=" + this.bandwidthBackoffLowerBoundFactor + ", maxIncreaseFactor=" + this.maxIncreaseFactor + ", delayedIncreaseWindow=" + this.delayedIncreaseWindow + ", notIncreaseIfInherentLossLessThanAverageLoss=" + this.notIncreaseIfInherentLossLessThanAverageLoss + ", notUseAckedRateInAlr=" + this.notUseAckedRateInAlr + ", useInStartPhase=" + this.useInStartPhase + ", minNumObservations=" + this.minNumObservations + ", lowerBoundByAckedRateFactor=" + this.lowerBoundByAckedRateFactor + ", holdDurationFactor=" + this.holdDurationFactor + ", useByteLossRate=" + this.useByteLossRate + ", paddingDuration=" + this.paddingDuration + ", boundBestCandidate=" + this.boundBestCandidate + ", medianSendingRateFactor=" + this.medianSendingRateFactor + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.enabled);
            result = result * 31 + Double.hashCode(this.bandwidthRampupUpperBoundFactor);
            result = result * 31 + Double.hashCode(this.bandwidthRampupUpperBoundFactorInHold);
            result = result * 31 + Double.hashCode(this.bandwidthRampupHoldThreshold);
            result = result * 31 + Double.hashCode(this.rampupAccelerationMaxFactor);
            result = result * 31 + this.rampupAccelerationMaxoutTime.hashCode();
            result = result * 31 + Arrays.hashCode(this.candidateFactors);
            result = result * 31 + Double.hashCode(this.higherBandwidthBiasFactor);
            result = result * 31 + Double.hashCode(this.higherLogBandwidthBiasFactor);
            result = result * 31 + Double.hashCode(this.inherentLossLowerBound);
            result = result * 31 + Double.hashCode(this.lossThresholdOfHighBandwidthPreference);
            result = result * 31 + Double.hashCode(this.bandwidthPreferenceSmoothingFactor);
            result = result * 31 + Bandwidth.hashCode-impl(this.inherentLossUpperBoundBandwidthBalance);
            result = result * 31 + Double.hashCode(this.inherentLossUpperBoundOffset);
            result = result * 31 + Double.hashCode(this.initialInherentLossEstimate);
            result = result * 31 + Integer.hashCode(this.newtonIterations);
            result = result * 31 + Double.hashCode(this.newtonStepSize);
            result = result * 31 + Boolean.hashCode(this.appendAcknowledgedRateCandidate);
            result = result * 31 + Boolean.hashCode(this.appendDelayBasedEstimateCandidate);
            result = result * 31 + Boolean.hashCode(this.appendUpperBoundCandidateInAlr);
            result = result * 31 + this.observationDurationLowerBound.hashCode();
            result = result * 31 + Integer.hashCode(this.observationWindowSize);
            result = result * 31 + Double.hashCode(this.sendingRateSmoothingFactor);
            result = result * 31 + Double.hashCode(this.instantUpperBoundTemporalWeightFactor);
            result = result * 31 + Bandwidth.hashCode-impl(this.instantUpperBoundBandwidthBalance);
            result = result * 31 + Double.hashCode(this.instantUpperBoundLossOffset);
            result = result * 31 + Double.hashCode(this.temporalWeightFactor);
            result = result * 31 + Double.hashCode(this.bandwidthBackoffLowerBoundFactor);
            result = result * 31 + Double.hashCode(this.maxIncreaseFactor);
            result = result * 31 + this.delayedIncreaseWindow.hashCode();
            result = result * 31 + Boolean.hashCode(this.notIncreaseIfInherentLossLessThanAverageLoss);
            result = result * 31 + Boolean.hashCode(this.notUseAckedRateInAlr);
            result = result * 31 + Boolean.hashCode(this.useInStartPhase);
            result = result * 31 + Integer.hashCode(this.minNumObservations);
            result = result * 31 + Double.hashCode(this.lowerBoundByAckedRateFactor);
            result = result * 31 + Double.hashCode(this.holdDurationFactor);
            result = result * 31 + Boolean.hashCode(this.useByteLossRate);
            result = result * 31 + this.paddingDuration.hashCode();
            result = result * 31 + Boolean.hashCode(this.boundBestCandidate);
            result = result * 31 + Double.hashCode(this.medianSendingRateFactor);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            if (this.enabled != config.enabled) {
                return false;
            }
            if (Double.compare(this.bandwidthRampupUpperBoundFactor, config.bandwidthRampupUpperBoundFactor) != 0) {
                return false;
            }
            if (Double.compare(this.bandwidthRampupUpperBoundFactorInHold, config.bandwidthRampupUpperBoundFactorInHold) != 0) {
                return false;
            }
            if (Double.compare(this.bandwidthRampupHoldThreshold, config.bandwidthRampupHoldThreshold) != 0) {
                return false;
            }
            if (Double.compare(this.rampupAccelerationMaxFactor, config.rampupAccelerationMaxFactor) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rampupAccelerationMaxoutTime, (Object)config.rampupAccelerationMaxoutTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.candidateFactors, (Object)config.candidateFactors)) {
                return false;
            }
            if (Double.compare(this.higherBandwidthBiasFactor, config.higherBandwidthBiasFactor) != 0) {
                return false;
            }
            if (Double.compare(this.higherLogBandwidthBiasFactor, config.higherLogBandwidthBiasFactor) != 0) {
                return false;
            }
            if (Double.compare(this.inherentLossLowerBound, config.inherentLossLowerBound) != 0) {
                return false;
            }
            if (Double.compare(this.lossThresholdOfHighBandwidthPreference, config.lossThresholdOfHighBandwidthPreference) != 0) {
                return false;
            }
            if (Double.compare(this.bandwidthPreferenceSmoothingFactor, config.bandwidthPreferenceSmoothingFactor) != 0) {
                return false;
            }
            if (!Bandwidth.equals-impl0(this.inherentLossUpperBoundBandwidthBalance, config.inherentLossUpperBoundBandwidthBalance)) {
                return false;
            }
            if (Double.compare(this.inherentLossUpperBoundOffset, config.inherentLossUpperBoundOffset) != 0) {
                return false;
            }
            if (Double.compare(this.initialInherentLossEstimate, config.initialInherentLossEstimate) != 0) {
                return false;
            }
            if (this.newtonIterations != config.newtonIterations) {
                return false;
            }
            if (Double.compare(this.newtonStepSize, config.newtonStepSize) != 0) {
                return false;
            }
            if (this.appendAcknowledgedRateCandidate != config.appendAcknowledgedRateCandidate) {
                return false;
            }
            if (this.appendDelayBasedEstimateCandidate != config.appendDelayBasedEstimateCandidate) {
                return false;
            }
            if (this.appendUpperBoundCandidateInAlr != config.appendUpperBoundCandidateInAlr) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.observationDurationLowerBound, (Object)config.observationDurationLowerBound)) {
                return false;
            }
            if (this.observationWindowSize != config.observationWindowSize) {
                return false;
            }
            if (Double.compare(this.sendingRateSmoothingFactor, config.sendingRateSmoothingFactor) != 0) {
                return false;
            }
            if (Double.compare(this.instantUpperBoundTemporalWeightFactor, config.instantUpperBoundTemporalWeightFactor) != 0) {
                return false;
            }
            if (!Bandwidth.equals-impl0(this.instantUpperBoundBandwidthBalance, config.instantUpperBoundBandwidthBalance)) {
                return false;
            }
            if (Double.compare(this.instantUpperBoundLossOffset, config.instantUpperBoundLossOffset) != 0) {
                return false;
            }
            if (Double.compare(this.temporalWeightFactor, config.temporalWeightFactor) != 0) {
                return false;
            }
            if (Double.compare(this.bandwidthBackoffLowerBoundFactor, config.bandwidthBackoffLowerBoundFactor) != 0) {
                return false;
            }
            if (Double.compare(this.maxIncreaseFactor, config.maxIncreaseFactor) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.delayedIncreaseWindow, (Object)config.delayedIncreaseWindow)) {
                return false;
            }
            if (this.notIncreaseIfInherentLossLessThanAverageLoss != config.notIncreaseIfInherentLossLessThanAverageLoss) {
                return false;
            }
            if (this.notUseAckedRateInAlr != config.notUseAckedRateInAlr) {
                return false;
            }
            if (this.useInStartPhase != config.useInStartPhase) {
                return false;
            }
            if (this.minNumObservations != config.minNumObservations) {
                return false;
            }
            if (Double.compare(this.lowerBoundByAckedRateFactor, config.lowerBoundByAckedRateFactor) != 0) {
                return false;
            }
            if (Double.compare(this.holdDurationFactor, config.holdDurationFactor) != 0) {
                return false;
            }
            if (this.useByteLossRate != config.useByteLossRate) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.paddingDuration, (Object)config.paddingDuration)) {
                return false;
            }
            if (this.boundBestCandidate != config.boundBestCandidate) {
                return false;
            }
            return Double.compare(this.medianSendingRateFactor, config.medianSendingRateFactor) == 0;
        }

        public /* synthetic */ Config(boolean enabled2, double bandwidthRampupUpperBoundFactor, double bandwidthRampupUpperBoundFactorInHold, double bandwidthRampupHoldThreshold, double rampupAccelerationMaxFactor, Duration rampupAccelerationMaxoutTime, double[] candidateFactors, double higherBandwidthBiasFactor, double higherLogBandwidthBiasFactor, double inherentLossLowerBound, double lossThresholdOfHighBandwidthPreference, double bandwidthPreferenceSmoothingFactor, long inherentLossUpperBoundBandwidthBalance, double inherentLossUpperBoundOffset, double initialInherentLossEstimate, int newtonIterations, double newtonStepSize, boolean appendAcknowledgedRateCandidate, boolean appendDelayBasedEstimateCandidate, boolean appendUpperBoundCandidateInAlr, Duration observationDurationLowerBound, int observationWindowSize, double sendingRateSmoothingFactor, double instantUpperBoundTemporalWeightFactor, long instantUpperBoundBandwidthBalance, double instantUpperBoundLossOffset, double temporalWeightFactor, double bandwidthBackoffLowerBoundFactor, double maxIncreaseFactor, Duration delayedIncreaseWindow, boolean notIncreaseIfInherentLossLessThanAverageLoss, boolean notUseAckedRateInAlr, boolean useInStartPhase, int minNumObservations, double lowerBoundByAckedRateFactor, double holdDurationFactor, boolean useByteLossRate, Duration paddingDuration, boolean boundBestCandidate, double medianSendingRateFactor, DefaultConstructorMarker $constructor_marker) {
            this(enabled2, bandwidthRampupUpperBoundFactor, bandwidthRampupUpperBoundFactorInHold, bandwidthRampupHoldThreshold, rampupAccelerationMaxFactor, rampupAccelerationMaxoutTime, candidateFactors, higherBandwidthBiasFactor, higherLogBandwidthBiasFactor, inherentLossLowerBound, lossThresholdOfHighBandwidthPreference, bandwidthPreferenceSmoothingFactor, inherentLossUpperBoundBandwidthBalance, inherentLossUpperBoundOffset, initialInherentLossEstimate, newtonIterations, newtonStepSize, appendAcknowledgedRateCandidate, appendDelayBasedEstimateCandidate, appendUpperBoundCandidateInAlr, observationDurationLowerBound, observationWindowSize, sendingRateSmoothingFactor, instantUpperBoundTemporalWeightFactor, instantUpperBoundBandwidthBalance, instantUpperBoundLossOffset, temporalWeightFactor, bandwidthBackoffLowerBoundFactor, maxIncreaseFactor, delayedIncreaseWindow, notIncreaseIfInherentLossLessThanAverageLoss, notUseAckedRateInAlr, useInStartPhase, minNumObservations, lowerBoundByAckedRateFactor, holdDurationFactor, useByteLossRate, paddingDuration, boundBestCandidate, medianSendingRateFactor);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Derivatives;", "", "first", "", "second", "<init>", "(DD)V", "getFirst", "()D", "setFirst", "(D)V", "getSecond", "setSecond", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-media-transform"})
    private static final class Derivatives {
        private double first;
        private double second;

        public Derivatives(double first, double second) {
            this.first = first;
            this.second = second;
        }

        public /* synthetic */ Derivatives(double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                d = 0.0;
            }
            if ((n & 2) != 0) {
                d2 = 0.0;
            }
            this(d, d2);
        }

        public final double getFirst() {
            return this.first;
        }

        public final void setFirst(double d) {
            this.first = d;
        }

        public final double getSecond() {
            return this.second;
        }

        public final void setSecond(double d) {
            this.second = d;
        }

        public final double component1() {
            return this.first;
        }

        public final double component2() {
            return this.second;
        }

        @NotNull
        public final Derivatives copy(double first, double second) {
            return new Derivatives(first, second);
        }

        public static /* synthetic */ Derivatives copy$default(Derivatives derivatives, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                d = derivatives.first;
            }
            if ((n & 2) != 0) {
                d2 = derivatives.second;
            }
            return derivatives.copy(d, d2);
        }

        @NotNull
        public String toString() {
            return "Derivatives(first=" + this.first + ", second=" + this.second + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.first);
            result = result * 31 + Double.hashCode(this.second);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Derivatives)) {
                return false;
            }
            Derivatives derivatives = (Derivatives)other;
            if (Double.compare(this.first, derivatives.first) != 0) {
                return false;
            }
            return Double.compare(this.second, derivatives.second) == 0;
        }

        public Derivatives() {
            this(0.0, 0.0, 3, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0002\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$HoldInfo;", "", "timestamp", "Ljava/time/Instant;", "duration", "Ljava/time/Duration;", "rate", "Lorg/jitsi/nlj/util/Bandwidth;", "<init>", "(Ljava/time/Instant;Ljava/time/Duration;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getTimestamp", "()Ljava/time/Instant;", "setTimestamp", "(Ljava/time/Instant;)V", "getDuration", "()Ljava/time/Duration;", "setDuration", "(Ljava/time/Duration;)V", "getRate-rlWvAKk", "()J", "setRate-_2icLw0", "(J)V", "J", "jitsi-media-transform"})
    private static final class HoldInfo {
        @NotNull
        private Instant timestamp;
        @NotNull
        private Duration duration;
        private long rate;

        private HoldInfo(Instant timestamp, Duration duration, long rate) {
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            this.timestamp = timestamp;
            this.duration = duration;
            this.rate = rate;
        }

        public /* synthetic */ HoldInfo(Instant instant, Duration duration, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                Instant instant2 = Instant.MIN;
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"MIN");
                instant = instant2;
            }
            if ((n & 2) != 0) {
                Duration duration2 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
                duration = duration2;
            }
            if ((n & 4) != 0) {
                l = Bandwidth.Companion.getINFINITY-rlWvAKk();
            }
            this(instant, duration, l, null);
        }

        @NotNull
        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.timestamp = instant;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        public final void setDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.duration = duration;
        }

        public final long getRate-rlWvAKk() {
            return this.rate;
        }

        public final void setRate-_2icLw0(long l) {
            this.rate = l;
        }

        public /* synthetic */ HoldInfo(Instant timestamp, Duration duration, long rate, DefaultConstructorMarker $constructor_marker) {
            this(timestamp, duration, rate);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010#\u001a\u00020$R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001c\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0007\"\u0004\b\"\u0010\t\u00a8\u0006%"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Observation;", "", "<init>", "()V", "numPackets", "", "getNumPackets", "()I", "setNumPackets", "(I)V", "numLostPackets", "getNumLostPackets", "setNumLostPackets", "numReceivedPackets", "getNumReceivedPackets", "setNumReceivedPackets", "sendingRate", "Lorg/jitsi/nlj/util/Bandwidth;", "getSendingRate-rlWvAKk", "()J", "setSendingRate-_2icLw0", "(J)V", "J", "size", "Lorg/jitsi/nlj/util/DataSize;", "getSize", "()Lorg/jitsi/nlj/util/DataSize;", "setSize", "(Lorg/jitsi/nlj/util/DataSize;)V", "lostSize", "getLostSize", "setLostSize", "id", "getId", "setId", "isInitialized", "", "jitsi-media-transform"})
    private static final class Observation {
        private int numPackets;
        private int numLostPackets;
        private int numReceivedPackets;
        private long sendingRate = Bandwidth.Companion.getMINUS_INFINITY-rlWvAKk();
        @NotNull
        private DataSize size = DataSize.Companion.getZERO();
        @NotNull
        private DataSize lostSize = DataSize.Companion.getZERO();
        private int id = -1;

        public final int getNumPackets() {
            return this.numPackets;
        }

        public final void setNumPackets(int n) {
            this.numPackets = n;
        }

        public final int getNumLostPackets() {
            return this.numLostPackets;
        }

        public final void setNumLostPackets(int n) {
            this.numLostPackets = n;
        }

        public final int getNumReceivedPackets() {
            return this.numReceivedPackets;
        }

        public final void setNumReceivedPackets(int n) {
            this.numReceivedPackets = n;
        }

        public final long getSendingRate-rlWvAKk() {
            return this.sendingRate;
        }

        public final void setSendingRate-_2icLw0(long l) {
            this.sendingRate = l;
        }

        @NotNull
        public final DataSize getSize() {
            return this.size;
        }

        public final void setSize(@NotNull DataSize dataSize) {
            Intrinsics.checkNotNullParameter((Object)dataSize, (String)"<set-?>");
            this.size = dataSize;
        }

        @NotNull
        public final DataSize getLostSize() {
            return this.lostSize;
        }

        public final void setLostSize(@NotNull DataSize dataSize) {
            Intrinsics.checkNotNullParameter((Object)dataSize, (String)"<set-?>");
            this.lostSize = dataSize;
        }

        public final int getId() {
            return this.id;
        }

        public final void setId(int n) {
            this.id = n;
        }

        public final boolean isInitialized() {
            return this.id != -1;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$PaddingInfo;", "", "<init>", "()V", "paddingRate", "Lorg/jitsi/nlj/util/Bandwidth;", "getPaddingRate-rlWvAKk", "()J", "setPaddingRate-_2icLw0", "(J)V", "J", "paddingTimestamp", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getPaddingTimestamp", "()Ljava/time/Instant;", "setPaddingTimestamp", "(Ljava/time/Instant;)V", "jitsi-media-transform"})
    private static final class PaddingInfo {
        private long paddingRate = Bandwidth.Companion.getMINUS_INFINITY-rlWvAKk();
        private Instant paddingTimestamp = Instant.MIN;

        public final long getPaddingRate-rlWvAKk() {
            return this.paddingRate;
        }

        public final void setPaddingRate-_2icLw0(long l) {
            this.paddingRate = l;
        }

        public final Instant getPaddingTimestamp() {
            return this.paddingTimestamp;
        }

        public final void setPaddingTimestamp(Instant instant) {
            this.paddingTimestamp = instant;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR-\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$PartialObservation;", "", "<init>", "()V", "numPackets", "", "getNumPackets", "()I", "setNumPackets", "(I)V", "lostPackets", "Ljava/util/HashMap;", "", "Lorg/jitsi/nlj/util/DataSize;", "Lkotlin/collections/HashMap;", "getLostPackets", "()Ljava/util/HashMap;", "size", "getSize", "()Lorg/jitsi/nlj/util/DataSize;", "setSize", "(Lorg/jitsi/nlj/util/DataSize;)V", "jitsi-media-transform"})
    private static final class PartialObservation {
        private int numPackets;
        @NotNull
        private final HashMap<Long, DataSize> lostPackets = new HashMap();
        @NotNull
        private DataSize size = DataSize.Companion.getZERO();

        public final int getNumPackets() {
            return this.numPackets;
        }

        public final void setNumPackets(int n) {
            this.numPackets = n;
        }

        @NotNull
        public final HashMap<Long, DataSize> getLostPackets() {
            return this.lostPackets;
        }

        @NotNull
        public final DataSize getSize() {
            return this.size;
        }

        public final void setSize(@NotNull DataSize dataSize) {
            Intrinsics.checkNotNullParameter((Object)dataSize, (String)"<set-?>");
            this.size = dataSize;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\tJ\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J$\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u001c\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Result;", "", "bandwidthEstimate", "Lorg/jitsi/nlj/util/Bandwidth;", "state", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedState;", "<init>", "(JLorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedState;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getBandwidthEstimate-rlWvAKk", "()J", "setBandwidthEstimate-_2icLw0", "(J)V", "J", "getState", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedState;", "setState", "(Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedState;)V", "component1", "component1-rlWvAKk", "component2", "copy", "copy-SimD6oM", "(JLorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedState;)Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2$Result;", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-media-transform"})
    public static final class Result {
        private long bandwidthEstimate;
        @NotNull
        private LossBasedState state;

        private Result(long bandwidthEstimate, LossBasedState state) {
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            this.bandwidthEstimate = bandwidthEstimate;
            this.state = state;
        }

        public /* synthetic */ Result(long l, LossBasedState lossBasedState, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = Bandwidth.Companion.getZERO-rlWvAKk();
            }
            if ((n & 2) != 0) {
                lossBasedState = LossBasedState.kDelayBasedEstimate;
            }
            this(l, lossBasedState, null);
        }

        public final long getBandwidthEstimate-rlWvAKk() {
            return this.bandwidthEstimate;
        }

        public final void setBandwidthEstimate-_2icLw0(long l) {
            this.bandwidthEstimate = l;
        }

        @NotNull
        public final LossBasedState getState() {
            return this.state;
        }

        public final void setState(@NotNull LossBasedState lossBasedState) {
            Intrinsics.checkNotNullParameter((Object)((Object)lossBasedState), (String)"<set-?>");
            this.state = lossBasedState;
        }

        public final long component1-rlWvAKk() {
            return this.bandwidthEstimate;
        }

        @NotNull
        public final LossBasedState component2() {
            return this.state;
        }

        @NotNull
        public final Result copy-SimD6oM(long l, @NotNull LossBasedState state) {
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            return new Result(l, state, null);
        }

        public static /* synthetic */ Result copy-SimD6oM$default(Result result, long l, LossBasedState lossBasedState, int n, Object object) {
            if ((n & 1) != 0) {
                l = result.bandwidthEstimate;
            }
            if ((n & 2) != 0) {
                lossBasedState = result.state;
            }
            return result.copy-SimD6oM(l, lossBasedState);
        }

        @NotNull
        public String toString() {
            return "Result(bandwidthEstimate=" + Bandwidth.toString-impl(this.bandwidthEstimate) + ", state=" + this.state + ")";
        }

        public int hashCode() {
            int result = Bandwidth.hashCode-impl(this.bandwidthEstimate);
            result = result * 31 + this.state.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (!Bandwidth.equals-impl0(this.bandwidthEstimate, result.bandwidthEstimate)) {
                return false;
            }
            return this.state == result.state;
        }

        public /* synthetic */ Result(long bandwidthEstimate, LossBasedState state, DefaultConstructorMarker $constructor_marker) {
            this(bandwidthEstimate, state);
        }
    }
}

