/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.rtp.bandwidthestimation2.LossBasedBweV2;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.InstantKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u001a\u0017\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\b\u0007\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u001a'\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"kInitHoldDuration", "Ljava/time/Duration;", "kMaxHoldDuration", "isValid", "", "datarate", "Lorg/jitsi/nlj/util/Bandwidth;", "isValid-eKiYIew", "timestamp", "Ljava/time/Instant;", "getLossProbability", "", "inherentLoss_", "lossLimitedBandwidth", "sendingRate", "getLossProbability-3l-g26c", "(DJJ)D", "jitsi-media-transform"})
public final class LossBasedBweV2Kt {
    @NotNull
    private static final Duration kInitHoldDuration = DurationKt.getMs((int)300);
    @NotNull
    private static final Duration kMaxHoldDuration = DurationKt.getSecs((int)60);

    private static final boolean isValid-eKiYIew(Bandwidth datarate) {
        Bandwidth bandwidth = datarate;
        return bandwidth != null ? Bandwidth.isFinite-impl(bandwidth.unbox-impl()) : false;
    }

    private static final boolean isValid(Instant timestamp) {
        return InstantKt.isFinite((Instant)timestamp);
    }

    private static final double getLossProbability-3l-g26c(double inherentLoss_, long l, long l2) {
        if (inherentLoss_ < 0.0 || inherentLoss_ > 1.0) {
            LossBasedBweV2.Companion.getLogger().warn((Object)("The inherent loss must be in [0,1]: " + inherentLoss_));
        }
        double inherentLoss = RangesKt.coerceIn((double)inherentLoss_, (double)0.0, (double)1.0);
        if (!Bandwidth.isFinite-impl(l2)) {
            LossBasedBweV2.Companion.getLogger().warn((Object)("The sending rate must be finite: " + Bandwidth.toString-impl(l2)));
        }
        if (!Bandwidth.isFinite-impl(l)) {
            LossBasedBweV2.Companion.getLogger().warn((Object)("The loss limited bandwidth must be finite: " + Bandwidth.toString-impl(l)));
        }
        double lossProbability = inherentLoss;
        if (LossBasedBweV2Kt.isValid-eKiYIew(Bandwidth.box-impl(l2)) && LossBasedBweV2Kt.isValid-eKiYIew(Bandwidth.box-impl(l)) && Bandwidth.compareTo-_2icLw0(l2, l) > 0) {
            lossProbability += (1.0 - inherentLoss) * Bandwidth.div-_2icLw0(Bandwidth.minus-GI7mN98(l2, l), l2);
        }
        return RangesKt.coerceIn((double)lossProbability, (double)1.0E-6, (double)0.999999);
    }

    public static final /* synthetic */ Duration access$getKInitHoldDuration$p() {
        return kInitHoldDuration;
    }

    public static final /* synthetic */ boolean access$isValid-eKiYIew(Bandwidth datarate) {
        return LossBasedBweV2Kt.isValid-eKiYIew(datarate);
    }

    public static final /* synthetic */ Duration access$getKMaxHoldDuration$p() {
        return kMaxHoldDuration;
    }

    public static final /* synthetic */ double access$getLossProbability-3l-g26c(double inherentLoss_, long l, long l2) {
        return LossBasedBweV2Kt.getLossProbability-3l-g26c(inherentLoss_, l, l2);
    }

    public static final /* synthetic */ boolean access$isValid(Instant timestamp) {
        return LossBasedBweV2Kt.isValid(timestamp);
    }
}

