/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.rtp.bandwidthestimation2.BandwidthUsage;
import org.jitsi.nlj.rtp.bandwidthestimation2.DelayIncreaseDetectorInterface;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacketTiming;
import org.jitsi.nlj.rtp.bandwidthestimation2.TrendlineEstimatorKt;
import org.jitsi.nlj.rtp.bandwidthestimation2.TrendlineEstimatorSettings;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 72\u00020\u0001:\u00017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0010J8\u0010-\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020%H\u0016J \u00101\u001a\u00020'2\u0006\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u0010H\u0002J\u0018\u00105\u001a\u00020'2\u0006\u00106\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u000e\u0010\u001f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u000e\u0010\"\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/TrendlineEstimator;", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/DelayIncreaseDetectorInterface;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;)V", "settings", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/TrendlineEstimatorSettings;", "smoothingCoef", "", "thresholdGain", "numOfDeltas", "", "firstArrivalTimeMs", "", "accumulatedDelay", "smoothedDelay", "delayHist", "Lkotlin/collections/ArrayDeque;", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacketTiming;", "kUp", "kDown", "overusingTimeThreshold", "value", "threshold", "getThreshold", "()D", "prevModifiedTrend", "getPrevModifiedTrend", "lastUpdateMs", "prevTrend", "getPrevTrend", "timeOverUsing", "overuseCounter", "hypothesis", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/BandwidthUsage;", "updateTrendline", "", "recvDeltaMs", "sendDeltaMs", "sendTimeMs", "arrivalTimeMs", "packetSize", "update", "calculatedDeltas", "", "state", "detect", "trend", "tsDelta", "nowMs", "updateThreshold", "modifiedTrend", "Companion", "jitsi-media-transform"})
public final class TrendlineEstimator
implements DelayIncreaseDetectorInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final TrendlineEstimatorSettings settings;
    private final double smoothingCoef;
    private final double thresholdGain;
    private int numOfDeltas;
    private long firstArrivalTimeMs;
    private double accumulatedDelay;
    private double smoothedDelay;
    @NotNull
    private final ArrayDeque<PacketTiming> delayHist;
    private final double kUp;
    private final double kDown;
    private final double overusingTimeThreshold;
    private double threshold;
    private double prevModifiedTrend;
    private long lastUpdateMs;
    private double prevTrend;
    private double timeOverUsing;
    private int overuseCounter;
    @NotNull
    private BandwidthUsage hypothesis;
    public static final double kDefaultTrendlineSmoothingCoeff = 0.9;
    public static final double kDefaultTrendlineThresholdGain = 4.0;
    public static final double kMaxAdaptOffsetMs = 15.0;
    public static final double kOverusingTimeThreshold = 10.0;
    public static final int kMinNumDeltas = 60;
    public static final int kDeltaCounterMax = 1000;
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(TrendlineEstimator.class);

    public TrendlineEstimator(@NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext) {
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        this.diagnosticContext = diagnosticContext;
        this.settings = new TrendlineEstimatorSettings();
        this.smoothingCoef = 0.9;
        this.thresholdGain = 4.0;
        this.firstArrivalTimeMs = -1L;
        this.delayHist = new ArrayDeque();
        this.kUp = 0.0087;
        this.kDown = 0.039;
        this.overusingTimeThreshold = 10.0;
        this.threshold = 12.5;
        this.prevModifiedTrend = Double.NaN;
        this.lastUpdateMs = -1L;
        this.timeOverUsing = -1.0;
        this.hypothesis = BandwidthUsage.kBwNormal;
    }

    public final double getThreshold() {
        return this.threshold;
    }

    public final double getPrevModifiedTrend() {
        return this.prevModifiedTrend;
    }

    public final double getPrevTrend() {
        return this.prevTrend;
    }

    public final void updateTrendline(double recvDeltaMs, double sendDeltaMs, long sendTimeMs, long arrivalTimeMs, long packetSize) {
        double deltaMs = recvDeltaMs - sendDeltaMs;
        ++this.numOfDeltas;
        this.numOfDeltas = Math.min(this.numOfDeltas, 1000);
        if (this.firstArrivalTimeMs == -1L) {
            this.firstArrivalTimeMs = arrivalTimeMs;
        }
        this.accumulatedDelay += deltaMs;
        this.smoothedDelay = this.smoothingCoef * this.smoothedDelay + (1.0 - this.smoothingCoef) * this.accumulatedDelay;
        this.delayHist.addLast((Object)new PacketTiming(arrivalTimeMs - this.firstArrivalTimeMs, this.smoothedDelay, this.accumulatedDelay));
        if (this.settings.getEnableSort()) {
            // empty if block
        }
        if (this.delayHist.size() > this.settings.getWindowSize()) {
            this.delayHist.removeFirst();
        }
        double trend = this.prevTrend;
        if (this.delayHist.size() == this.settings.getWindowSize()) {
            Double d = TrendlineEstimatorKt.access$linearFitSlope(this.delayHist);
            double d2 = trend = d != null ? d : trend;
            if (this.settings.getEnableCap()) {
                Double cap = TrendlineEstimatorKt.access$computeSlopeCap(this.delayHist, this.settings);
                if (trend >= 0.0 && cap != null && trend > cap) {
                    trend = cap;
                }
            }
        }
        timeSeriesLogger.trace(() -> TrendlineEstimator.updateTrendline$lambda$0(this));
        this.detect(trend, sendDeltaMs, arrivalTimeMs);
    }

    @Override
    public void update(double recvDeltaMs, double sendDeltaMs, long sendTimeMs, long arrivalTimeMs, long packetSize, boolean calculatedDeltas) {
        if (calculatedDeltas) {
            this.updateTrendline(recvDeltaMs, sendDeltaMs, sendTimeMs, arrivalTimeMs, packetSize);
        }
    }

    @Override
    @NotNull
    public BandwidthUsage state() {
        return this.hypothesis;
    }

    private final void detect(double trend, double tsDelta, long nowMs) {
        double modifiedTrend;
        if (this.numOfDeltas < 2) {
            this.hypothesis = BandwidthUsage.kBwNormal;
            return;
        }
        this.prevModifiedTrend = modifiedTrend = (double)Math.min(this.numOfDeltas, 60) * trend * this.thresholdGain;
        timeSeriesLogger.trace(() -> TrendlineEstimator.detect$lambda$0(this, nowMs, modifiedTrend));
        if (modifiedTrend > this.threshold) {
            this.timeOverUsing = this.timeOverUsing == -1.0 ? tsDelta / (double)2 : (this.timeOverUsing += tsDelta);
            int n = this.overuseCounter;
            this.overuseCounter = n + 1;
            if (this.timeOverUsing > this.overusingTimeThreshold && this.overuseCounter > 1 && trend >= this.prevTrend) {
                this.timeOverUsing = 0.0;
                this.overuseCounter = 0;
                this.hypothesis = BandwidthUsage.kBwOverusing;
            }
        } else if (modifiedTrend < -this.threshold) {
            this.timeOverUsing = -1.0;
            this.overuseCounter = 0;
            this.hypothesis = BandwidthUsage.kBwUnderusing;
        } else {
            this.timeOverUsing = -1.0;
            this.overuseCounter = 0;
            this.hypothesis = BandwidthUsage.kBwNormal;
        }
        this.prevTrend = trend;
        this.updateThreshold(modifiedTrend, nowMs);
    }

    private final void updateThreshold(double modifiedTrend, long nowMs) {
        if (this.lastUpdateMs == -1L) {
            this.lastUpdateMs = nowMs;
        }
        if (Math.abs(modifiedTrend) > this.threshold + 15.0) {
            this.lastUpdateMs = nowMs;
            return;
        }
        double k = Math.abs(modifiedTrend) < this.threshold ? this.kDown : this.kUp;
        long kMaxTimeDeltaMs = 100L;
        long timeDeltaMs = Math.min(nowMs - this.lastUpdateMs, kMaxTimeDeltaMs);
        this.threshold += k * (Math.abs(modifiedTrend) - this.threshold) * (double)timeDeltaMs;
        this.threshold = RangesKt.coerceIn((double)this.threshold, (double)6.0, (double)600.0);
        this.lastUpdateMs = nowMs;
    }

    private static final Map updateTrendline$lambda$0(TrendlineEstimator this$0) {
        return (Map)this$0.diagnosticContext.makeTimeSeriesPoint("trendline_updated").addField("accumulated_delay_ms", (Object)this$0.accumulatedDelay).addField("smoothed_delay_ms", (Object)this$0.smoothedDelay);
    }

    private static final Map detect$lambda$0(TrendlineEstimator this$0, long $nowMs, double $modifiedTrend) {
        return (Map)this$0.diagnosticContext.makeTimeSeriesPoint("trendline_detect", $nowMs).addField("trend", (Object)$modifiedTrend).addField("threshold", (Object)this$0.threshold);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/TrendlineEstimator$Companion;", "", "<init>", "()V", "kDefaultTrendlineSmoothingCoeff", "", "kDefaultTrendlineThresholdGain", "kMaxAdaptOffsetMs", "kOverusingTimeThreshold", "kMinNumDeltas", "", "kDeltaCounterMax", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

