/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.RtxPayloadType;
import org.jitsi.nlj.rtp.RtxPacket;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/RtxHandler;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "numPaddingPacketsReceived", "", "numRtxPacketsReceived", "rtxPtToRtxPayloadType", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jitsi/nlj/format/RtxPayloadType;", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "statsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "trace", "", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nRtxHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtxHandler.kt\norg/jitsi/nlj/transform/node/incoming/RtxHandler\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n63#2,4:112\n63#2,4:116\n808#3,11:120\n1563#3:131\n1634#3,3:132\n*S KotlinDebug\n*F\n+ 1 RtxHandler.kt\norg/jitsi/nlj/transform/node/incoming/RtxHandler\n*L\n77#1:112,4\n90#1:116,4\n55#1:120,11\n56#1:131\n56#1:132,3\n*E\n"})
public final class RtxHandler
extends TransformerNode {
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformationStore;
    @NotNull
    private final Logger logger;
    private int numPaddingPacketsReceived;
    private int numRtxPacketsReceived;
    @NotNull
    private final ConcurrentHashMap<Integer, RtxPayloadType> rtxPtToRtxPayloadType;

    public RtxHandler(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)streamInformationStore, (String)"streamInformationStore");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        super("RTX handler");
        this.streamInformationStore = streamInformationStore;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.rtxPtToRtxPayloadType = new ConcurrentHashMap();
        this.streamInformationStore.onRtpPayloadTypesChanged((Function1<? super Map<Byte, ? extends PayloadType>, Unit>)((Function1)arg_0 -> RtxHandler._init_$lambda$0(this, arg_0)));
    }

    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
        RtxPayloadType rtxPayloadType = this.rtxPtToRtxPayloadType.get(UnsignedKt.toPositiveInt((Number)rtpPacket.getPayloadType()));
        if (rtxPayloadType == null) {
            return packetInfo;
        }
        RtxPayloadType rtxPayloadType2 = rtxPayloadType;
        Long l = this.streamInformationStore.getLocalPrimarySsrc(rtpPacket.getSsrc());
        if (l == null) {
            return packetInfo;
        }
        long originalSsrc = l;
        if (packetInfo.getShouldDiscard()) {
            return null;
        }
        if (rtpPacket.getPayloadLength() - rtpPacket.getPaddingSize() < 2) {
            Logger $this$cdebug$iv22 = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv22.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv22;
                boolean bl = false;
                logger.debug((Object)"RTX packet is padding, ignore");
            }
            int $this$cdebug$iv22 = this.numPaddingPacketsReceived;
            this.numPaddingPacketsReceived = $this$cdebug$iv22 + 1;
            return null;
        }
        int originalSeqNum = RtxPacket.Companion.getOriginalSequenceNumber(rtpPacket);
        int originalPt = rtxPayloadType2.getAssociatedPayloadType();
        RtxPacket.Companion.removeOriginalSequenceNumber(rtpPacket);
        rtpPacket.setSequenceNumber(originalSeqNum);
        rtpPacket.setPayloadType(originalPt);
        rtpPacket.setSsrc(originalSsrc);
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug((Object)("Recovered RTX packet.  Original packet: " + originalSsrc + " " + originalSeqNum));
        }
        int n = this.numRtxPacketsReceived;
        this.numRtxPacketsReceived = n + 1;
        packetInfo.resetPayloadVerification();
        return packetInfo;
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u240 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u240.addNumber("num_rtx_packets_received", this.numRtxPacketsReceived);
        $this$getNodeStats_u24lambda_u240.addNumber("num_padding_packets_received", this.numPaddingPacketsReceived);
        $this$getNodeStats_u24lambda_u240.addString("rtx_payload_types", this.rtxPtToRtxPayloadType.values().toString());
        return nodeStatsBlock;
    }

    @Override
    @NotNull
    public OrderedJsonObject statsJson() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$statsJson_u24lambda_u240 = orderedJsonObject = super.statsJson();
        boolean bl = false;
        ((Map)$this$statsJson_u24lambda_u240).put("num_rtx_packets_received", this.numRtxPacketsReceived);
        ((Map)$this$statsJson_u24lambda_u240).put("num_padding_packets_received", this.numPaddingPacketsReceived);
        return orderedJsonObject;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        f.invoke();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$0(RtxHandler this$0, Map currentPayloadTypes) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)currentPayloadTypes, (String)"currentPayloadTypes");
        this$0.rtxPtToRtxPayloadType.clear();
        Iterable $this$filterIsInstance$iv = currentPayloadTypes.values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RtxPayloadType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RtxPayloadType rtxPayloadType = (RtxPayloadType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ((Map)this$0.rtxPtToRtxPayloadType).put(UnsignedKt.toPositiveInt((byte)it.getPt()), it);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return Unit.INSTANCE;
    }
}

