/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.outgoing;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.DebugStateMode;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.EventHandler;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.PacketOrigin;
import org.jitsi.nlj.SetLocalSsrcEvent;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.RtxPayloadType;
import org.jitsi.nlj.format.VideoPayloadType;
import org.jitsi.nlj.rtp.PaddingVideoPacket;
import org.jitsi.nlj.util.PacketCache;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ(\u0010\u001f\u001a\u00020 2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u001e2\u0006\u0010\"\u001a\u00020 2\b\u0010#\u001a\u0004\u0018\u00010$J\"\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020 2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u001a\u0010)\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jitsi/nlj/transform/node/outgoing/ProbingDataSender;", "Lorg/jitsi/nlj/EventHandler;", "packetCache", "Lorg/jitsi/nlj/util/PacketCache;", "rtxDataSender", "Lorg/jitsi/nlj/PacketHandler;", "garbageDataSender", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/nlj/util/PacketCache;Lorg/jitsi/nlj/PacketHandler;Lorg/jitsi/nlj/PacketHandler;Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;)V", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "logger", "rtxSupported", "", "videoPayloadTypes", "", "Lorg/jitsi/nlj/format/VideoPayloadType;", "localVideoSsrc", "", "Ljava/lang/Long;", "numProbingBytesSentRtx", "numProbingBytesSentDummyData", "lastMediaSsrcs", "", "sendProbing", "", "mediaSsrcsIn", "numBytes", "probingInfo", "", "sendRedundantDataOverRtx", "mediaSsrc", "currDummyTimestamp", "currDummySeqNum", "sendDummyData", "handleEvent", "", "event", "Lorg/jitsi/nlj/Event;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "mode", "Lorg/jitsi/nlj/DebugStateMode;", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nProbingDataSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProbingDataSender.kt\norg/jitsi/nlj/transform/node/outgoing/ProbingDataSender\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n*L\n1#1,218:1\n1869#2,2:219\n1869#2:225\n1870#2:230\n63#3,4:221\n63#3,4:226\n*S KotlinDebug\n*F\n+ 1 ProbingDataSender.kt\norg/jitsi/nlj/transform/node/outgoing/ProbingDataSender\n*L\n147#1:219,2\n78#1:225\n78#1:230\n195#1:221,4\n81#1:226,4\n*E\n"})
public final class ProbingDataSender
implements EventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PacketCache packetCache;
    @NotNull
    private final PacketHandler rtxDataSender;
    @NotNull
    private final PacketHandler garbageDataSender;
    @NotNull
    private final DiagnosticContext diagnosticContext;
    private final TimeSeriesLogger timeSeriesLogger;
    @NotNull
    private final Logger logger;
    private boolean rtxSupported;
    @NotNull
    private final Set<VideoPayloadType> videoPayloadTypes;
    @Nullable
    private Long localVideoSsrc;
    private long numProbingBytesSentRtx;
    private long numProbingBytesSentDummyData;
    @NotNull
    private Collection<Long> lastMediaSsrcs;
    private long currDummyTimestamp;
    private int currDummySeqNum;
    @NotNull
    private static final Random random = new Random();

    public ProbingDataSender(@NotNull PacketCache packetCache, @NotNull PacketHandler rtxDataSender, @NotNull PacketHandler garbageDataSender, @NotNull DiagnosticContext diagnosticContext, @NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)packetCache, (String)"packetCache");
        Intrinsics.checkNotNullParameter((Object)rtxDataSender, (String)"rtxDataSender");
        Intrinsics.checkNotNullParameter((Object)garbageDataSender, (String)"garbageDataSender");
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        Intrinsics.checkNotNullParameter((Object)streamInformationStore, (String)"streamInformationStore");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this.packetCache = packetCache;
        this.rtxDataSender = rtxDataSender;
        this.garbageDataSender = garbageDataSender;
        this.diagnosticContext = diagnosticContext;
        this.timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(this.getClass());
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.videoPayloadTypes = keySetView;
        this.lastMediaSsrcs = CollectionsKt.emptyList();
        streamInformationStore.onRtpPayloadTypesChanged((Function1<? super Map<Byte, ? extends PayloadType>, Unit>)((Function1)arg_0 -> ProbingDataSender._init_$lambda$0(this, arg_0)));
        this.currDummyTimestamp = random.nextLong() & 0xFFFFFFFFL;
        this.currDummySeqNum = random.nextInt(65535);
    }

    public final int sendProbing(@Nullable Collection<Long> mediaSsrcsIn, int numBytes, @Nullable Object probingInfo) {
        Collection<Long> mediaSsrcs;
        Collection<Long> collection;
        int totalBytesSent = 0;
        if (mediaSsrcsIn != null) {
            this.lastMediaSsrcs = mediaSsrcsIn;
            collection = mediaSsrcsIn;
        } else {
            collection = mediaSsrcs = this.lastMediaSsrcs;
        }
        if (this.rtxSupported) {
            Iterator<Long> iterator = mediaSsrcs.iterator();
            while (iterator.hasNext()) {
                long mediaSsrc = ((Number)iterator.next()).longValue();
                if (totalBytesSent >= numBytes) break;
                int rtxBytesSent = this.sendRedundantDataOverRtx(mediaSsrc, numBytes - totalBytesSent, probingInfo);
                this.numProbingBytesSentRtx += (long)rtxBytesSent;
                totalBytesSent += rtxBytesSent;
                if (!this.timeSeriesLogger.isTraceEnabled()) continue;
                this.timeSeriesLogger.trace((Map)this.diagnosticContext.makeTimeSeriesPoint("rtx_probing_bytes").addField("ssrc", (Object)mediaSsrc).addField("bytes", (Object)rtxBytesSent));
            }
        }
        if (totalBytesSent < numBytes) {
            int dummyBytesSent = this.sendDummyData(numBytes - totalBytesSent, probingInfo);
            this.numProbingBytesSentDummyData += (long)dummyBytesSent;
            totalBytesSent += dummyBytesSent;
            if (this.timeSeriesLogger.isTraceEnabled()) {
                this.timeSeriesLogger.trace((Map)this.diagnosticContext.makeTimeSeriesPoint("dummy_probing_bytes").addField("bytes", (Object)dummyBytesSent));
            }
        }
        return totalBytesSent;
    }

    private final int sendRedundantDataOverRtx(long mediaSsrc, int numBytes, Object probingInfo) {
        int bytesSent = 0;
        Iterable $this$forEach$iv = this.packetCache.getMany(mediaSsrc, numBytes);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtpPacket it = (RtpPacket)element$iv;
            boolean bl = false;
            bytesSent += it.length;
            PacketInfo packetInfo = new PacketInfo((Packet)it, 0, null, 6, null);
            packetInfo.setProbingInfo(probingInfo);
            packetInfo.setPacketOrigin(probingInfo != null ? PacketOrigin.Probing : PacketOrigin.Padding);
            this.rtxDataSender.processPacket(packetInfo);
        }
        return bytesSent;
    }

    private final int sendDummyData(int numBytes, Object probingInfo) {
        int remainingBytes;
        int packetLength;
        int bytesSent;
        VideoPayloadType videoPayloadType = (VideoPayloadType)CollectionsKt.firstOrNull((Iterable)this.videoPayloadTypes);
        if (videoPayloadType == null) {
            return bytesSent;
        }
        VideoPayloadType pt = videoPayloadType;
        Long l = this.localVideoSsrc;
        if (l == null) {
            return bytesSent;
        }
        long senderSsrc = l;
        for (bytesSent = 0; bytesSent < numBytes && (remainingBytes = numBytes - bytesSent) >= 12; bytesSent += packetLength) {
            int paddingSize = RangesKt.coerceAtMost((int)(remainingBytes - 12), (int)255);
            packetLength = 12 + paddingSize;
            PaddingVideoPacket paddingPacket = PaddingVideoPacket.Companion.create(packetLength);
            paddingPacket.setPayloadType(UnsignedKt.toPositiveInt((byte)pt.getPt()));
            paddingPacket.setSsrc(senderSsrc);
            paddingPacket.setTimestamp(this.currDummyTimestamp);
            paddingPacket.setSequenceNumber(this.currDummySeqNum);
            PacketInfo packetInfo = new PacketInfo((Packet)paddingPacket, 0, null, 6, null);
            packetInfo.setProbingInfo(probingInfo);
            packetInfo.setPacketOrigin(probingInfo != null ? PacketOrigin.Probing : PacketOrigin.Padding);
            this.garbageDataSender.processPacket(packetInfo);
            int n = this.currDummySeqNum;
            this.currDummySeqNum = n + 1;
        }
        this.currDummyTimestamp += (long)3000;
        return bytesSent;
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof SetLocalSsrcEvent && MediaType.VIDEO == ((SetLocalSsrcEvent)event).getMediaType()) {
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug((Object)("Setting video ssrc to " + ((SetLocalSsrcEvent)event).getSsrc()));
            }
            this.localVideoSsrc = ((SetLocalSsrcEvent)event).getSsrc();
        }
    }

    @NotNull
    public final OrderedJsonObject debugState(@NotNull DebugStateMode mode) {
        OrderedJsonObject orderedJsonObject;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        OrderedJsonObject $this$debugState_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        ((Map)$this$debugState_u24lambda_u240).put("num_bytes_of_probing_data_sent_as_rtx", this.numProbingBytesSentRtx);
        ((Map)$this$debugState_u24lambda_u240).put("num_bytes_of_probing_data_sent_as_dummy", this.numProbingBytesSentDummyData);
        ((Map)$this$debugState_u24lambda_u240).put("rtx_supported", this.rtxSupported);
        if (mode == DebugStateMode.FULL) {
            ((Map)$this$debugState_u24lambda_u240).put("local_video_ssrc", String.valueOf(this.localVideoSsrc));
            ((Map)$this$debugState_u24lambda_u240).put("curr_dummy_timestamp", String.valueOf(this.currDummyTimestamp));
            ((Map)$this$debugState_u24lambda_u240).put("curr_dummy_seq_num", String.valueOf(this.currDummySeqNum));
            ((Map)$this$debugState_u24lambda_u240).put("video_payload_types", this.videoPayloadTypes.toString());
        }
        return orderedJsonObject;
    }

    private static final Unit _init_$lambda$0(ProbingDataSender this$0, Map currentRtpPayloadTypes) {
        Intrinsics.checkNotNullParameter((Object)currentRtpPayloadTypes, (String)"currentRtpPayloadTypes");
        if (currentRtpPayloadTypes.isEmpty()) {
            this$0.videoPayloadTypes.clear();
            this$0.rtxSupported = false;
        } else {
            Iterable $this$forEach$iv = currentRtpPayloadTypes.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PayloadType pt = (PayloadType)element$iv;
                boolean bl = false;
                if (!this$0.rtxSupported && pt instanceof RtxPayloadType) {
                    this$0.rtxSupported = true;
                    Logger $this$cdebug$iv = this$0.logger;
                    boolean $i$f$cdebug = false;
                    if ($this$cdebug$iv.isDebugEnabled()) {
                        Logger logger = $this$cdebug$iv;
                        boolean bl2 = false;
                        logger.debug((Object)"RTX payload type signaled, enabling RTX probing");
                    }
                }
                if (!(pt instanceof VideoPayloadType)) continue;
                this$0.videoPayloadTypes.add((VideoPayloadType)pt);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/nlj/transform/node/outgoing/ProbingDataSender$Companion;", "", "<init>", "()V", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Random getRandom() {
            return random;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

